/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.details.generator.impl;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.details.DetailsCellContent;
import info.novatec.inspectit.rcp.details.DetailsTable;
import info.novatec.inspectit.rcp.details.generator.IDetailsGenerator;
import info.novatec.inspectit.rcp.model.ModifiersImageFactory;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MethodInfoDetailsGenerator
implements IDetailsGenerator {
    @Override
    public boolean canGenerateFor(DefaultData defaultData) {
        return defaultData instanceof MethodSensorData && ((MethodSensorData)defaultData).getMethodIdent() != 0L;
    }

    @Override
    public DetailsTable generate(DefaultData defaultData, RepositoryDefinition repositoryDefinition, Composite composite, FormToolkit formToolkit) {
        MethodSensorData methodSensorData = (MethodSensorData)defaultData;
        MethodIdent methodIdent = repositoryDefinition.getCachedDataService().getMethodIdentForId(methodSensorData.getMethodIdent());
        DetailsTable detailsTable = new DetailsTable(composite, formToolkit, "Method Info", 1);
        detailsTable.addContentRow("Package:", InspectIT.getDefault().getImage("/icons/eclipse/package_obj.gif"), new DetailsCellContent(methodIdent.getPackageName()));
        detailsTable.addContentRow("Class:", InspectIT.getDefault().getImage("/icons/eclipse/class_obj.gif"), new DetailsCellContent(methodIdent.getClassName()));
        String string = "";
        if (CollectionUtils.isNotEmpty((Collection)methodIdent.getParameters())) {
            string = methodIdent.getParameters().toString();
            string = string.substring(1, string.length() - 1);
        }
        String string2 = String.valueOf(methodIdent.getMethodName()) + "(" + string + ")";
        detailsTable.addContentRow("Method:", ModifiersImageFactory.getImage(methodIdent.getModifiers()), new DetailsCellContent(string2));
        String string3 = methodIdent.getReturnType();
        if (StringUtils.isBlank((String)string3)) {
            string3 = "void";
        }
        detailsTable.addContentRow("Return Type:", null, new DetailsCellContent(string3));
        DetailsCellContent detailsCellContent = new DetailsCellContent();
        detailsCellContent.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
        if (methodIdent.hasActiveSensorTypes()) {
            detailsCellContent.setText("Active ");
            detailsCellContent.setImageToolTip("Method is currently instrumented and captures data.");
        } else {
            detailsCellContent.setText("Not-active ");
            detailsCellContent.setImageToolTip("Method is currently not instrumented and  doesn't capture data.");
        }
        detailsTable.addContentRow("Instrumentation:", null, detailsCellContent);
        return detailsTable;
    }
}

