/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.wizard;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.job.OpenProfileJob;
import info.novatec.inspectit.rcp.ci.wizard.page.DefineNameAndDescriptionWizardPage;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateProfileWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "Create New Profile";
    private static final String DUPLICATE_TITLE = "Duplicate Profile";
    private static final String MESSAGE = "Define the information for the new Profile";
    private Profile duplicateProfile;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private DefineNameAndDescriptionWizardPage defineNameAndDescriptionWizardPage;
    private IWorkbench workbench;

    public CreateProfileWizard() {
        this.setWindowTitle(TITLE);
    }

    public CreateProfileWizard(Profile profile) {
        Assert.isNotNull((Object)profile);
        this.duplicateProfile = profile;
        this.setWindowTitle(this.getTitle());
    }

    public void addPages() {
        this.defineNameAndDescriptionWizardPage = new DefineNameAndDescriptionWizardPage(this.getTitle(), MESSAGE);
        this.addPage((IWizardPage)this.defineNameAndDescriptionWizardPage);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        StructuredSelection structuredSelection = (StructuredSelection)iStructuredSelection;
        if (structuredSelection.getFirstElement() instanceof ICmrRepositoryProvider) {
            this.cmrRepositoryDefinition = ((ICmrRepositoryProvider)structuredSelection.getFirstElement()).getCmrRepositoryDefinition();
        }
    }

    public boolean performFinish() {
        if (this.cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            InspectIT.getDefault().createErrorDialog("Profile can not be created. Selected CMR repository is currently not available.", -1);
            return false;
        }
        String string = this.defineNameAndDescriptionWizardPage.getName();
        String string2 = this.defineNameAndDescriptionWizardPage.getDescription();
        Profile profile = new Profile();
        profile.setName(string);
        if (StringUtils.isNotBlank((String)string2)) {
            profile.setDescription(string2);
        }
        if (this.isDuplicate()) {
            profile.setMethodSensorAssignments(this.duplicateProfile.getMethodSensorAssignments());
            profile.setExceptionSensorAssignments(this.duplicateProfile.getExceptionSensorAssignments());
            profile.setExcludeRules(this.duplicateProfile.getExcludeRules());
            profile.setActive(this.duplicateProfile.isActive());
            profile.setDefaultProfile(this.duplicateProfile.isDefaultProfile());
        }
        try {
            Profile profile2 = this.cmrRepositoryDefinition.getConfigurationInterfaceService().createProfile(profile);
            new OpenProfileJob(this.cmrRepositoryDefinition, profile2.getId(), this.workbench.getActiveWorkbenchWindow().getActivePage()).schedule();
            InspectIT.getDefault().getInspectITConfigurationInterfaceManager().profileCreated(profile2, this.cmrRepositoryDefinition);
        }
        catch (BusinessException businessException) {
            InspectIT.getDefault().createErrorDialog("Profile can not be created.", businessException, -1);
            return false;
        }
        return true;
    }

    private String getTitle() {
        if (this.isDuplicate()) {
            return DUPLICATE_TITLE;
        }
        return TITLE;
    }

    private boolean isDuplicate() {
        return this.duplicateProfile != null;
    }
}

