/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.view;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.provider.IProfileProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

class ProfileLabelProvider
extends StyledCellIndexLabelProvider {
    private static final StyledString EMPTY = new StyledString();

    ProfileLabelProvider() {
    }

    @Override
    protected StyledString getStyledText(Object object, int n) {
        if (object instanceof IProfileProvider) {
            Profile profile = ((IProfileProvider)object).getProfile();
            switch (n) {
                case 0: {
                    return new StyledString(profile.getName());
                }
                case 1: {
                    if (profile.getUpdatedDate() != null) {
                        return new StyledString(NumberFormatter.formatTime(profile.getUpdatedDate()));
                    }
                    return new StyledString(NumberFormatter.formatTime(profile.getCreatedDate()));
                }
                case 4: {
                    return TextFormatter.emptyStyledStringIfNull(TextFormatter.clearLineBreaks(profile.getDescription()));
                }
            }
            return EMPTY;
        }
        return EMPTY;
    }

    @Override
    protected Image getColumnImage(Object object, int n) {
        if (object instanceof IProfileProvider) {
            Profile profile = ((IProfileProvider)object).getProfile();
            switch (n) {
                case 0: {
                    return ImageFormatter.getProfileImage(profile);
                }
                case 2: {
                    return profile.isActive() ? InspectIT.getDefault().getImage("/icons/eclipse/complete_status.gif") : null;
                }
                case 3: {
                    return profile.isDefaultProfile() ? InspectIT.getDefault().getImage("/icons/eclipse/complete_status.gif") : null;
                }
            }
            return super.getColumnImage(object, n);
        }
        return super.getColumnImage(object, n);
    }

    @Override
    protected Color getForeground(Object object, int n) {
        Profile profile;
        if (object instanceof IProfileProvider && (profile = ((IProfileProvider)object).getProfile()).isCommonProfile()) {
            return Display.getCurrent().getSystemColor(14);
        }
        return super.getForeground(object, n);
    }
}

