/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.view;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.provider.IEnvironmentProvider;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

class EnvironmentLabelProvider
extends StyledCellIndexLabelProvider {
    private static final StyledString EMPTY = new StyledString();

    EnvironmentLabelProvider() {
    }

    @Override
    protected StyledString getStyledText(Object object, int n) {
        if (object instanceof IEnvironmentProvider) {
            Environment environment = ((IEnvironmentProvider)object).getEnvironment();
            switch (n) {
                case 0: {
                    return new StyledString(environment.getName());
                }
                case 1: {
                    if (CollectionUtils.isEmpty((Collection)environment.getProfileIds())) {
                        return new StyledString(String.valueOf(0));
                    }
                    return new StyledString(String.valueOf(environment.getProfileIds().size()));
                }
                case 2: {
                    return TextFormatter.emptyStyledStringIfNull(TextFormatter.clearLineBreaks(environment.getDescription()));
                }
            }
            return EMPTY;
        }
        return EMPTY;
    }

    @Override
    protected Image getColumnImage(Object object, int n) {
        if (object instanceof IEnvironmentProvider) {
            switch (n) {
                case 0: {
                    return ImageFormatter.getEnvironmentImage(((IEnvironmentProvider)object).getEnvironment());
                }
            }
            return super.getColumnImage(object, n);
        }
        return super.getColumnImage(object, n);
    }
}

