/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.ci.exclude.ExcludeRule;
import info.novatec.inspectit.rcp.ci.form.input.ProfileEditorInput;
import info.novatec.inspectit.rcp.validation.validator.FqnWildcardValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExcludeRulesPart
extends AbstractFormPart
implements IPropertyListener {
    private boolean canEdit = true;
    private List<ExcludeRule> excludeRules = new ArrayList<ExcludeRule>();
    private Profile profile;
    protected FormPage formPage;
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;

    public ExcludeRulesPart(FormPage formPage, Composite composite, FormToolkit formToolkit) {
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        ProfileEditorInput profileEditorInput = (ProfileEditorInput)formPage.getEditor().getEditorInput();
        this.profile = profileEditorInput.getProfile();
        this.createPart(composite, formToolkit);
    }

    private void createPart(Composite composite, FormToolkit formToolkit) {
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Table table = formToolkit.createTable(composite2, 68354);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 400;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (CollectionUtils.isNotEmpty((Collection)this.profile.getExcludeRules())) {
            this.excludeRules.addAll(this.profile.getExcludeRules());
        }
        this.tableViewer.setInput(this.excludeRules);
        this.tableViewer.refresh();
        Composite composite3 = formToolkit.createComposite(composite2);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.addButton = formToolkit.createButton(composite3, "Add", 8);
        this.addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExcludeRule excludeRule = ExcludeRulesPart.this.addRequested();
                if (excludeRule != null) {
                    ExcludeRulesPart.this.excludeRules.add(excludeRule);
                    ExcludeRulesPart.this.tableViewer.refresh();
                    ExcludeRulesPart.this.showHideFormMessage();
                    if (!ExcludeRulesPart.this.isDirty()) {
                        ExcludeRulesPart.this.markDirty();
                    }
                }
            }
        });
        this.removeButton = formToolkit.createButton(composite3, "Remove", 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ExcludeRulesPart.this.tableViewer.getSelection().isEmpty()) {
                    StructuredSelection structuredSelection = (StructuredSelection)ExcludeRulesPart.this.tableViewer.getSelection();
                    for (Object e : structuredSelection.toList()) {
                        ExcludeRulesPart.this.excludeRules.remove(e);
                    }
                    ExcludeRulesPart.this.tableViewer.refresh();
                    ExcludeRulesPart.this.showHideFormMessage();
                    if (!ExcludeRulesPart.this.isDirty()) {
                        ExcludeRulesPart.this.markDirty();
                    }
                }
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ExcludeRulesPart.this.removeButton.setEnabled(!ExcludeRulesPart.this.tableViewer.getSelection().isEmpty() && ExcludeRulesPart.this.canEdit);
            }
        });
        this.canEditCheck();
        this.showHideFormMessage();
    }

    private void canEditCheck() {
        boolean bl = this.canEdit = !this.profile.isCommonProfile();
        if (!this.canEdit) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void showHideFormMessage() {
        if (this.profile.isCommonProfile()) {
            this.formPage.getManagedForm().getMessageManager().addMessage((Object)this, "Common profiles can not be edited", null, 0);
        } else if (this.excludeRules.isEmpty()) {
            this.formPage.getManagedForm().getMessageManager().addMessage((Object)this, "No exclude rule defined", null, 1);
        } else {
            this.formPage.getManagedForm().getMessageManager().removeMessage((Object)this);
        }
    }

    private ExcludeRule addRequested() {
        InputDialog inputDialog = new InputDialog(this.getManagedForm().getForm().getShell(), "New Exclude Rule", "Enter class name or pattern:", "", (IInputValidator)new FqnWildcardValidator(false, false));
        if (inputDialog.open() == 0) {
            ExcludeRule excludeRule = new ExcludeRule();
            excludeRule.setClassName(inputDialog.getValue());
            return excludeRule;
        }
        return null;
    }

    private void createColumns() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.getColumn().setResizable(false);
        tableViewerColumn.getColumn().setWidth(400);
        tableViewerColumn.getColumn().setText("Rule");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((ExcludeRule)object).getClassName();
            }
        });
    }

    public void commit(boolean bl) {
        if (bl) {
            super.commit(bl);
            this.profile.setExcludeRules(new ArrayList<ExcludeRule>(this.excludeRules));
        }
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            ProfileEditorInput profileEditorInput = (ProfileEditorInput)this.formPage.getEditor().getEditorInput();
            this.profile = profileEditorInput.getProfile();
        }
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
        super.dispose();
    }
}

