/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.editor;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.editor.AbstractConfigurationInterfaceFormEditor;
import info.novatec.inspectit.rcp.ci.form.input.ProfileEditorInput;
import info.novatec.inspectit.rcp.ci.form.page.ExcludeRulesPage;
import info.novatec.inspectit.rcp.ci.form.page.MethodSensorDefinitionsPage;
import info.novatec.inspectit.rcp.ci.listener.IProfileChangeListener;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class ProfileEditor
extends AbstractConfigurationInterfaceFormEditor
implements IProfileChangeListener {
    public static final String ID = "info.novatec.inspectit.rcp.ci.editor.profileEditor";

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof ProfileEditorInput)) {
            throw new PartInitException("Editor input must be of a type: " + ProfileEditorInput.class.getName());
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        ProfileEditorInput profileEditorInput = (ProfileEditorInput)iEditorInput;
        this.setPartName(profileEditorInput.getName());
        this.setTitleImage(ImageFormatter.getProfileImage(profileEditorInput.getProfile()));
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().addProfileChangeListener(this);
    }

    protected void addPages() {
        try {
            int n = 0;
            Profile profile = ((ProfileEditorInput)this.getEditorInput()).getProfile();
            if (!profile.isCommonProfile() || CollectionUtils.isNotEmpty((Collection)profile.getMethodSensorAssignments()) || CollectionUtils.isNotEmpty((Collection)profile.getExceptionSensorAssignments())) {
                this.addPage((IFormPage)new MethodSensorDefinitionsPage(this));
                this.setPageImage(n++, InspectIT.getDefault().getImage("/icons/eclipse/method_time.gif"));
            }
            if (!profile.isCommonProfile() || CollectionUtils.isNotEmpty((Collection)profile.getExcludeRules())) {
                this.addPage((IFormPage)new ExcludeRulesPage(this));
                this.setPageImage(n++, InspectIT.getDefault().getImage("/icons/eclipse/class_exclude.gif"));
            }
        }
        catch (PartInitException partInitException) {
            InspectIT.getDefault().log(4, "Error occurred trying to open the Environment editor.", partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("Saving profile..", -1);
        if (!this.checkValid()) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        this.commitPages(true);
        ProfileEditorInput profileEditorInput = (ProfileEditorInput)this.getEditorInput();
        CmrRepositoryDefinition cmrRepositoryDefinition = profileEditorInput.getCmrRepositoryDefinition();
        Profile profile = profileEditorInput.getProfile();
        if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            try {
                this.commitPages(true);
                Profile profile2 = cmrRepositoryDefinition.getConfigurationInterfaceService().updateProfile(profile);
                if (profile2 != null) {
                    InspectIT.getDefault().getInspectITConfigurationInterfaceManager().profileUpdated(profile2, cmrRepositoryDefinition, false);
                }
                this.setExceptionOnSave(false);
                this.editorDirtyStateChanged();
            }
            catch (BusinessException businessException) {
                iProgressMonitor.setCanceled(true);
                this.setExceptionOnSave(true);
                this.editorDirtyStateChanged();
                InspectIT.getDefault().createErrorDialog("Saving of the profile '" + profile.getName() + "' failed due to the exception on the CMR.", businessException, -1);
            }
            catch (Throwable throwable) {
                iProgressMonitor.setCanceled(true);
                this.setExceptionOnSave(true);
                this.editorDirtyStateChanged();
                InspectIT.getDefault().createErrorDialog("Unexpected exception occurred during an attempt to save the profile '" + profile.getName() + "'.", throwable, -1);
            }
        } else {
            iProgressMonitor.setCanceled(true);
            InspectIT.getDefault().createErrorDialog("Saving of the profile '" + profile.getName() + "' failed because CMR is currently not online.", -1);
        }
        iProgressMonitor.done();
    }

    @Override
    public void profileCreated(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void profileUpdated(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
        ProfileEditorInput profileEditorInput = (ProfileEditorInput)this.getEditorInput();
        if (!Objects.equals(cmrRepositoryDefinition, profileEditorInput.getCmrRepositoryDefinition())) {
            return;
        }
        if (Objects.equals(profileEditorInput.getProfile().getId(), profile.getId())) {
            final ProfileEditorInput profileEditorInput2 = new ProfileEditorInput(profile, profileEditorInput.getCmrRepositoryDefinition());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProfileEditor.this.setPartName(profileEditorInput2.getName());
                    ProfileEditor.this.setTitleImage(ImageFormatter.getProfileImage(profileEditorInput2.getProfile()));
                    ProfileEditor.this.setInputWithNotify(profileEditorInput2);
                }
            });
        }
    }

    @Override
    public void profileDeleted(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition) {
        ProfileEditorInput profileEditorInput = (ProfileEditorInput)this.getEditorInput();
        if (!Objects.equals(cmrRepositoryDefinition, profileEditorInput.getCmrRepositoryDefinition())) {
            return;
        }
        if (Objects.equals(profileEditorInput.getProfile().getId(), profile.getId())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProfileEditor.this.close(false);
                }
            });
        }
    }

    public void dispose() {
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().removeProfileChangeListener(this);
        super.dispose();
    }
}

