/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class AbstractConfigurationInterfaceFormEditor
extends FormEditor {
    private boolean exceptionOnSave;

    protected void createPages() {
        super.createPages();
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    protected boolean checkValid() {
        Collection<IManagedForm> collection = this.getInvalidForms();
        if (CollectionUtils.isNotEmpty(collection)) {
            StringBuilder stringBuilder = new StringBuilder("Save can not be performed as one or more pages contain invalid input: \n");
            for (IManagedForm iManagedForm : collection) {
                stringBuilder.append("\n" + iManagedForm.getForm().getText() + ": " + iManagedForm.getForm().getMessage());
            }
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Invalid Input", (String)stringBuilder.toString());
            return false;
        }
        return true;
    }

    private Collection<IManagedForm> getInvalidForms() {
        if (this.pages != null) {
            ArrayList<IManagedForm> arrayList = new ArrayList<IManagedForm>();
            int n = 0;
            while (n < this.pages.size()) {
                IFormPage iFormPage;
                IManagedForm iManagedForm;
                Object e = this.pages.get(n);
                if (e instanceof IFormPage && (iManagedForm = (iFormPage = (IFormPage)e).getManagedForm()) != null && iManagedForm.getForm().getMessageType() == 3) {
                    arrayList.add(iManagedForm);
                }
                ++n;
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public boolean isDirty() {
        return this.exceptionOnSave || super.isDirty();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.getActivePageInstance().setFocus();
    }

    protected void setExceptionOnSave(boolean bl) {
        this.exceptionOnSave = bl;
    }
}

