/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.dialog;

import info.novatec.inspectit.ci.assignment.AbstractClassSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.ExceptionSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.MethodSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.TimerMethodSensorAssignment;
import info.novatec.inspectit.ci.factory.ConfigurationDefaultsFactory;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.ci.sensor.exception.IExceptionSensorConfig;
import info.novatec.inspectit.ci.sensor.method.IMethodSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.TimerSensorConfig;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class SensorAssignmentSelectionDialog
extends ListDialog {
    private static final String DIALOG_TITLE = "Select Sensor Type";
    private static final String DIALOG_MESSAGE = "Select sensor type to use in the assignment";

    public SensorAssignmentSelectionDialog(Shell shell) {
        super(shell);
        this.setTitle(DIALOG_TITLE);
        this.setMessage(DIALOG_MESSAGE);
        this.setBlockOnOpen(true);
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setLabelProvider((ILabelProvider)new SensorConfigLabelProvider());
        this.setInput(SensorAssignmentSelectionDialog.getInput(false));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        final Button button = new Button(composite2, 32);
        button.setText("Show advanced sensor types");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SensorAssignmentSelectionDialog.this.getTableViewer().setInput(SensorAssignmentSelectionDialog.getInput(button.getSelection()));
                SensorAssignmentSelectionDialog.this.getTableViewer().refresh();
            }
        });
        return composite2;
    }

    private static Object getInput(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (IMethodSensorConfig iMethodSensorConfig : ConfigurationDefaultsFactory.getAvailableMethodSensorConfigs()) {
            if (!bl && iMethodSensorConfig.isAdvanced()) continue;
            arrayList.add(iMethodSensorConfig);
        }
        arrayList.add(ConfigurationDefaultsFactory.getDefaultExceptionSensorConfig());
        Collections.sort(arrayList, new Comparator<IMethodSensorConfig>(){

            @Override
            public int compare(IMethodSensorConfig iMethodSensorConfig, IMethodSensorConfig iMethodSensorConfig2) {
                int n = Boolean.compare(iMethodSensorConfig.isAdvanced(), iMethodSensorConfig2.isAdvanced());
                if (n != 0) {
                    return n;
                }
                return iMethodSensorConfig.getName().compareTo(iMethodSensorConfig2.getName());
            }
        });
        return arrayList;
    }

    public AbstractClassSensorAssignment<?> getSensorAssignment() {
        Object[] objectArray = this.getResult();
        if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
            ISensorConfig iSensorConfig = (ISensorConfig)objectArray[0];
            if (iSensorConfig instanceof IExceptionSensorConfig) {
                return new ExceptionSensorAssignment();
            }
            if (iSensorConfig instanceof TimerSensorConfig) {
                return new TimerMethodSensorAssignment();
            }
            if (iSensorConfig instanceof IMethodSensorConfig) {
                return new MethodSensorAssignment(iSensorConfig.getClass());
            }
        }
        return null;
    }

    private static class SensorConfigLabelProvider
    extends LabelProvider {
        private SensorConfigLabelProvider() {
        }

        public String getText(Object object) {
            return TextFormatter.getSensorConfigName((ISensorConfig)object);
        }

        public Image getImage(Object object) {
            return ImageFormatter.getSensorConfigImage((ISensorConfig)object);
        }
    }
}

