/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.dialog;

import info.novatec.inspectit.ci.AgentMapping;
import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.validation.IControlValidationListener;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AgentMappingDialog
extends TitleAreaDialog
implements IControlValidationListener {
    private AgentMapping agentMapping;
    private List<Environment> environments;
    private List<ValidationControlDecoration<?>> validationControlDecorations = new ArrayList();
    private Button okButton;
    private Button activeButton;
    private Text nameText;
    private Text ipText;
    private CCombo environmentCombo;
    private Text descriptionText;

    public AgentMappingDialog(Shell shell, List<Environment> list) {
        this(shell, null, list);
    }

    public AgentMappingDialog(Shell shell, AgentMapping agentMapping, List<Environment> list) {
        super(shell);
        Assert.isLegal((boolean)CollectionUtils.isNotEmpty(list));
        this.environments = list;
        this.agentMapping = agentMapping;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    public void create() {
        super.create();
        this.setTitle(this.getTitle());
        this.setMessage("Define mapping properties", 1);
    }

    private String getTitle() {
        if (this.agentMapping != null) {
            return "Edit Agent Mapping";
        }
        return "Add Agent Mapping";
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1, IDialogConstants.CLOSE_LABEL, false);
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.agentMapping != null);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            if (this.agentMapping == null) {
                this.agentMapping = new AgentMapping();
            }
            this.agentMapping.setActive(this.activeButton.getSelection());
            this.agentMapping.setAgentName(this.nameText.getText());
            this.agentMapping.setIpAddress(this.ipText.getText());
            this.agentMapping.setDescription(this.descriptionText.getText());
            this.agentMapping.setEnvironmentId(this.environments.get(this.environmentCombo.getSelectionIndex()).getId());
        }
        super.buttonPressed(n);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        this.activeButton = new Button(composite2, 32);
        this.activeButton.setSelection(true);
        this.activeButton.setText("Active");
        this.activeButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.createInfoLabel(composite2, "If mapping is currently active. Deactivated mappings will not be considered when assigning Environment to the agent.");
        Label label = new Label(composite2, 0);
        label.setText("Agent name:");
        this.nameText = new Text(composite2, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        ValidationControlDecoration<Text> validationControlDecoration = new ValidationControlDecoration<Text>(this.nameText, (IControlValidationListener)this){

            @Override
            protected boolean validate(Text text) {
                return StringUtils.isNotBlank((String)AgentMappingDialog.this.nameText.getText());
            }
        };
        validationControlDecoration.setDescriptionText("Agent name must not be empty");
        validationControlDecoration.registerListener(24);
        this.validationControlDecorations.add(validationControlDecoration);
        this.createInfoLabel(composite2, "Name of the agent. Use wild-card '*' for matching several agent names with one mapping.");
        Label label2 = new Label(composite2, 0);
        label2.setText("IP Address:");
        this.ipText = new Text(composite2, 2048);
        this.ipText.setLayoutData((Object)new GridData(4, 4, true, false));
        ValidationControlDecoration<Text> validationControlDecoration2 = new ValidationControlDecoration<Text>(this.ipText, null, (IControlValidationListener)this){

            @Override
            protected boolean validate(Text text) {
                return StringUtils.isNotBlank((String)AgentMappingDialog.this.ipText.getText());
            }
        };
        validationControlDecoration2.setDescriptionText("IP address of the agent must not be empty");
        validationControlDecoration2.registerListener(24);
        this.validationControlDecorations.add(validationControlDecoration2);
        this.createInfoLabel(composite2, "IP address of the agent. Use wild-card '*' for matching several IPs with one mapping. For example, 192.168.* will match all IP addresses in starting with 192.168.");
        Label label3 = new Label(composite2, 0);
        label3.setText("Environment:");
        this.environmentCombo = new CCombo(composite2, 0x800808);
        this.environmentCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        for (Environment object2 : this.environments) {
            this.environmentCombo.add(object2.getName());
        }
        ValidationControlDecoration<CCombo> validationControlDecoration3 = new ValidationControlDecoration<CCombo>(this.environmentCombo, null, (IControlValidationListener)this){

            @Override
            protected boolean validate(CCombo cCombo) {
                return AgentMappingDialog.this.environmentCombo.getSelectionIndex() >= 0;
            }
        };
        validationControlDecoration3.registerListener(13);
        validationControlDecoration3.setDescriptionText("Mapping must define extacly one environment to map agent to.");
        this.validationControlDecorations.add(validationControlDecoration3);
        this.createInfoLabel(composite2, "IP address of the agent. Use wild-card '*' for matching several IPs with one mapping. For example, 192.168.* will match all IP addresses in starting with 192.168.");
        Label label4 = new Label(composite2, 0);
        label4.setText("Description:");
        label4.setLayoutData((Object)new GridData(4, 128, false, false));
        this.descriptionText = new Text(composite2, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 50;
        this.descriptionText.setLayoutData((Object)gridData);
        this.createInfoLabel(composite2, "Optional description of the mapping.");
        if (this.agentMapping != null) {
            this.activeButton.setSelection(this.agentMapping.isActive());
            this.nameText.setText(this.agentMapping.getAgentName());
            this.ipText.setText(this.agentMapping.getIpAddress());
            this.descriptionText.setText(TextFormatter.emptyStringIfNull(this.agentMapping.getDescription()));
            for (Environment environment : this.environments) {
                if (!Objects.equals(environment.getId(), this.agentMapping.getEnvironmentId())) continue;
                this.environmentCombo.select(this.environments.indexOf(environment));
                break;
            }
            validationControlDecoration3.executeValidation();
        }
        return composite2;
    }

    public AgentMapping getAgentMapping() {
        return this.agentMapping;
    }

    @Override
    public void validationStateChanged(boolean bl, ValidationControlDecoration<?> validationControlDecoration) {
        boolean bl2 = true;
        for (ValidationControlDecoration<?> validationControlDecoration2 : this.validationControlDecorations) {
            if (validationControlDecoration2.isValid()) continue;
            bl2 = false;
            break;
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(bl2);
        }
    }

    protected void createInfoLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setToolTipText(string);
        label.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
    }
}

