/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.util;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static int binarySearch(long[] a, int fromIndex, int toIndex, long key) {
        ArrayUtil.rangeCheck(a.length, fromIndex, toIndex);
        return ArrayUtil.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static void rangeCheck(int length, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static int binarySearch0(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

