/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapStringConverter
implements AttributeConverter<Map<?, ?>, String> {
    private static final char DELIMITER = '\u00a6';

    public String convertToDatabaseColumn(Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (MapUtils.isNotEmpty(map)) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                stringBuilder.append(entry.getKey().toString());
                stringBuilder.append('\u00a6');
                stringBuilder.append(entry.getValue());
                stringBuilder.append('\u00a6');
            }
        }
        return stringBuilder.toString();
    }

    public Map<?, ?> convertToEntityAttribute(String dbValue) {
        if (StringUtils.isNotEmpty((String)dbValue)) {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] split = StringUtils.splitPreserveAllTokens((String)dbValue, (char)'\u00a6');
            for (int i = 0; i < split.length - 1; i += 2) {
                map.put(split[i], split[i + 1]);
            }
            return map;
        }
        return Collections.emptyMap();
    }
}

