/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.SystemSensorData;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class JmxSensorValueData
extends SystemSensorData
implements IAggregatedData<JmxSensorValueData> {
    private static final long serialVersionUID = 1064800467325690317L;
    private long jmxSensorDefinitionDataIdentId;
    @Column(length=10000)
    private String value;
    private int aggregationCount = 0;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;
    private double totalValue = 0.0;

    public JmxSensorValueData() {
    }

    public JmxSensorValueData(long jmxDefinitionDataIdentId, String value, Timestamp timestamp, long platformIdent, long sensorTypeIdent) {
        this.setJmxSensorDefinitionDataIdentId(jmxDefinitionDataIdentId);
        this.setValue(value);
        super.setTimeStamp(timestamp);
        super.setPlatformIdent(platformIdent);
        super.setSensorTypeIdent(sensorTypeIdent);
        super.setId(jmxDefinitionDataIdentId);
    }

    public JmxSensorValueData(JmxSensorValueData origin) {
        this.setId(origin.getId());
        this.setPlatformIdent(origin.getPlatformIdent());
        this.setTimeStamp(new Timestamp(origin.getTimeStamp().getTime()));
        this.setSensorTypeIdent(origin.getSensorTypeIdent());
        this.setJmxSensorDefinitionDataIdentId(origin.jmxSensorDefinitionDataIdentId);
        this.setValue(origin.value);
    }

    public long getJmxSensorDefinitionDataIdentId() {
        return this.jmxSensorDefinitionDataIdentId;
    }

    public void setJmxSensorDefinitionDataIdentId(long jmxSensorDefinitionDataIdentId) {
        this.jmxSensorDefinitionDataIdentId = jmxSensorDefinitionDataIdentId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (this.aggregationCount <= 0 && this.isBooleanOrNumeric()) {
            double currentValue = this.getValueAsDouble();
            this.aggregationCount = 1;
            this.minValue = currentValue;
            this.maxValue = currentValue;
            this.totalValue = currentValue;
        }
    }

    public double getAverageValue() {
        if (this.aggregationCount <= 0) {
            return this.getValueAsDouble();
        }
        return this.totalValue / (double)this.aggregationCount;
    }

    @Override
    public JmxSensorValueData getData() {
        return this;
    }

    public int getAggregationCount() {
        return this.aggregationCount;
    }

    public double getMinValue() {
        if (this.aggregationCount <= 0) {
            return this.getValueAsDouble();
        }
        return this.minValue;
    }

    public double getMaxValue() {
        if (this.aggregationCount <= 0) {
            return this.getValueAsDouble();
        }
        return this.maxValue;
    }

    public double getTotalValue() {
        return this.totalValue;
    }

    public double getValueAsDouble() {
        if (NumberUtils.isNumber((String)this.value)) {
            return NumberUtils.createDouble((String)this.value);
        }
        if (this.isBooleanValue(this.value)) {
            return BooleanUtils.toBoolean((String)this.value) ? 1.0 : 0.0;
        }
        throw new NumberFormatException();
    }

    public boolean isBooleanOrNumeric() {
        return this.isBooleanValue(this.value) || NumberUtils.isNumber((String)this.value);
    }

    private boolean isBooleanValue(String value) {
        return "false".equals(value = value.toLowerCase()) || "true".equals(value) || "yes".equals(value) || "no".equals(value);
    }

    @Override
    public void aggregate(JmxSensorValueData data) {
        if (!data.isBooleanOrNumeric()) {
            throw new RuntimeException("The given JMX data can not be aggregated.");
        }
        ++this.aggregationCount;
        double valueToAggregate = data.getValueAsDouble();
        this.minValue = Math.min(this.minValue, valueToAggregate);
        this.maxValue = Math.max(this.maxValue, valueToAggregate);
        this.totalValue += valueToAggregate;
    }

    public String toString() {
        return "JmxSensorValueData [jmxSensorDefinitionDataIdent=" + this.jmxSensorDefinitionDataIdentId + ", value=" + this.value + ", getId()=" + this.getId() + ", getPlatformIdent()=" + this.getPlatformIdent() + ", getSensorTypeIdent()=" + this.getSensorTypeIdent() + ", getTimeStamp()=" + this.getTimeStamp() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.aggregationCount;
        result = 31 * result + (int)(this.jmxSensorDefinitionDataIdentId ^ this.jmxSensorDefinitionDataIdentId >>> 32);
        long temp = Double.doubleToLongBits(this.maxValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.totalValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmxSensorValueData other = (JmxSensorValueData)obj;
        if (this.aggregationCount != other.aggregationCount) {
            return false;
        }
        if (this.jmxSensorDefinitionDataIdentId != other.jmxSensorDefinitionDataIdentId) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxValue) != Double.doubleToLongBits(other.maxValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minValue) != Double.doubleToLongBits(other.minValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalValue) != Double.doubleToLongBits(other.totalValue)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

