/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.model;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;

@Entity
@NamedQueries(value={@NamedQuery(name="JmxDefinitionDataIdent.findByPlatformAndExample", query="SELECT j FROM JmxDefinitionDataIdent j JOIN j.platformIdent p WHERE p.id=:platformIdentId AND j.mBeanObjectName=:mBeanObjectName AND j.mBeanAttributeName=:mBeanAttributeName")})
public class JmxDefinitionDataIdent
implements Serializable {
    private static final long serialVersionUID = 5190671450845879357L;
    public static final String FIND_BY_PLATFORM_AND_EXAMPLE = "JmxDefinitionDataIdent.findByPlatformAndExample";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="JMX_DATA_IDENT_SEQUENCE")
    @SequenceGenerator(name="JMX_DATA_IDENT_SEQUENCE", sequenceName="JMX_DATA_IDENT_SEQUENCE")
    private long id;
    @NotNull
    private Timestamp timeStamp;
    @ManyToOne
    private PlatformIdent platformIdent;
    @NotNull
    private String mBeanObjectName;
    @NotNull
    private String mBeanAttributeName;
    private String mBeanAttributeDescription;
    @NotNull
    private String mBeanAttributeType;
    @NotNull
    private Boolean mBeanAttributeIsIs;
    @NotNull
    private Boolean mBeanAttributeIsReadable;
    @NotNull
    private Boolean mBeanAttributeIsWritable;

    public String getDerivedDomainName() {
        Pattern pattern = Pattern.compile("([^:]+):[\\w\\s]+=([\\w\\s]+),[\\w\\s]+=([\\w\\s]+)");
        Matcher matcher = pattern.matcher(this.mBeanObjectName);
        if (matcher.find()) {
            String g1 = matcher.group(1);
            String g2 = matcher.group(2);
            return g1 + "." + g2;
        }
        return this.mBeanObjectName.split(":")[0].trim();
    }

    public String getDerivedTypeName() {
        String[] splitted = this.mBeanObjectName.split("=");
        return splitted[splitted.length - 1].trim();
    }

    public String getDerivedFullName() {
        return this.getDerivedDomainName() + "." + this.getDerivedTypeName() + ":" + this.getmBeanAttributeName();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getmBeanObjectName() {
        return this.mBeanObjectName;
    }

    public void setmBeanObjectName(String mBeanObjectName) {
        this.mBeanObjectName = mBeanObjectName;
    }

    public Timestamp getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Timestamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    public PlatformIdent getPlatformIdent() {
        return this.platformIdent;
    }

    public void setPlatformIdent(PlatformIdent platformIdent) {
        this.platformIdent = platformIdent;
    }

    public String getmBeanAttributeName() {
        return this.mBeanAttributeName;
    }

    public void setmBeanAttributeName(String mBeanAttributeName) {
        this.mBeanAttributeName = mBeanAttributeName;
    }

    public String getmBeanAttributeDescription() {
        return this.mBeanAttributeDescription;
    }

    public void setmBeanAttributeDescription(String mBeanAttributeDescription) {
        this.mBeanAttributeDescription = mBeanAttributeDescription;
    }

    public String getmBeanAttributeType() {
        return this.mBeanAttributeType;
    }

    public void setmBeanAttributeType(String mBeanAttributeType) {
        this.mBeanAttributeType = mBeanAttributeType;
    }

    public Boolean getmBeanAttributeIsIs() {
        return this.mBeanAttributeIsIs;
    }

    public void setmBeanAttributeIsIs(Boolean mBeanAttributeIsIs) {
        this.mBeanAttributeIsIs = mBeanAttributeIsIs;
    }

    public Boolean getmBeanAttributeIsReadable() {
        return this.mBeanAttributeIsReadable;
    }

    public void setmBeanAttributeIsReadable(Boolean mBeanAttributeIsReadable) {
        this.mBeanAttributeIsReadable = mBeanAttributeIsReadable;
    }

    public Boolean getmBeanAttributeIsWritable() {
        return this.mBeanAttributeIsWritable;
    }

    public void setmBeanAttributeIsWritable(Boolean mBeanAttributeIsWritable) {
        this.mBeanAttributeIsWritable = mBeanAttributeIsWritable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.mBeanAttributeDescription == null ? 0 : this.mBeanAttributeDescription.hashCode());
        result = 31 * result + (this.mBeanAttributeIsIs == null ? 0 : this.mBeanAttributeIsIs.hashCode());
        result = 31 * result + (this.mBeanAttributeIsReadable == null ? 0 : this.mBeanAttributeIsReadable.hashCode());
        result = 31 * result + (this.mBeanAttributeIsWritable == null ? 0 : this.mBeanAttributeIsWritable.hashCode());
        result = 31 * result + (this.mBeanAttributeName == null ? 0 : this.mBeanAttributeName.hashCode());
        result = 31 * result + (this.mBeanAttributeType == null ? 0 : this.mBeanAttributeType.hashCode());
        result = 31 * result + (this.mBeanObjectName == null ? 0 : this.mBeanObjectName.hashCode());
        result = 31 * result + (this.timeStamp == null ? 0 : this.timeStamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmxDefinitionDataIdent other = (JmxDefinitionDataIdent)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.mBeanAttributeDescription == null ? other.mBeanAttributeDescription != null : !this.mBeanAttributeDescription.equals(other.mBeanAttributeDescription)) {
            return false;
        }
        if (this.mBeanAttributeIsIs == null ? other.mBeanAttributeIsIs != null : !this.mBeanAttributeIsIs.equals(other.mBeanAttributeIsIs)) {
            return false;
        }
        if (this.mBeanAttributeIsReadable == null ? other.mBeanAttributeIsReadable != null : !this.mBeanAttributeIsReadable.equals(other.mBeanAttributeIsReadable)) {
            return false;
        }
        if (this.mBeanAttributeIsWritable == null ? other.mBeanAttributeIsWritable != null : !this.mBeanAttributeIsWritable.equals(other.mBeanAttributeIsWritable)) {
            return false;
        }
        if (this.mBeanAttributeName == null ? other.mBeanAttributeName != null : !this.mBeanAttributeName.equals(other.mBeanAttributeName)) {
            return false;
        }
        if (this.mBeanAttributeType == null ? other.mBeanAttributeType != null : !this.mBeanAttributeType.equals(other.mBeanAttributeType)) {
            return false;
        }
        if (this.mBeanObjectName == null ? other.mBeanObjectName != null : !this.mBeanObjectName.equals(other.mBeanObjectName)) {
            return false;
        }
        return !(this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp));
    }
}

