/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage;

import com.esotericsoftware.kryo.io.Output;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.cmr.WritingStatus;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.IWriter;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageIndexingTreeHandler;
import info.novatec.inspectit.storage.StorageManager;
import info.novatec.inspectit.storage.nio.WriteReadCompletionRunnable;
import info.novatec.inspectit.storage.nio.stream.ExtendedByteBufferOutputStream;
import info.novatec.inspectit.storage.nio.stream.StreamProvider;
import info.novatec.inspectit.storage.nio.write.WritingChannelManager;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.processor.write.AbstractWriteDataProcessor;
import info.novatec.inspectit.storage.serializer.ISerializer;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.provider.SerializationManagerProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class StorageWriter
implements IWriter {
    @Log
    Logger log;
    private static final int FINALIZATION_TASKS_SLEEP_TIME = 500;
    private long totalTasks = 0L;
    private long finishedTasks = 0L;
    @Autowired
    StorageManager storageManager;
    private StorageData storageData;
    @Autowired
    StorageIndexingTreeHandler indexingTreeHandler;
    private Path writingFolderPath;
    @Autowired
    WritingChannelManager writingChannelManager;
    @Autowired
    private SerializationManagerProvider serializationManagerProvider;
    BlockingQueue<ISerializer> serializerQueue = new LinkedBlockingQueue<ISerializer>();
    @Autowired
    @Resource(name="storageExecutorService")
    private ScheduledThreadPoolExecutor writingExecutorService;
    @Autowired
    @Resource(name="scheduledExecutorService")
    ScheduledExecutorService scheduledExecutorService;
    @Autowired
    StreamProvider streamProvider;
    @Autowired
    List<AbstractWriteDataProcessor> writeDataProcessors;
    private Set<Path> openedChannelPaths = Collections.newSetFromMap(new ConcurrentHashMap(32, 0.75f, 1));
    private volatile boolean writingOn = false;
    private WritingStatus writingStatus = WritingStatus.GOOD;
    private boolean finalized = false;
    private ScheduledFuture<?> checkWritingStatusFuture;
    private Set<FutureTask<?>> activeWritingTasks = Collections.newSetFromMap(new ConcurrentHashMap(256, 0.75f, 4));

    public Collection<Future<Void>> process(Collection<? extends DefaultData> defaultDataList, Collection<AbstractDataProcessor> processors) {
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        if (null != processors && !processors.isEmpty()) {
            for (AbstractDataProcessor abstractDataProcessor : processors) {
                abstractDataProcessor.setStorageWriter(this);
            }
            for (DefaultData defaultData : defaultDataList) {
                for (AbstractDataProcessor processor : processors) {
                    futureList.addAll(processor.process(defaultData));
                }
            }
            for (AbstractDataProcessor abstractDataProcessor : processors) {
                futureList.addAll(abstractDataProcessor.flush());
                abstractDataProcessor.setStorageWriter(null);
            }
        } else {
            for (DefaultData defaultData : defaultDataList) {
                Future<Void> future = this.write(defaultData);
                futureList.add(future);
            }
        }
        return futureList;
    }

    public void processSynchronously(Collection<? extends DefaultData> defaultDataList, Collection<AbstractDataProcessor> processors) {
        Collection<Future<Void>> futures = this.process(defaultDataList, processors);
        while (!futures.isEmpty()) {
            Iterator<Future<Void>> it = futures.iterator();
            while (it.hasNext()) {
                Future<Void> future = it.next();
                if (!future.isDone()) continue;
                it.remove();
            }
            if (futures.isEmpty()) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public Future<Void> write(DefaultData defaultData) {
        return this.write(defaultData, Collections.emptyMap());
    }

    @Override
    public Future<Void> write(DefaultData defaultData, Map<?, ?> kryoPreferences) {
        if (this.writingOn && this.storageManager.canWriteMore()) {
            for (AbstractWriteDataProcessor processor : this.writeDataProcessors) {
                try {
                    processor.process(defaultData, kryoPreferences);
                }
                catch (Exception e) {
                    this.log.error("Exception occurred processing the data with the finalization data processor " + processor.getClass().getName(), (Throwable)e);
                }
            }
            WriteTask writeTask = new WriteTask(defaultData, kryoPreferences);
            WriteFutureTask writeFutureTask = new WriteFutureTask(writeTask);
            this.activeWritingTasks.add(writeFutureTask);
            this.writingExecutorService.submit(writeFutureTask);
            return writeFutureTask;
        }
        return null;
    }

    public synchronized boolean prepareForWrite(StorageData storageData) throws IOException {
        if (!this.writingOn) {
            this.storageData = storageData;
            this.writingFolderPath = this.storageManager.getStoragePath(storageData);
            if (!Files.exists(this.writingFolderPath, new LinkOption[0])) {
                Files.createDirectories(this.writingFolderPath, new FileAttribute[0]);
            }
            this.indexingTreeHandler.prepare();
            this.checkWritingStatusFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (StorageWriter.this.writingOn) {
                        StorageWriter.this.checkWritingStatus();
                    }
                }
            }, 30L, 30L, TimeUnit.SECONDS);
            for (AbstractWriteDataProcessor processor : this.writeDataProcessors) {
                try {
                    processor.onPrepare(this.storageManager, this, storageData);
                }
                catch (Exception e) {
                    this.log.error("Exception occurred trying to process onPrepare of the finalization data processor " + processor.getClass().getName(), (Throwable)e);
                }
            }
            this.writingOn = true;
            return true;
        }
        return false;
    }

    public final synchronized void cancel() {
        this.shutdown(false);
    }

    public final synchronized void closeStorageWriter() {
        this.shutdown(true);
    }

    protected synchronized void finalizeWrite() {
        if (!this.finalized) {
            for (AbstractWriteDataProcessor processor : this.writeDataProcessors) {
                try {
                    processor.onFinalization(this.storageManager, this, this.storageData);
                }
                catch (Exception e) {
                    this.log.error("Exception occurred trying to process onFinalize of the finalization data processor " + processor.getClass().getName(), (Throwable)e);
                }
            }
            this.indexingTreeHandler.finish();
            this.finalized = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finalization done for storage: " + this.storageData + ".");
            }
        }
    }

    private synchronized void shutdown(boolean doFinalize) {
        if (this.writingOn) {
            this.writingOn = false;
            this.checkWritingStatusFuture.cancel(false);
            this.waitForPendingWritingTasks();
            this.shutdownWritingExecutorService();
            if (doFinalize) {
                this.finalizeWrite();
            }
            try {
                for (Path channelPath : this.openedChannelPaths) {
                    this.writingChannelManager.finalizeChannel(channelPath);
                }
            }
            catch (IOException e) {
                this.log.warn("Closing one of the opened file channels failed.", (Throwable)e);
            }
        }
    }

    private synchronized void shutdownWritingExecutorService() {
        if (this.writingExecutorService.isShutdown()) {
            return;
        }
        this.writingExecutorService.shutdown();
        try {
            if (!this.writingExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.writingExecutorService.shutdownNow();
                if (!this.writingExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.error("Executor service of the Storage writer for the storage " + this.storageData + " did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            this.writingExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void waitForPendingWritingTasks() {
        long activeTasks;
        boolean logged = false;
        while ((activeTasks = this.getQueuedTaskCount()) > 0L) {
            if (this.log.isDebugEnabled() && !logged) {
                this.log.info("Storage: " + this.storageData + " is waiting for finalization. Still " + activeTasks + " queued tasks need to be processed.");
                logged = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public long getQueuedTaskCount() {
        return this.activeWritingTasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeNonDefaultDataObject(Object object, String fileName) {
        ISerializer serializer = null;
        try {
            serializer = this.serializerQueue.take();
        }
        catch (InterruptedException e1) {
            Thread.interrupted();
        }
        if (null == serializer) {
            this.log.error("Serializer instance could not be obtained.");
            return false;
        }
        Path path = this.writingFolderPath.resolve(fileName);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                this.log.error("Exception thrown trying to delete file from disk", (Throwable)e);
                return false;
            }
        }
        try {
            try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE_NEW);){
                Output output = new Output(outputStream);
                serializer.serialize(object, output);
            }
            this.serializerQueue.add(serializer);
        }
        catch (SerializationException e) {
            boolean bl;
            try {
                this.log.error("Serialization for the object " + object + " failed. Data will be skipped.", (Throwable)e);
                bl = false;
                this.serializerQueue.add(serializer);
            }
            catch (Throwable throwable) {
                try {
                    this.serializerQueue.add(serializer);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    this.log.error("Exception occurred while attempting to write data to disk", throwable2);
                    return false;
                }
            }
            return bl;
        }
        return true;
    }

    private void checkWritingStatus() {
        if (null != this.writingExecutorService) {
            long completedTasks = this.writingExecutorService.getCompletedTaskCount();
            long queuedTasks = this.writingExecutorService.getTaskCount() - completedTasks;
            long arrivedTasksForPeriod = queuedTasks + completedTasks - this.totalTasks;
            long finishedTasksForPeriod = completedTasks - this.finishedTasks;
            this.writingStatus = WritingStatus.getWritingStatus(arrivedTasksForPeriod, finishedTasksForPeriod);
            this.finishedTasks = completedTasks;
            this.totalTasks = completedTasks + queuedTasks;
        } else {
            this.writingStatus = WritingStatus.GOOD;
        }
    }

    public Path getWritingFolderPath() {
        return this.writingFolderPath;
    }

    public String getExecutorServiceStatus() {
        return this.writingExecutorService.toString();
    }

    public boolean isWritingOn() {
        return this.writingOn;
    }

    public StorageData getStorageData() {
        return this.storageData;
    }

    public WritingStatus getWritingStatus() {
        return this.writingStatus;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.indexingTreeHandler.registerStorageWriter(this);
        int threads = this.writingExecutorService.getCorePoolSize();
        for (int i = 0; i < threads; ++i) {
            this.serializerQueue.add((ISerializer)this.serializationManagerProvider.createSerializer());
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("storageData", (Object)this.storageData);
        toStringBuilder.append("writingFolderPath", (Object)this.writingFolderPath);
        toStringBuilder.append("writingOn", this.writingOn);
        toStringBuilder.append("executorService", (Object)this.writingExecutorService);
        toStringBuilder.append("openedChannelPaths", this.openedChannelPaths);
        return toStringBuilder.toString();
    }

    private class WriteFutureTask
    extends FutureTask<Void> {
        public WriteFutureTask(Runnable runnable) {
            super(runnable, null);
        }

        @Override
        protected void done() {
            StorageWriter.this.activeWritingTasks.remove(this);
        }
    }

    public class WriteTask
    implements Runnable {
        private SoftReference<DefaultData> referenceToWriteData;
        private Map<?, ?> kryoPreferences;

        public WriteTask(DefaultData data, Map<?, ?> kryoPreferences) {
            this.referenceToWriteData = new SoftReference<DefaultData>(data);
            this.kryoPreferences = kryoPreferences;
        }

        @Override
        public void run() {
            ExtendedByteBufferOutputStream extendedByteBufferOutputStream = null;
            try {
                if (!StorageWriter.this.storageManager.canWriteMore()) {
                    if (StorageWriter.this.log.isWarnEnabled()) {
                        StorageWriter.this.log.warn("Writing of data canceled because of limited hard disk space left for the storage.");
                    }
                    return;
                }
                DefaultData data = this.referenceToWriteData.get();
                if (null == data) {
                    StorageWriter.this.log.warn("Failed to write data to storage. The data to be written was already garbage collected due to the high amount of writing tasks.");
                    return;
                }
                int channelId = 0;
                try {
                    channelId = StorageWriter.this.indexingTreeHandler.startWrite(this);
                }
                catch (IndexingException e) {
                    StorageWriter.this.indexingTreeHandler.writeFailed(this);
                    if (StorageWriter.this.log.isDebugEnabled()) {
                        StorageWriter.this.log.debug("Indexing exception occurred while attempting to write data to disk.", (Throwable)e);
                    }
                    return;
                }
                if (0 == channelId) {
                    StorageWriter.this.indexingTreeHandler.writeFailed(this);
                    StorageWriter.this.log.error("Channel ID could not be obtained during attempt to write data to disk. Data will be skipped.");
                    return;
                }
                ISerializer serializer = null;
                try {
                    serializer = StorageWriter.this.serializerQueue.take();
                }
                catch (InterruptedException e1) {
                    Thread.interrupted();
                }
                if (null == serializer) {
                    StorageWriter.this.indexingTreeHandler.writeFailed(this);
                    StorageWriter.this.log.error("Serializer instance could not be obtained.");
                    return;
                }
                extendedByteBufferOutputStream = StorageWriter.this.streamProvider.getExtendedByteBufferOutputStream();
                try {
                    Output output = new Output((OutputStream)extendedByteBufferOutputStream);
                    serializer.serialize((Object)data, output, this.kryoPreferences);
                    extendedByteBufferOutputStream.flush(false);
                }
                catch (SerializationException e) {
                    extendedByteBufferOutputStream.close();
                    StorageWriter.this.indexingTreeHandler.writeFailed(this);
                    StorageWriter.this.serializerQueue.add(serializer);
                    if (StorageWriter.this.log.isWarnEnabled()) {
                        StorageWriter.this.log.warn("Serialization for the object " + data + " failed. Data will be skipped.", (Throwable)e);
                    }
                    return;
                }
                StorageWriter.this.serializerQueue.add(serializer);
                int buffersToWrite = extendedByteBufferOutputStream.getBuffersCount();
                final ExtendedByteBufferOutputStream finalOutputStream = extendedByteBufferOutputStream;
                WriteReadCompletionRunnable completionRunnable = new WriteReadCompletionRunnable(buffersToWrite){

                    @Override
                    public void run() {
                        finalOutputStream.close();
                        if (this.isCompleted()) {
                            StorageWriter.this.indexingTreeHandler.writeSuccessful(WriteTask.this, this.getAttemptedWriteReadPosition(), this.getAttemptedWriteReadSize());
                        } else {
                            StorageWriter.this.indexingTreeHandler.writeFailed(WriteTask.this);
                        }
                    }
                };
                Path channelPath = StorageWriter.this.storageManager.getChannelPath((IStorageData)StorageWriter.this.storageData, channelId);
                StorageWriter.this.openedChannelPaths.add(channelPath);
                try {
                    StorageWriter.this.writingChannelManager.write(extendedByteBufferOutputStream, channelPath, completionRunnable);
                }
                catch (IOException e) {
                    extendedByteBufferOutputStream.close();
                    StorageWriter.this.indexingTreeHandler.writeFailed(this);
                    StorageWriter.this.log.error("Exception occurred while attempting to write data to disk", (Throwable)e);
                    return;
                }
            }
            catch (Throwable t) {
                if (null != extendedByteBufferOutputStream) {
                    extendedByteBufferOutputStream.close();
                }
                StorageWriter.this.indexingTreeHandler.writeFailed(this);
                StorageWriter.this.log.error("Unknown exception occurred during data write", t);
            }
        }

        public DefaultData getData() {
            return this.referenceToWriteData.get();
        }
    }
}

