/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.StorageErrorCodeEnum;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.impl.SerializationManager;
import info.novatec.inspectit.storage.serializer.provider.SerializationManagerProvider;
import info.novatec.inspectit.storage.util.DeleteFileVisitor;
import info.novatec.inspectit.storage.util.StorageDeleteFileVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class StorageManager {
    @Log
    Logger log;
    private static final int CHECK_HARD_DRIVE_RATE = 5000;
    private static final String CACHED_DATA_FOLDER = "cache";
    @Autowired
    private SerializationManagerProvider serializationManagerProvider;
    @Value(value="${storage.storageDefaultFolder}")
    private String storageDefaultFolder;
    @Value(value="${storage.storageDefaultFolder}/uploads")
    private String storageUploadsFolder;
    @Value(value="${storage.maxHardDriveOccupancy}")
    private int maxHardDriveOccupancy;
    @Value(value="${storage.warnHardDriveByteLeft}")
    private long warnBytesLeft = 0x40000000L;
    @Value(value="${storage.stopWriteHardDriveBytesLeft}")
    private long stopWriteBytesLeft = 0x6400000L;
    private long bytesHardDriveOccupancyLeft;
    private long hardDriveSize;

    public abstract Path getStoragePath(IStorageData var1);

    protected abstract Path getDefaultStorageDirPath();

    public Path getChannelPath(IStorageData storageData, IStorageDescriptor descriptor) {
        return this.getStoragePath(storageData).resolve(descriptor.getChannelId() + StorageFileType.DATA_FILE.getExtension());
    }

    public Path getChannelPath(IStorageData storageData, int channelId) {
        return this.getStoragePath(storageData).resolve(channelId + StorageFileType.DATA_FILE.getExtension());
    }

    public Path getCachedDataPath(IStorageData storageData, int hash) {
        Path path = this.getStoragePath(storageData).resolve(CACHED_DATA_FOLDER).resolve(hash + StorageFileType.CACHED_DATA_FILE.getExtension());
        return path;
    }

    public String getHttpFileLocation(IStorageData storageData, IStorageDescriptor descriptor) {
        return this.getHttpFileLocation(storageData, descriptor.getChannelId());
    }

    public String getHttpFileLocation(IStorageData storageData, Integer channelId) {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(storageData.getId());
        sb.append('/');
        sb.append(channelId);
        sb.append(StorageFileType.DATA_FILE.getExtension());
        return sb.toString();
    }

    protected void writeStorageDataToDisk(StorageData storageData) throws IOException, SerializationException {
        this.writeStorageDataToDisk(storageData, this.getStoragePath(storageData), StorageFileType.STORAGE_FILE.getExtension());
    }

    protected void writeLocalStorageDataToDisk(LocalStorageData localStorageData) throws IOException, SerializationException {
        this.writeStorageDataToDisk(localStorageData, this.getStoragePath(localStorageData), StorageFileType.LOCAL_STORAGE_FILE.getExtension());
    }

    protected void writeStorageDataToDisk(StorageData storageData, Path dir) throws IOException, SerializationException {
        this.writeStorageDataToDisk(storageData, dir, StorageFileType.STORAGE_FILE.getExtension());
    }

    protected void writeLocalStorageDataToDisk(LocalStorageData localStorageData, Path dir) throws IOException, SerializationException {
        this.writeStorageDataToDisk(localStorageData, dir, StorageFileType.LOCAL_STORAGE_FILE.getExtension());
    }

    private void writeStorageDataToDisk(IStorageData storageData, Path dir, String extenstion) throws IOException, SerializationException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Path storageDataFile = dir.resolve(storageData.getId() + extenstion);
        Files.deleteIfExists(storageDataFile);
        this.serializeDataToOutputStream(storageData, Files.newOutputStream(storageDataFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serializeDataToOutputStream(Object data, OutputStream outputStream, boolean closeStream) throws SerializationException {
        SerializationManager serializer = this.serializationManagerProvider.createSerializer();
        Output output = null;
        try {
            output = new Output(outputStream);
            serializer.serialize(data, output);
        }
        finally {
            if (null != output) {
                if (!closeStream) {
                    output.setOutputStream(null);
                }
                output.close();
            }
        }
    }

    protected void deleteCompleteStorageDataFromDisk(IStorageData storageData) throws IOException {
        Path storageDir = this.getStoragePath(storageData);
        if (this.log.isDebugEnabled()) {
            this.log.info("Deleting the complete storage data from disk. Path: " + storageDir);
        }
        if (Files.exists(storageDir, new LinkOption[0])) {
            Files.walkFileTree(storageDir, new DeleteFileVisitor());
        }
    }

    protected void deleteStorageDataFromDisk(IStorageData storageData, StorageFileType ... fileTypes) throws IOException {
        Path storageDir = this.getStoragePath(storageData);
        if (this.log.isDebugEnabled()) {
            this.log.info("Deleting the storage data from disk. Path: " + storageDir + ". File types to delete: " + ArrayUtils.toString((Object)fileTypes));
        }
        if (Files.exists(storageDir, new LinkOption[0])) {
            Files.walkFileTree(storageDir, new StorageDeleteFileVisitor(fileTypes, false));
        }
    }

    public boolean canWriteMore() {
        return this.bytesHardDriveOccupancyLeft > this.stopWriteBytesLeft;
    }

    public boolean isSpaceWarnActive() {
        return this.bytesHardDriveOccupancyLeft < this.warnBytesLeft;
    }

    @Scheduled(fixedRate=5000L)
    protected void updatedStorageSpaceLeft() throws IOException {
        Path defaultDirectory;
        Path parent = defaultDirectory = this.getDefaultStorageDirPath();
        while (Files.notExists(parent, new LinkOption[0])) {
            parent = parent.getParent();
        }
        FileStore fileStore = Files.getFileStore(parent);
        this.hardDriveSize = fileStore.getTotalSpace();
        long bytesAvailable = fileStore.getUsableSpace();
        if (Files.exists(defaultDirectory, new LinkOption[0]) && this.maxHardDriveOccupancy > 0 && bytesAvailable > (long)this.maxHardDriveOccupancy) {
            final MutableLong totalSizeInBytes = new MutableLong();
            Files.walkFileTree(defaultDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    totalSizeInBytes.add(Files.size(file));
                    return FileVisitResult.CONTINUE;
                }
            });
            long totalSize = totalSizeInBytes.longValue();
            this.bytesHardDriveOccupancyLeft = (long)this.maxHardDriveOccupancy - totalSize;
            if (this.bytesHardDriveOccupancyLeft < 0L) {
                this.bytesHardDriveOccupancyLeft = 0L;
            }
        } else {
            this.bytesHardDriveOccupancyLeft = bytesAvailable;
        }
    }

    protected void zipStorageData(IStorageData storageData, Path zipPath) throws IOException {
        Path storageDir = this.getStoragePath(storageData);
        this.zipFiles(storageDir, zipPath);
    }

    protected void zipFiles(final Path directory, Path zipPath) throws IOException {
        if (Files.notExists(directory, new LinkOption[0])) {
            throw new IOException("Can not create zip file. The directory " + directory.toString() + " does not exist.");
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException("Can not create zip file. Given path " + directory.toString() + " is not the directory.");
        }
        Files.deleteIfExists(zipPath);
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE));){
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = directory.relativize(file).toString();
                    ZipEntry zipEntry = new ZipEntry(fileName);
                    zos.putNextEntry(zipEntry);
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStorageData getStorageDataFromZip(Path zipFilePath) {
        if (Files.notExists(zipFilePath, new LinkOption[0])) {
            return null;
        }
        SerializationManager serializer = this.serializationManagerProvider.createSerializer();
        try (ZipFile zipFile = new ZipFile(zipFilePath.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().endsWith(StorageFileType.LOCAL_STORAGE_FILE.getExtension())) continue;
                boolean isGzip = false;
                try (InputStream is = zipFile.getInputStream(zipEntry);){
                    isGzip = this.isGzipCompressedData(is);
                }
                Input input = isGzip ? new Input((InputStream)new GZIPInputStream(zipFile.getInputStream(zipEntry))) : new Input(zipFile.getInputStream(zipEntry));
                var9_12 = null;
                try {
                    Object deserialized = serializer.deserialize(input);
                    if (!(deserialized instanceof IStorageData)) continue;
                    IStorageData iStorageData = (IStorageData)deserialized;
                    return iStorageData;
                }
                catch (SerializationException e) {}
                continue;
                catch (Throwable throwable) {
                    var9_12 = throwable;
                    throw throwable;
                }
                finally {
                    if (input == null) continue;
                    if (var9_12 != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable x2) {
                            var9_12.addSuppressed(x2);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void unzipStorageData(Path zipFilePath, Path destinationPath) throws BusinessException, IOException {
        if (Files.notExists(zipFilePath, new LinkOption[0])) {
            throw new BusinessException("Unpack the storage file with path " + zipFilePath + ".", (IErrorCode)StorageErrorCodeEnum.FILE_DOES_NOT_EXIST);
        }
        Files.createDirectories(destinationPath, new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(zipFilePath.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                Path path = destinationPath.resolve(Paths.get(zipEntry.getName(), new String[0]));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                Path parent = path.getParent();
                if (null != parent && Files.notExists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                boolean isGzip = false;
                try (InputStream is = zipFile.getInputStream(zipEntry);){
                    isGzip = this.isGzipCompressedData(is);
                }
                is = zipFile.getInputStream(zipEntry);
                var11_13 = null;
                try {
                    if (isGzip) {
                        GZIPInputStream gis = new GZIPInputStream(is);
                        Throwable throwable = null;
                        try {
                            Files.copy(gis, path, StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (gis == null) continue;
                            if (throwable != null) {
                                try {
                                    gis.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            gis.close();
                            continue;
                        }
                    }
                    Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable) {
                    var11_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (is == null) continue;
                    if (var11_13 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            var11_13.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGzipCompressedData(InputStream is) throws IOException {
        try {
            byte[] firsTwoBytes = new byte[2];
            for (int read = 0; read < 2; read += is.read(firsTwoBytes, read, 2 - read)) {
            }
            int head = firsTwoBytes[0] & 0xFF | firsTwoBytes[1] << 8 & 0xFF00;
            boolean bl = 35615 == head;
            return bl;
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
    }

    public void cacheStorageData(IStorageData storageData, Collection<? extends DefaultData> data, int hash) throws IOException, SerializationException {
        Path path = this.getCachedDataPath(storageData, hash);
        if (Files.notExists(path, new LinkOption[0])) {
            Path parent = path.getParent();
            if (Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                this.serializeDataToOutputStream(data, outputStream, true);
            }
        }
    }

    public boolean canBeCached(IIndexQuery indexQuery, IAggregator<?> aggregator) {
        if (null == aggregator) {
            return false;
        }
        return !indexQuery.isIntervalSet();
    }

    public int getCachedDataHash(IIndexQuery indexQuery, IAggregator<?> aggregator) {
        if (null == indexQuery) {
            throw new IllegalArgumentException("Can not create cached data hash when index query is null.");
        }
        int prime = 31;
        int result = 0;
        result = 31 * result + indexQuery.hashCode();
        result = 31 * result + (aggregator == null ? 0 : aggregator.hashCode());
        return result;
    }

    public SerializationManagerProvider getSerializationManagerProvider() {
        return this.serializationManagerProvider;
    }

    public void setSerializationManagerProvider(SerializationManagerProvider serializationManagerProvider) {
        this.serializationManagerProvider = serializationManagerProvider;
    }

    public String getStorageUploadsFolder() {
        return this.storageUploadsFolder;
    }

    public String getStorageDefaultFolder() {
        return this.storageDefaultFolder;
    }

    public void setStorageDefaultFolder(String storageDefaultFolder) {
        this.storageDefaultFolder = storageDefaultFolder;
    }

    public long getBytesHardDriveOccupancyLeft() {
        return this.bytesHardDriveOccupancyLeft;
    }

    public long getMaxBytesHardDriveOccupancy() {
        if (this.maxHardDriveOccupancy > 0) {
            return this.maxHardDriveOccupancy;
        }
        return this.hardDriveSize;
    }
}

