/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.aggregation.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.data.AggregatedSqlStatementData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import java.io.Serializable;
import java.util.ArrayList;

public class SqlStatementDataAggregator
implements IAggregator<SqlStatementData>,
Serializable {
    private static final long serialVersionUID = -2226935151962665996L;
    private boolean includeParameters;

    public SqlStatementDataAggregator() {
    }

    public SqlStatementDataAggregator(boolean includeParameters) {
        this.includeParameters = includeParameters;
    }

    @Override
    public void aggregate(IAggregatedData<SqlStatementData> aggregatedObject, SqlStatementData objectToAdd) {
        aggregatedObject.aggregate((DefaultData)objectToAdd);
    }

    @Override
    public IAggregatedData<SqlStatementData> getClone(SqlStatementData sqlStatementData) {
        AggregatedSqlStatementData clone = new AggregatedSqlStatementData();
        clone.setPlatformIdent(sqlStatementData.getPlatformIdent());
        clone.setSensorTypeIdent(sqlStatementData.getSensorTypeIdent());
        clone.setPreparedStatement(sqlStatementData.isPreparedStatement());
        clone.setSql(sqlStatementData.getSql());
        clone.setDatabaseProductName(sqlStatementData.getDatabaseProductName());
        clone.setDatabaseProductVersion(sqlStatementData.getDatabaseProductVersion());
        clone.setDatabaseUrl(sqlStatementData.getDatabaseUrl());
        if (this.includeParameters && null != sqlStatementData.getParameterValues()) {
            clone.setParameterValues(new ArrayList(sqlStatementData.getParameterValues()));
        }
        return clone;
    }

    @Override
    public Object getAggregationKey(SqlStatementData sqlStatementData) {
        int prime = 31;
        int result = 0;
        result = 31 * result + (sqlStatementData.isPreparedStatement() ? 1231 : 1237);
        result = 31 * result + (sqlStatementData.getSql() == null ? 0 : sqlStatementData.getSql().hashCode());
        result = 31 * result + (sqlStatementData.getDatabaseUrl() == null ? 0 : sqlStatementData.getDatabaseUrl().hashCode());
        if (this.includeParameters) {
            result = 31 * result + (sqlStatementData.getParameterValues() == null ? 0 : sqlStatementData.getParameterValues().hashCode());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeParameters ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlStatementDataAggregator other = (SqlStatementDataAggregator)obj;
        return this.includeParameters == other.includeParameters;
    }
}

