/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.aggregation.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggregationPerformer<E extends DefaultData> {
    private Map<Object, IAggregatedData<E>> aggregationMap;
    private IAggregator<E> aggregator;

    public AggregationPerformer(IAggregator<E> aggregator) {
        if (null == aggregator) {
            throw new IllegalArgumentException("Aggregator can not be null.");
        }
        this.aggregator = aggregator;
        this.aggregationMap = new HashMap<Object, IAggregatedData<E>>();
    }

    public void processElement(E element) {
        Object key = this.aggregator.getAggregationKey(element);
        IAggregatedData<E> aggregatedObject = this.aggregationMap.get(key);
        if (null != aggregatedObject) {
            this.aggregator.aggregate(aggregatedObject, element);
        } else {
            aggregatedObject = this.aggregator.getClone(element);
            this.aggregationMap.put(key, aggregatedObject);
            this.aggregator.aggregate(aggregatedObject, element);
        }
    }

    public void processCollection(Collection<E> collection) {
        for (DefaultData element : collection) {
            this.processElement(element);
        }
    }

    public void processList(List<E> list, int fromIndex, int toIndex) {
        int size = list.size();
        if (fromIndex < 0 || fromIndex >= size) {
            throw new IllegalArgumentException("Starting index " + fromIndex + " is not valid for given list of size " + size);
        }
        if (toIndex < fromIndex || toIndex > size) {
            throw new IllegalArgumentException("Ending index " + toIndex + " is not valid for given list of size " + size + " and starting index " + fromIndex);
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            DefaultData element = (DefaultData)list.get(i);
            this.processElement(element);
        }
    }

    public List<E> getResultList() {
        ArrayList<DefaultData> returnList = new ArrayList<DefaultData>();
        for (IAggregatedData<E> aggregatedData : this.aggregationMap.values()) {
            returnList.add(aggregatedData.getData());
        }
        return returnList;
    }

    public void reset() {
        this.aggregationMap.clear();
    }
}

