/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration.validator.impl;

import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.ValidationError;
import info.novatec.inspectit.cmr.property.configuration.validator.AbstractComparingValidator;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.bind.annotation.XmlRootElement;
import org.hamcrest.Matchers;

@XmlRootElement(name="isGreaterOrEqual")
public class GreaterOrEqualValidator<T extends Number>
extends AbstractComparingValidator<T> {
    @Override
    protected void compare(SingleProperty<? extends T> property, SingleProperty<? extends T> againstProperty, T value, T against, PropertyValidation propertyValidation) {
        if (!this.matches(value, against)) {
            ArrayList properties = new ArrayList(2);
            properties.add(property);
            properties.add(againstProperty);
            ValidationError validationError = new ValidationError(properties, "Value of property '" + property.getName() + "' must be greater or equal than value of property '" + againstProperty.getName() + "'");
            propertyValidation.addValidationError(validationError);
        }
    }

    @Override
    protected void compare(SingleProperty<? extends T> property, T value, T against, PropertyValidation propertyValidation) {
        if (!this.matches(value, against)) {
            ValidationError validationError = new ValidationError(Collections.singletonList(property), "Value of property '" + property.getName() + "' must be greater or equal than " + against);
            propertyValidation.addValidationError(validationError);
        }
    }

    private boolean matches(T value, T against) {
        return Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(((Number)against).doubleValue())).matches((Object)((Number)value).doubleValue());
    }
}

