/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DefineCmrWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Define the information for the CMR Repository";
    private Text nameBox;
    private Text ipBox;
    private Text portBox;
    private Text descriptionBox;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private List<CmrRepositoryDefinition> existingRepositories;

    public DefineCmrWizardPage(String string) {
        this(string, null);
    }

    public DefineCmrWizardPage(String string, CmrRepositoryDefinition cmrRepositoryDefinition) {
        super(string);
        this.setTitle(string);
        this.setMessage(DEFAULT_MESSAGE);
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.existingRepositories = new ArrayList<CmrRepositoryDefinition>(InspectIT.getDefault().getCmrRepositoryManager().getCmrRepositoryDefinitions());
        if (cmrRepositoryDefinition != null) {
            this.existingRepositories.remove(cmrRepositoryDefinition);
        }
    }

    public void createControl(Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(composite2, 16384);
        label.setText("Server name:");
        this.nameBox = new Text(composite2, 2048);
        this.nameBox.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label label2 = new Label(composite2, 16384);
        label2.setText("IP Address:");
        this.ipBox = new Text(composite2, 2048);
        this.ipBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipBox.setText("localhost");
        Label label3 = new Label(composite2, 16384);
        label3.setText("Port:");
        this.portBox = new Text(composite2, 133120);
        GridData gridData = new GridData(4, 4, false, false);
        this.portBox.setLayoutData((Object)gridData);
        this.portBox.setText(String.valueOf(8182));
        this.portBox.setTextLimit(5);
        this.portBox.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (DefineCmrWizardPage.this.portBox.getText().length() > String.valueOf(8182).length()) {
                    composite2.layout();
                }
            }
        });
        Label label4 = new Label(composite2, 16384);
        label4.setText("Description:");
        label4.setLayoutData((Object)new GridData(4, 128, false, false));
        this.descriptionBox = new Text(composite2, 2626);
        gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.widthHint = 300;
        this.descriptionBox.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                DefineCmrWizardPage.this.setPageComplete(DefineCmrWizardPage.this.isPageComplete());
                DefineCmrWizardPage.this.setPageMessage();
            }
        };
        this.nameBox.addListener(24, listener);
        this.ipBox.addListener(24, listener);
        this.portBox.addListener(24, listener);
        if (this.cmrRepositoryDefinition != null) {
            this.nameBox.setText(this.cmrRepositoryDefinition.getName());
            this.ipBox.setText(this.cmrRepositoryDefinition.getIp());
            this.portBox.setText(String.valueOf(this.cmrRepositoryDefinition.getPort()));
            this.descriptionBox.setText(TextFormatter.emptyStringIfNull(this.cmrRepositoryDefinition.getDescription()));
        }
        this.setControl((Control)composite2);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean isPageComplete() {
        if (this.nameBox.getText().isEmpty()) {
            return false;
        }
        if (this.ipBox.getText().trim().isEmpty()) {
            return false;
        }
        if (this.portBox.getText().trim().isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(this.portBox.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string = this.ipBox.getText().trim();
        int n = Integer.parseInt(this.portBox.getText().trim());
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.existingRepositories) {
            if (!Objects.equals(string, cmrRepositoryDefinition.getIp()) || n != cmrRepositoryDefinition.getPort()) continue;
            return false;
        }
        return true;
    }

    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        CmrRepositoryDefinition cmrRepositoryDefinition = new CmrRepositoryDefinition(this.ipBox.getText().trim(), Integer.parseInt(this.portBox.getText()), this.nameBox.getText().trim());
        if (!this.descriptionBox.getText().trim().isEmpty()) {
            cmrRepositoryDefinition.setDescription(this.descriptionBox.getText().trim());
        } else {
            cmrRepositoryDefinition.setDescription("");
        }
        return cmrRepositoryDefinition;
    }

    private void setPageMessage() {
        if (this.nameBox.getText().isEmpty()) {
            this.setMessage("No value for the CMR name entered", 3);
            return;
        }
        if (this.ipBox.getText().trim().isEmpty()) {
            this.setMessage("No value for the CMR IP address entered", 3);
            return;
        }
        if (this.portBox.getText().trim().isEmpty()) {
            this.setMessage("No value for the CMR port entered", 3);
            return;
        }
        try {
            Integer.parseInt(this.portBox.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("The port is not in a valid number format", 3);
            return;
        }
        String string = this.ipBox.getText().trim();
        int n = Integer.parseInt(this.portBox.getText().trim());
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.existingRepositories) {
            if (!Objects.equals(string, cmrRepositoryDefinition.getIp()) || n != cmrRepositoryDefinition.getPort()) continue;
            this.setMessage("The repository with given IP address and port already exists", 3);
            return;
        }
        this.setMessage(DEFAULT_MESSAGE);
    }
}

