/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.label.edit.LabelValueEditingSupport;
import info.novatec.inspectit.rcp.wizard.ManageLabelWizard;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.BooleanStorageLabel;
import info.novatec.inspectit.storage.label.DateStorageLabel;
import info.novatec.inspectit.storage.label.NumberStorageLabel;
import info.novatec.inspectit.storage.label.StringStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class AddStorageLabelWizardPage
extends WizardPage {
    protected static final StyledString EMPTY_STYLED_STRING = new StyledString();
    private boolean optional;
    private String defaultMessage = "Define the new label type and its value";
    private StorageData storageData;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private List<AbstractStorageLabelType<?>> labelTypeList;
    private List<AbstractStorageLabel<?>> labelsToAdd = new ArrayList();
    private Combo labelTypeSelection;
    private TableViewer labelsTableViewer;
    private Composite main;
    private Button removeLabelButton;
    private Listener pageCompleteListener = new Listener(){

        public void handleEvent(Event event) {
            AddStorageLabelWizardPage.this.setPageComplete(AddStorageLabelWizardPage.this.isPageComplete());
        }
    };
    private TableViewerColumn value;

    public AddStorageLabelWizardPage(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition) {
        super("Add New Labels");
        this.setTitle("Add New Labels");
        this.defaultMessage = String.valueOf(this.defaultMessage) + " for the storage '" + storageData.getName() + "'";
        this.setMessage(this.defaultMessage);
        this.storageData = storageData;
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.optional = false;
        this.labelTypeList = cmrRepositoryDefinition.getStorageService().getAllLabelTypes();
    }

    public AddStorageLabelWizardPage(CmrRepositoryDefinition cmrRepositoryDefinition) {
        super("Add New Labels");
        this.setTitle("Add New Labels");
        this.defaultMessage = "Optionally add one or more labels to the selected storage";
        this.setMessage(this.defaultMessage);
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.optional = true;
    }

    public void createControl(Composite composite) {
        this.main = new Composite(composite, 0);
        this.main.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(this.main, 0);
        label.setText("Label type:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.labelTypeSelection = new Combo(this.main, 8);
        this.labelTypeSelection.setLayoutData((Object)new GridData(4, 4, true, false));
        final Button button = new Button(this.main, 8);
        button.setEnabled(false);
        button.setText("Add");
        button.setToolTipText("Add Label");
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = AddStorageLabelWizardPage.this.labelTypeSelection.getSelectionIndex();
                if (-1 != n) {
                    BooleanStorageLabel booleanStorageLabel;
                    AbstractStorageLabelType abstractStorageLabelType = (AbstractStorageLabelType)AddStorageLabelWizardPage.this.labelTypeList.get(n);
                    if (abstractStorageLabelType.isOnePerStorage() && AddStorageLabelWizardPage.this.isLabelTypePresent(abstractStorageLabelType)) {
                        AddStorageLabelWizardPage.this.setMessage("Selected label type is one-per-storage. New label value will overwrite the old one.", 2);
                        booleanStorageLabel = AddStorageLabelWizardPage.this.labelsToAdd.iterator();
                        while (booleanStorageLabel.hasNext()) {
                            if (!Objects.equals(((AbstractStorageLabel)booleanStorageLabel.next()).getStorageLabelType(), abstractStorageLabelType)) continue;
                            booleanStorageLabel.remove();
                            break;
                        }
                    } else {
                        AddStorageLabelWizardPage.this.setMessage(AddStorageLabelWizardPage.this.defaultMessage);
                    }
                    if (abstractStorageLabelType.getValueClass().equals(Boolean.class)) {
                        booleanStorageLabel = new BooleanStorageLabel();
                        booleanStorageLabel.setStorageLabelType(abstractStorageLabelType);
                        AddStorageLabelWizardPage.this.labelsToAdd.add(booleanStorageLabel);
                    } else if (abstractStorageLabelType.getValueClass().equals(Date.class)) {
                        booleanStorageLabel = new DateStorageLabel();
                        booleanStorageLabel.setStorageLabelType(abstractStorageLabelType);
                        AddStorageLabelWizardPage.this.labelsToAdd.add(booleanStorageLabel);
                    } else if (abstractStorageLabelType.getValueClass().equals(Number.class)) {
                        booleanStorageLabel = new NumberStorageLabel();
                        booleanStorageLabel.setStorageLabelType(abstractStorageLabelType);
                        AddStorageLabelWizardPage.this.labelsToAdd.add(booleanStorageLabel);
                    } else if (abstractStorageLabelType.getValueClass().equals(String.class)) {
                        booleanStorageLabel = new StringStorageLabel();
                        booleanStorageLabel.setStorageLabelType(abstractStorageLabelType);
                        AddStorageLabelWizardPage.this.labelsToAdd.add(booleanStorageLabel);
                    }
                    AddStorageLabelWizardPage.this.labelsTableViewer.refresh();
                    AddStorageLabelWizardPage.this.labelsTableViewer.editElement(AddStorageLabelWizardPage.this.labelsToAdd.get(AddStorageLabelWizardPage.this.labelsToAdd.size() - 1), 1);
                }
            }
        });
        this.labelTypeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                button.setEnabled(AddStorageLabelWizardPage.this.labelTypeSelection.getSelectionIndex() >= 0);
            }
        });
        Button button2 = new Button(this.main, 8);
        button2.setImage(InspectIT.getDefault().getImage("/icons/eclipse/label.gif"));
        button2.setToolTipText("Manage Labels on Repository");
        button2.setLayoutData((Object)new GridData(4, 4, false, false));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageLabelWizard manageLabelWizard = new ManageLabelWizard(AddStorageLabelWizardPage.this.cmrRepositoryDefinition);
                WizardDialog wizardDialog = new WizardDialog(AddStorageLabelWizardPage.this.getShell(), (IWizard)manageLabelWizard);
                wizardDialog.open();
                if (wizardDialog.getReturnCode() == 0) {
                    AddStorageLabelWizardPage.this.updateLabelTypes();
                }
            }
        });
        this.createLabelTable(this.main);
        GridData gridData = new GridData(4, 4, true, true, 4, 1);
        gridData.minimumHeight = 100;
        this.labelsTableViewer.getTable().setLayoutData((Object)gridData);
        button.addListener(13, this.pageCompleteListener);
        this.labelsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AddStorageLabelWizardPage.this.removeLabelButton.setEnabled(!AddStorageLabelWizardPage.this.labelsTableViewer.getSelection().isEmpty());
            }
        });
        this.labelsTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127) {
                    AddStorageLabelWizardPage.this.deleteSelectedlabels();
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new Label(this.main, 0).setLayoutData((Object)gridData);
        this.removeLabelButton = new Button(this.main, 8);
        this.removeLabelButton.setText("Remove");
        this.removeLabelButton.setToolTipText("Remove Selected Labels");
        this.removeLabelButton.setEnabled(false);
        this.removeLabelButton.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.removeLabelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddStorageLabelWizardPage.this.deleteSelectedlabels();
            }
        });
        this.updateLabelTypes();
        this.setControl((Control)this.main);
    }

    private void updateLabelTypes() {
        Job job = new Job("Loading Label Types"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (AddStorageLabelWizardPage.this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    AddStorageLabelWizardPage.this.labelTypeList = AddStorageLabelWizardPage.this.cmrRepositoryDefinition.getStorageService().getAllLabelTypes();
                } else {
                    AddStorageLabelWizardPage.this.labelTypeList = Collections.emptyList();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AddStorageLabelWizardPage.this.labelTypeSelection.removeAll();
                        for (AbstractStorageLabelType abstractStorageLabelType : AddStorageLabelWizardPage.this.labelTypeList) {
                            AddStorageLabelWizardPage.this.labelTypeSelection.add(TextFormatter.getLabelName(abstractStorageLabelType));
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void deleteSelectedlabels() {
        StructuredSelection structuredSelection = (StructuredSelection)this.labelsTableViewer.getSelection();
        if (!structuredSelection.isEmpty()) {
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                this.labelsToAdd.remove(iterator.next());
            }
            this.labelsTableViewer.refresh();
            this.setPageComplete(this.isPageComplete());
        }
    }

    private void createLabelTable(Composite composite) {
        Table table = new Table(composite, 268503810);
        table.setHeaderVisible(true);
        this.labelsTableViewer = new TableViewer(table);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.labelsTableViewer, 0);
        tableViewerColumn.getColumn().setText("Label");
        tableViewerColumn.getColumn().setMoveable(false);
        tableViewerColumn.getColumn().setResizable(true);
        tableViewerColumn.getColumn().setWidth(200);
        this.value = new TableViewerColumn(this.labelsTableViewer, 0);
        this.value.getColumn().setText("Value");
        this.value.getColumn().setMoveable(false);
        this.value.getColumn().setResizable(true);
        this.value.getColumn().setWidth(100);
        LabelValueEditingSupport labelValueEditingSupport = new LabelValueEditingSupport(this.labelsTableViewer, this.storageData, this.cmrRepositoryDefinition);
        labelValueEditingSupport.addLabelEditListener(new LabelValueEditingSupport.LabelEditListener(){

            @Override
            public void preLabelValueChange(AbstractStorageLabel<?> abstractStorageLabel) {
            }

            @Override
            public void postLabelValueChange(AbstractStorageLabel<?> abstractStorageLabel) {
                AddStorageLabelWizardPage.this.setPageComplete(AddStorageLabelWizardPage.this.isPageComplete());
            }
        });
        this.value.setEditingSupport((EditingSupport)labelValueEditingSupport);
        this.labelsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelsTableViewer.setLabelProvider((IBaseLabelProvider)new StyledCellIndexLabelProvider(){

            @Override
            protected StyledString getStyledText(Object object, int n) {
                if (object instanceof AbstractStorageLabel) {
                    AbstractStorageLabel abstractStorageLabel = (AbstractStorageLabel)object;
                    switch (n) {
                        case 0: {
                            return new StyledString(TextFormatter.getLabelName(abstractStorageLabel));
                        }
                        case 1: {
                            if (abstractStorageLabel.getValue() == null) break;
                            return new StyledString(TextFormatter.getLabelValue(abstractStorageLabel, false));
                        }
                    }
                }
                return EMPTY_STYLED_STRING;
            }

            @Override
            protected Image getColumnImage(Object object, int n) {
                if (n == 0 && object instanceof AbstractStorageLabel) {
                    return ImageFormatter.getImageForLabel(((AbstractStorageLabel)object).getStorageLabelType());
                }
                return null;
            }
        });
        this.labelsTableViewer.setInput(this.labelsToAdd);
    }

    private boolean isLabelTypePresent(AbstractStorageLabelType<?> abstractStorageLabelType) {
        if (this.storageData.isLabelPresent(abstractStorageLabelType)) {
            return true;
        }
        for (AbstractStorageLabel<?> abstractStorageLabel : this.labelsToAdd) {
            if (!ObjectUtils.equals(abstractStorageLabelType, (Object)abstractStorageLabel.getStorageLabelType())) continue;
            return true;
        }
        return false;
    }

    public boolean isPageComplete() {
        if (this.optional) {
            return true;
        }
        if (!this.labelsToAdd.isEmpty()) {
            for (AbstractStorageLabel<?> abstractStorageLabel : this.labelsToAdd) {
                if (abstractStorageLabel.getValue() == null) continue;
                return true;
            }
        }
        return false;
    }

    public List<AbstractStorageLabel<?>> getLabelsToAdd() {
        Iterator<AbstractStorageLabel<?>> iterator = this.labelsToAdd.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != null) continue;
            iterator.remove();
        }
        return this.labelsToAdd;
    }

    public void setStorageData(StorageData storageData) {
        this.storageData = storageData;
        LabelValueEditingSupport labelValueEditingSupport = new LabelValueEditingSupport(this.labelsTableViewer, storageData, this.cmrRepositoryDefinition);
        labelValueEditingSupport.addLabelEditListener(new LabelValueEditingSupport.LabelEditListener(){

            @Override
            public void preLabelValueChange(AbstractStorageLabel<?> abstractStorageLabel) {
            }

            @Override
            public void postLabelValueChange(AbstractStorageLabel<?> abstractStorageLabel) {
                AddStorageLabelWizardPage.this.setPageComplete(AddStorageLabelWizardPage.this.isPageComplete());
            }
        });
        this.value.setEditingSupport((EditingSupport)labelValueEditingSupport);
    }
}

