/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.view.impl;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.tree.DeferredTreeViewer;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.form.CmrRepositoryPropertyForm;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.AgentLeaf;
import info.novatec.inspectit.rcp.model.Component;
import info.novatec.inspectit.rcp.model.DeferredAgentsComposite;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.CmrRepositoryManager;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.view.IRefreshableView;
import info.novatec.inspectit.rcp.view.tree.TreeContentProvider;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.UIJob;

public class RepositoryManagerView
extends ViewPart
implements IRefreshableView,
CmrRepositoryChangeListener {
    public static final String VIEW_ID = "info.novatec.inspectit.rcp.view.repositoryManager";
    private static final String MENU_ID = "info.novatec.inspectit.rcp.view.repositoryManager.repositoryTree";
    private CmrRepositoryManager cmrRepositoryManager;
    private List<DeferredAgentsComposite> inputList = new ArrayList<DeferredAgentsComposite>();
    private Map<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus> cachedStatusMap = new ConcurrentHashMap<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus>();
    private FormToolkit toolkit;
    private Form mainForm;
    private DeferredTreeViewer treeViewer;
    private Composite messageComposite;
    private CmrRepositoryPropertyForm cmrPropertyForm;
    private SashForm mainComposite;
    private boolean verticaLayout = true;
    private DeferredAgentsComposite lastSelectedRepository = null;
    private boolean showOldAgents = false;
    private AgentStatusUpdateJob agentStatusUpdateJob;
    private List<Object> expandedList;

    public RepositoryManagerView() {
        this.cmrRepositoryManager = InspectIT.getDefault().getCmrRepositoryManager();
        this.cmrRepositoryManager.addCmrRepositoryChangeListener(this);
        this.createInputList();
    }

    public void createPartControl(Composite composite) {
        this.createViewToolbar();
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.mainComposite = new SashForm(composite, 512);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        this.mainForm = this.toolkit.createForm((Composite)this.mainComposite);
        this.mainForm.getBody().setLayout((Layout)new GridLayout(1, true));
        this.mainForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.toolkit.decorateFormHeading(this.mainForm);
        int n = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        Tree tree = this.toolkit.createTree(this.mainForm.getBody(), 770);
        this.toolkit.setBorderStyle(n);
        this.treeViewer = new DeferredTreeViewer(tree);
        TreeContentProvider treeContentProvider = new TreeContentProvider(){

            @Override
            public Object[] getElements(Object object) {
                if (object instanceof Object[]) {
                    return (Object[])object;
                }
                if (object instanceof Collection) {
                    return ((Collection)object).toArray();
                }
                return new Object[0];
            }
        };
        treeContentProvider.addUpdateCompleteListener((IJobChangeListener)new ExpandFoldersUpdateCompleteListener());
        this.treeViewer.setContentProvider((IContentProvider)treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof info.novatec.inspectit.rcp.model.Composite && !(object2 instanceof info.novatec.inspectit.rcp.model.Composite)) {
                    return -1;
                }
                if (!(object instanceof info.novatec.inspectit.rcp.model.Composite) && object2 instanceof info.novatec.inspectit.rcp.model.Composite) {
                    return 1;
                }
                if (object instanceof Component && object2 instanceof Component) {
                    return ((Component)object).getName().compareToIgnoreCase(((Component)object2).getName());
                }
                if (object instanceof Component) {
                    return 1;
                }
                if (object2 instanceof Component) {
                    return -1;
                }
                return 0;
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                if (structuredSelection.getFirstElement() instanceof DeferredAgentsComposite) {
                    RepositoryManagerView.this.lastSelectedRepository = (DeferredAgentsComposite)structuredSelection.getFirstElement();
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new RepositoryManagerDoubleClickListener());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.treeViewer.setInput(this.inputList);
        this.cmrPropertyForm = new CmrRepositoryPropertyForm((Composite)this.mainComposite);
        this.cmrPropertyForm.setLayoutData(new GridData(4, 4, true, true));
        this.treeViewer.addSelectionChangedListener(this.cmrPropertyForm);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(MENU_ID, menuManager, (ISelectionProvider)this.treeViewer);
        Control control = this.treeViewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        this.mainComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                int n = ((RepositoryManagerView)RepositoryManagerView.this).mainComposite.getBounds().width;
                int n2 = ((RepositoryManagerView)RepositoryManagerView.this).mainComposite.getBounds().height;
                if (n > n2 && RepositoryManagerView.this.verticaLayout) {
                    RepositoryManagerView.this.verticaLayout = false;
                    RepositoryManagerView.this.mainComposite.setOrientation(256);
                } else if (n < n2 && !RepositoryManagerView.this.verticaLayout) {
                    RepositoryManagerView.this.verticaLayout = true;
                    RepositoryManagerView.this.mainComposite.setOrientation(512);
                }
                RepositoryManagerView.this.mainComposite.layout();
            }
        });
        this.updateFormBody();
        this.mainComposite.setWeights(new int[]{2, 3});
        this.agentStatusUpdateJob = new AgentStatusUpdateJob();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void createViewToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)new ShowAgentsAction());
        iToolBarManager.add((IAction)new ShowPropertiesAction());
        iToolBarManager.add((IContributionItem)new Separator());
    }

    private void createInputList() {
        this.inputList.clear();
        List<CmrRepositoryDefinition> list = this.cmrRepositoryManager.getCmrRepositoryDefinitions();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : list) {
            this.inputList.add(new DeferredAgentsComposite(cmrRepositoryDefinition, this.showOldAgents));
            CmrRepositoryDefinition.OnlineStatus onlineStatus = cmrRepositoryDefinition.getOnlineStatus();
            if (onlineStatus != CmrRepositoryDefinition.OnlineStatus.ONLINE && onlineStatus != CmrRepositoryDefinition.OnlineStatus.OFFLINE) continue;
            this.cachedStatusMap.put(cmrRepositoryDefinition, onlineStatus);
        }
    }

    private void updateFormBody() {
        this.clearFormBody();
        if (!this.inputList.isEmpty()) {
            this.treeViewer.getTree().setVisible(true);
            this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
            this.treeViewer.setInput(this.inputList);
            this.treeViewer.expandAll();
            if (this.lastSelectedRepository != null && this.inputList.contains(this.lastSelectedRepository)) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)this.lastSelectedRepository);
                this.treeViewer.setSelection((ISelection)structuredSelection, true);
            }
        } else {
            this.displayMessage("No CMR repository present. Please add the CMR repository via 'Add CMR repository' action.", Display.getDefault().getSystemImage(2));
        }
        this.mainForm.getBody().layout();
    }

    private void clearFormBody() {
        if (this.messageComposite != null && !this.messageComposite.isDisposed()) {
            this.messageComposite.dispose();
        }
        this.treeViewer.setInput(Collections.emptyList());
        this.treeViewer.getTree().setVisible(false);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(16384, 128, false, false));
    }

    private void displayMessage(String string, Image image) {
        if (this.messageComposite == null || this.messageComposite.isDisposed()) {
            this.messageComposite = this.toolkit.createComposite(this.mainForm.getBody());
        } else {
            Control[] controlArray = this.messageComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++n2;
            }
        }
        this.messageComposite.setLayout((Layout)new GridLayout(2, false));
        this.messageComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.toolkit.createLabel(this.messageComposite, null).setImage(image);
        this.toolkit.createLabel(this.messageComposite, string, 64).setLayoutData((Object)new GridData(4, 0x1000000, true, true));
    }

    public void setFocus() {
        if (this.treeViewer.getTree().isVisible()) {
            this.treeViewer.getTree().setFocus();
        } else {
            this.mainForm.setFocus();
        }
    }

    @Override
    public void repositoryOnlineStatusUpdated(final CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
        if (onlineStatus2 != CmrRepositoryDefinition.OnlineStatus.CHECKING) {
            CmrRepositoryDefinition.OnlineStatus onlineStatus3 = this.cachedStatusMap.get(cmrRepositoryDefinition);
            if (onlineStatus3 != null && onlineStatus3 != onlineStatus2) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryManagerView.this.mainForm.setBusy(true);
                        for (DeferredAgentsComposite deferredAgentsComposite : RepositoryManagerView.this.inputList) {
                            if (!ObjectUtils.equals((Object)deferredAgentsComposite.getRepositoryDefinition(), (Object)cmrRepositoryDefinition)) continue;
                            RepositoryManagerView.this.treeViewer.refresh(deferredAgentsComposite, true);
                            RepositoryManagerView.this.treeViewer.expandAll();
                            if (!ObjectUtils.equals((Object)deferredAgentsComposite, (Object)RepositoryManagerView.this.lastSelectedRepository) || RepositoryManagerView.this.lastSelectedRepository == null || !RepositoryManagerView.this.inputList.contains(RepositoryManagerView.this.lastSelectedRepository)) continue;
                            RepositoryManagerView.this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                            StructuredSelection structuredSelection = new StructuredSelection((Object)RepositoryManagerView.this.lastSelectedRepository);
                            RepositoryManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
                        }
                        RepositoryManagerView.this.mainForm.setBusy(false);
                    }
                });
            }
            this.cachedStatusMap.put(cmrRepositoryDefinition, onlineStatus2);
        }
    }

    @Override
    public void repositoryDataUpdated(final CmrRepositoryDefinition cmrRepositoryDefinition) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RepositoryManagerView.this.mainForm.setBusy(true);
                for (DeferredAgentsComposite deferredAgentsComposite : RepositoryManagerView.this.inputList) {
                    if (!ObjectUtils.equals((Object)deferredAgentsComposite.getRepositoryDefinition(), (Object)cmrRepositoryDefinition)) continue;
                    RepositoryManagerView.this.treeViewer.refresh(deferredAgentsComposite);
                    break;
                }
                RepositoryManagerView.this.mainForm.setBusy(false);
            }
        });
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
        DeferredAgentsComposite deferredAgentsComposite = new DeferredAgentsComposite(cmrRepositoryDefinition, this.showOldAgents);
        this.inputList.add(deferredAgentsComposite);
        CmrRepositoryDefinition.OnlineStatus onlineStatus = cmrRepositoryDefinition.getOnlineStatus();
        this.cachedStatusMap.put(cmrRepositoryDefinition, onlineStatus);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RepositoryManagerView.this.mainForm.setBusy(true);
                if (RepositoryManagerView.this.inputList.size() > 1) {
                    RepositoryManagerView.this.treeViewer.refresh();
                    if (RepositoryManagerView.this.lastSelectedRepository != null && RepositoryManagerView.this.inputList.contains(RepositoryManagerView.this.lastSelectedRepository)) {
                        StructuredSelection structuredSelection = new StructuredSelection((Object)RepositoryManagerView.this.lastSelectedRepository);
                        RepositoryManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
                    }
                } else {
                    RepositoryManagerView.this.updateFormBody();
                }
                RepositoryManagerView.this.mainForm.setBusy(false);
            }
        });
    }

    @Override
    public void repositoryRemoved(final CmrRepositoryDefinition cmrRepositoryDefinition) {
        DeferredAgentsComposite deferredAgentsComposite = null;
        for (DeferredAgentsComposite deferredAgentsComposite2 : this.inputList) {
            if (!ObjectUtils.equals((Object)deferredAgentsComposite2.getRepositoryDefinition(), (Object)cmrRepositoryDefinition)) continue;
            deferredAgentsComposite = deferredAgentsComposite2;
            break;
        }
        if (deferredAgentsComposite != null) {
            this.inputList.remove(deferredAgentsComposite);
        }
        this.cachedStatusMap.remove(cmrRepositoryDefinition);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)RepositoryManagerView.this.lastSelectedRepository.getRepositoryDefinition())) {
                    RepositoryManagerView.this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                if (RepositoryManagerView.this.inputList.isEmpty()) {
                    RepositoryManagerView.this.updateFormBody();
                } else {
                    RepositoryManagerView.this.treeViewer.refresh();
                }
            }
        });
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
        DeferredAgentsComposite deferredAgentsComposite = null;
        for (final DeferredAgentsComposite deferredAgentsComposite2 : this.inputList) {
            if (!ObjectUtils.equals((Object)deferredAgentsComposite2.getRepositoryDefinition(), (Object)cmrRepositoryDefinition)) continue;
            deferredAgentsComposite = deferredAgentsComposite2;
            break;
        }
        if (deferredAgentsComposite != null) {
            DeferredAgentsComposite deferredAgentsComposite2;
            deferredAgentsComposite2 = deferredAgentsComposite;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RepositoryManagerView.this.treeViewer.refresh(deferredAgentsComposite2, true);
                    if (ObjectUtils.equals((Object)deferredAgentsComposite2, (Object)RepositoryManagerView.this.lastSelectedRepository)) {
                        RepositoryManagerView.this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                        StructuredSelection structuredSelection = new StructuredSelection((Object)deferredAgentsComposite2);
                        RepositoryManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
                        if (RepositoryManagerView.this.cmrPropertyForm != null && !RepositoryManagerView.this.cmrPropertyForm.isDisposed()) {
                            RepositoryManagerView.this.cmrPropertyForm.refresh();
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void refresh() {
        Collection<CmrRepositoryManager.UpdateRepositoryJob> collection;
        Object[] objectArray = this.treeViewer.getExpandedElements();
        HashSet<Object> hashSet = new HashSet<Object>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            collection = objectArray2[n2];
            Object object = ((ITreeContentProvider)this.treeViewer.getContentProvider()).getParent((Object)collection);
            while (object != null) {
                hashSet.add(object);
                object = ((ITreeContentProvider)this.treeViewer.getContentProvider()).getParent(object);
            }
            ++n2;
        }
        this.expandedList = new ArrayList<Object>(Arrays.asList(objectArray));
        this.expandedList.removeAll(hashSet);
        collection = this.cmrRepositoryManager.forceAllCmrRepositoriesOnlineStatusUpdate();
        for (final CmrRepositoryManager.UpdateRepositoryJob updateRepositoryJob : collection) {
            updateRepositoryJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    CmrRepositoryDefinition cmrRepositoryDefinition = updateRepositoryJob.getCmrRepositoryDefinition();
                    DeferredAgentsComposite deferredAgentsComposite = null;
                    for (final DeferredAgentsComposite deferredAgentsComposite2 : RepositoryManagerView.this.inputList) {
                        if (!ObjectUtils.equals((Object)deferredAgentsComposite2.getRepositoryDefinition(), (Object)cmrRepositoryDefinition)) continue;
                        deferredAgentsComposite = deferredAgentsComposite2;
                        break;
                    }
                    if (deferredAgentsComposite != null) {
                        DeferredAgentsComposite deferredAgentsComposite2;
                        deferredAgentsComposite2 = deferredAgentsComposite;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RepositoryManagerView.this.treeViewer.refresh(deferredAgentsComposite2, true);
                                if (ObjectUtils.equals((Object)deferredAgentsComposite2, (Object)RepositoryManagerView.this.lastSelectedRepository) && RepositoryManagerView.this.cmrPropertyForm != null && !RepositoryManagerView.this.cmrPropertyForm.isDisposed()) {
                                    RepositoryManagerView.this.cmrPropertyForm.refresh();
                                }
                            }
                        });
                    }
                    updateRepositoryJob.removeJobChangeListener((IJobChangeListener)this);
                }
            });
        }
    }

    @Override
    public boolean canRefresh() {
        return !this.inputList.isEmpty() || !this.cmrRepositoryManager.getCmrRepositoryDefinitions().isEmpty();
    }

    public void setShowProperties(boolean bl) {
        if (bl) {
            CmrRepositoryDefinition cmrRepositoryDefinition = null;
            StructuredSelection structuredSelection = (StructuredSelection)this.treeViewer.getSelection();
            if (!structuredSelection.isEmpty() && structuredSelection.getFirstElement() instanceof ICmrRepositoryProvider) {
                cmrRepositoryDefinition = ((ICmrRepositoryProvider)structuredSelection.getFirstElement()).getCmrRepositoryDefinition();
            }
            this.cmrPropertyForm = new CmrRepositoryPropertyForm((Composite)this.mainComposite, cmrRepositoryDefinition);
            this.cmrPropertyForm.setLayoutData(new GridData(4, 4, true, true));
            this.treeViewer.addSelectionChangedListener(this.cmrPropertyForm);
            this.mainComposite.setWeights(new int[]{2, 3});
            this.mainComposite.layout();
        } else {
            if (this.cmrPropertyForm != null && !this.cmrPropertyForm.isDisposed()) {
                this.treeViewer.removeSelectionChangedListener(this.cmrPropertyForm);
                this.cmrPropertyForm.dispose();
                this.cmrPropertyForm = null;
            }
            this.mainComposite.setWeights(new int[]{1});
            this.mainComposite.layout();
        }
    }

    public void dispose() {
        this.cmrRepositoryManager.removeCmrRepositoryChangeListener(this);
        this.agentStatusUpdateJob.cancel();
        super.dispose();
    }

    private final class AgentStatusUpdateJob
    extends Job {
        private static final long UPDATE_RATE = 60000L;

        public AgentStatusUpdateJob() {
            super("Agents status auto-update");
            this.setUser(false);
            this.setProperty(IProgressConstants.ICON_PROPERTY, InspectIT.getDefault().getImageDescriptor("/icons/eclipse/agent.gif"));
            this.schedule(60000L);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            this.updateAgentsAndCmrStatus();
            this.schedule(60000L);
            return Status.OK_STATUS;
        }

        private void updateAgentsAndCmrStatus() {
            if (RepositoryManagerView.this.cmrPropertyForm != null && !RepositoryManagerView.this.cmrPropertyForm.isDisposed()) {
                RepositoryManagerView.this.cmrPropertyForm.refresh();
            }
            if (RepositoryManagerView.this.inputList != null) {
                final ArrayList<AgentLeaf> arrayList = new ArrayList<AgentLeaf>();
                for (DeferredAgentsComposite deferredAgentsComposite : RepositoryManagerView.this.inputList) {
                    CmrRepositoryDefinition cmrRepositoryDefinition = deferredAgentsComposite.getCmrRepositoryDefinition();
                    List<Component> list = deferredAgentsComposite.getChildren();
                    if (!CollectionUtils.isNotEmpty(list) || cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) continue;
                    Map map = cmrRepositoryDefinition.getGlobalDataAccessService().getAgentsOverview();
                    for (Component component : list) {
                        if (!(component instanceof AgentLeaf)) continue;
                        AgentLeaf agentLeaf = (AgentLeaf)component;
                        AgentStatusData agentStatusData = (AgentStatusData)map.get(agentLeaf.getPlatformIdent());
                        agentLeaf.setAgentStatusData(agentStatusData);
                        arrayList.add(agentLeaf);
                    }
                }
                if (CollectionUtils.isNotEmpty(arrayList)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RepositoryManagerView.this.treeViewer.update(arrayList.toArray(), null);
                        }
                    });
                }
            }
        }
    }

    private class ExpandFoldersUpdateCompleteListener
    extends JobChangeAdapter {
        private ExpandFoldersUpdateCompleteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent iJobChangeEvent) {
            RepositoryManagerView repositoryManagerView = RepositoryManagerView.this;
            synchronized (repositoryManagerView) {
                if (CollectionUtils.isNotEmpty((Collection)RepositoryManagerView.this.expandedList) && CollectionUtils.isNotEmpty((Collection)RepositoryManagerView.this.inputList)) {
                    Iterator iterator = RepositoryManagerView.this.expandedList.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!RepositoryManagerView.this.treeViewer.isExpandable(e) || RepositoryManagerView.this.treeViewer.getExpandedState(e)) continue;
                        RepositoryManagerView.this.treeViewer.expandObject(e, 1);
                        iterator.remove();
                    }
                }
            }
        }
    }

    private class RepositoryManagerDoubleClickListener
    implements IDoubleClickListener {
        private RepositoryManagerDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            UIJob uIJob = new UIJob("Opening Data Explorer.."){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    RepositoryManagerDoubleClickListener.this.process();
                    return Status.OK_STATUS;
                }
            };
            uIJob.setUser(true);
            uIJob.schedule();
        }

        private void process() {
            Object object;
            RepositoryDefinition repositoryDefinition = null;
            PlatformIdent platformIdent = null;
            StructuredSelection structuredSelection = (StructuredSelection)RepositoryManagerView.this.treeViewer.getSelection();
            Object object2 = structuredSelection.getFirstElement();
            if (object2 instanceof DeferredAgentsComposite) {
                repositoryDefinition = ((DeferredAgentsComposite)object2).getRepositoryDefinition();
            } else if (object2 instanceof AgentLeaf) {
                platformIdent = ((AgentLeaf)object2).getPlatformIdent();
                object = ((AgentLeaf)object2).getParent();
                while (object != null) {
                    if (object instanceof DeferredAgentsComposite) {
                        repositoryDefinition = ((DeferredAgentsComposite)object).getRepositoryDefinition();
                        break;
                    }
                    object = ((Component)object).getParent();
                }
            }
            if (repositoryDefinition != null) {
                object = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.showRepository");
                ExecutionEvent executionEvent = object.createExecutionEvent(command, new Event());
                IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
                iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.showRepository.repository", (Object)repositoryDefinition);
                if (platformIdent != null) {
                    iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.showRepository.agent", (Object)platformIdent);
                }
                try {
                    command.executeWithChecks(executionEvent);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            } else if (RepositoryManagerView.this.treeViewer.getExpandedState(object2)) {
                RepositoryManagerView.this.treeViewer.collapseToLevel(object2, 1);
            } else {
                RepositoryManagerView.this.treeViewer.expandToLevel(object2, 1);
            }
        }
    }

    private static class RepositoryTreeLabelProvider
    extends StyledCellIndexLabelProvider {
        private RepositoryTreeLabelProvider() {
        }

        @Override
        protected Image getColumnImage(Object object, int n) {
            if (object instanceof DeferredAgentsComposite) {
                CmrRepositoryDefinition cmrRepositoryDefinition = (CmrRepositoryDefinition)((DeferredAgentsComposite)object).getRepositoryDefinition();
                return ImageFormatter.getCmrRepositoryImage(cmrRepositoryDefinition, true);
            }
            if (object instanceof AgentLeaf) {
                return ImageFormatter.getAgentImage(((AgentLeaf)object).getAgentStatusData());
            }
            if (object instanceof Component) {
                return ((Component)object).getImage();
            }
            return null;
        }

        @Override
        protected StyledString getStyledText(Object object, int n) {
            if (object instanceof DeferredAgentsComposite) {
                CmrRepositoryDefinition cmrRepositoryDefinition = (CmrRepositoryDefinition)((DeferredAgentsComposite)object).getRepositoryDefinition();
                return new StyledString(cmrRepositoryDefinition.getName());
            }
            if (object instanceof AgentLeaf) {
                return TextFormatter.getStyledAgentLeafString((AgentLeaf)object);
            }
            if (object instanceof Component) {
                return new StyledString(((Component)object).getName());
            }
            return null;
        }

        @Override
        public String getToolTipText(Object object) {
            if (object instanceof AgentLeaf) {
                return "Double click to explore Agent in the Data Explorer";
            }
            return null;
        }

        public Point getToolTipShift(Object object) {
            int n = 5;
            int n2 = 5;
            return new Point(n, n2);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }
    }

    private class ShowAgentsAction
    extends Action {
        public ShowAgentsAction() {
            super(null, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/agent.gif"));
            this.setChecked(RepositoryManagerView.this.showOldAgents);
            this.updateToolTipText();
        }

        public void run() {
            RepositoryManagerView.this.showOldAgents = this.isChecked();
            this.updateToolTipText();
            RepositoryManagerView.this.createInputList();
            RepositoryManagerView.this.updateFormBody();
        }

        private void updateToolTipText() {
            if (this.isChecked()) {
                this.setToolTipText("Hide Agents which have not sent any data yet.");
            } else {
                this.setToolTipText("Show Agents which have not sent any data yet.");
            }
        }
    }

    private class ShowPropertiesAction
    extends Action {
        public ShowPropertiesAction() {
            super(null, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/properties.gif"));
            this.setChecked(true);
            this.setToolTipText("Hide Properties");
        }

        public void run() {
            if (this.isChecked()) {
                RepositoryManagerView.this.setShowProperties(true);
                this.setToolTipText("Hide Properties");
            } else {
                RepositoryManagerView.this.setShowProperties(false);
                this.setToolTipText("Show Properties");
            }
        }
    }
}

