/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.view.impl;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.tree.DeferredTreeViewer;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.TreeModelManager;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.CmrRepositoryManager;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.listener.StorageChangeListener;
import info.novatec.inspectit.rcp.util.SelectionProviderAdapter;
import info.novatec.inspectit.rcp.view.IRefreshableView;
import info.novatec.inspectit.rcp.view.listener.TreeViewDoubleClickListener;
import info.novatec.inspectit.rcp.view.tree.TreeContentProvider;
import info.novatec.inspectit.rcp.view.tree.TreeLabelProvider;
import info.novatec.inspectit.rcp.view.tree.TreeViewerComparator;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class DataExplorerView
extends ViewPart
implements CmrRepositoryChangeListener,
StorageChangeListener,
IRefreshableView {
    private static final String REFRESH_CONTRIBUTION_ITEM = "info.novatec.inspectit.rcp.view.dataExplorer.refresh";
    private static final String CLEAR_BUFFER_CONTRIBUTION_ITEM = "info.novatec.inspectit.rcp.view.dataExplorer.clearBuffer";
    public static final String VIEW_ID = "info.novatec.inspectit.rcp.view.dataExplorer";
    private RepositoryDefinition displayedRepositoryDefinition;
    private PlatformIdent displayedAgent;
    private List<? extends PlatformIdent> availableAgents;
    private ConcurrentHashMap<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus> cachedOnlineStatus = new ConcurrentHashMap();
    private final TreeViewDoubleClickListener treeViewDoubleClickListener = new TreeViewDoubleClickListener();
    private FormToolkit toolkit;
    private Form mainForm;
    private DeferredTreeViewer treeViewer;
    private Composite messageComposite;
    private CollapseAction collapseAction;
    private SelectionProviderAdapter selectionProviderAdapter = new SelectionProviderAdapter();
    private Combo agentsCombo;
    private IToolBarManager toolBarManager;
    private Map<Integer, List<Object>> expandedElementsPerAgent = new ConcurrentHashMap<Integer, List<Object>>();
    private boolean hideInactiveInstrumentations = true;

    public DataExplorerView() {
        InspectIT.getDefault().getCmrRepositoryManager().addCmrRepositoryChangeListener(this);
        InspectIT.getDefault().getInspectITStorageManager().addStorageChangeListener(this);
    }

    public void createPartControl(Composite composite) {
        this.createViewToolbar();
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.mainForm = this.toolkit.createForm(composite);
        this.mainForm.getBody().setLayout((Layout)new GridLayout(1, true));
        this.createHeadClient();
        this.toolkit.decorateFormHeading(this.mainForm);
        int n = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        Tree tree = this.toolkit.createTree(this.mainForm.getBody(), 768);
        this.toolkit.setBorderStyle(n);
        this.treeViewer = new DeferredTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setComparator((ViewerComparator)new TreeViewerComparator());
        this.treeViewer.addDoubleClickListener(this.treeViewDoubleClickListener);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.updateFormTitle();
        this.updateFormBody();
        this.updateAgentsCombo();
        RepositoryDefinition repositoryDefinition = (RepositoryDefinition)PreferencesUtils.getObject("LAST_SELECTED_REPOSITORY");
        if (repositoryDefinition != null) {
            this.showRepository(repositoryDefinition, null);
            if (CollectionUtils.isNotEmpty(this.availableAgents)) {
                long l = PreferencesUtils.getLongValue("LAST_SELECTED_AGENT");
                for (PlatformIdent platformIdent : this.availableAgents) {
                    if (platformIdent.getId() != l) continue;
                    this.selectAgentForDisplay(platformIdent);
                    this.performUpdate();
                    break;
                }
            }
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProviderAdapter);
    }

    public void showRepository(final RepositoryDefinition repositoryDefinition, final PlatformIdent platformIdent) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DataExplorerView.this.mainForm.setBusy(true);
                if (DataExplorerView.this.displayedAgent != null && DataExplorerView.this.displayedRepositoryDefinition != null) {
                    DataExplorerView.this.cacheExpandedObjects(DataExplorerView.this.displayedAgent, DataExplorerView.this.displayedRepositoryDefinition);
                }
                DataExplorerView.this.updateFormTitle();
                DataExplorerView.this.agentsCombo.removeAll();
                DataExplorerView.this.displayMessage("Loading agents for repository " + repositoryDefinition.getName(), Display.getDefault().getSystemImage(16));
            }
        });
        this.displayedRepositoryDefinition = repositoryDefinition;
        PreferencesUtils.saveObject("LAST_SELECTED_REPOSITORY", this.displayedRepositoryDefinition, false);
        this.updateAvailableAgents(repositoryDefinition, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                DataExplorerView.this.selectAgentForDisplay(platformIdent);
                StructuredSelection structuredSelection = new StructuredSelection((Object)repositoryDefinition);
                DataExplorerView.this.selectionProviderAdapter.setSelection((ISelection)structuredSelection);
                DataExplorerView.this.performUpdate();
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DataExplorerView.this.mainForm.setBusy(false);
            }
        });
    }

    private void selectAgentForDisplay(PlatformIdent platformIdent) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DataExplorerView.this.mainForm.setBusy(true);
                DataExplorerView.this.displayMessage("Loading agent tree..", Display.getDefault().getSystemImage(16));
            }
        });
        try {
            if (platformIdent != null && CollectionUtils.isNotEmpty(this.availableAgents) && this.availableAgents.contains(platformIdent)) {
                this.displayedAgent = this.displayedRepositoryDefinition.getGlobalDataAccessService().getCompleteAgent(platformIdent.getId().longValue());
                PreferencesUtils.saveLongValue("LAST_SELECTED_AGENT", platformIdent.getId(), false);
            } else if (CollectionUtils.isNotEmpty(this.availableAgents)) {
                platformIdent = this.availableAgents.iterator().next();
                this.displayedAgent = this.displayedRepositoryDefinition.getGlobalDataAccessService().getCompleteAgent(platformIdent.getId().longValue());
            } else {
                this.displayedAgent = null;
            }
        }
        catch (BusinessException businessException) {
            InspectIT.getDefault().createErrorDialog("Exception occurred trying to load the agent tree for the agent " + platformIdent.getAgentName() + ".", businessException, -1);
            this.displayedAgent = null;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DataExplorerView.this.mainForm.setBusy(false);
            }
        });
    }

    private void cacheExpandedObjects(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Object[] objectArray = this.treeViewer.getExpandedElements();
        if (objectArray.length > 0) {
            ArrayList<Object> arrayList;
            HashSet<Object> hashSet = new HashSet<Object>();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                arrayList = objectArray2[n2];
                Object object = ((ITreeContentProvider)this.treeViewer.getContentProvider()).getParent(arrayList);
                while (object != null) {
                    hashSet.add(object);
                    object = ((ITreeContentProvider)this.treeViewer.getContentProvider()).getParent(object);
                }
                ++n2;
            }
            arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            arrayList.removeAll(hashSet);
            this.expandedElementsPerAgent.put(this.getHashCodeForAgentRepository(platformIdent, repositoryDefinition), arrayList);
        } else {
            this.expandedElementsPerAgent.put(this.getHashCodeForAgentRepository(platformIdent, repositoryDefinition), Collections.emptyList());
        }
    }

    private int getHashCodeForAgentRepository(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        return Objects.hashCode((Object[])new Object[]{platformIdent, repositoryDefinition});
    }

    private void updateAvailableAgents(final RepositoryDefinition repositoryDefinition, IJobChangeListener iJobChangeListener) {
        Job job = new Job("Updating Available Agents"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (repositoryDefinition instanceof CmrRepositoryDefinition) {
                    CmrRepositoryDefinition cmrRepositoryDefinition = (CmrRepositoryDefinition)repositoryDefinition;
                    if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                        DataExplorerView.this.availableAgents = new ArrayList(cmrRepositoryDefinition.getGlobalDataAccessService().getAgentsOverview().keySet());
                    } else {
                        DataExplorerView.this.availableAgents = null;
                    }
                } else if (repositoryDefinition instanceof StorageRepositoryDefinition) {
                    StorageRepositoryDefinition storageRepositoryDefinition = (StorageRepositoryDefinition)repositoryDefinition;
                    if (storageRepositoryDefinition.getLocalStorageData().isFullyDownloaded() || storageRepositoryDefinition.getCmrRepositoryDefinition().getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                        DataExplorerView.this.availableAgents = new ArrayList(storageRepositoryDefinition.getGlobalDataAccessService().getAgentsOverview().keySet());
                    } else {
                        DataExplorerView.this.availableAgents = null;
                    }
                } else {
                    DataExplorerView.this.availableAgents = null;
                }
                if (CollectionUtils.isNotEmpty((Collection)DataExplorerView.this.availableAgents)) {
                    Collections.sort(DataExplorerView.this.availableAgents, new Comparator<PlatformIdent>(){

                        @Override
                        public int compare(PlatformIdent platformIdent, PlatformIdent platformIdent2) {
                            return ObjectUtils.compare((Comparable)((Object)platformIdent.getAgentName()), (Object)platformIdent2.getAgentName());
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        if (iJobChangeListener != null) {
            job.addJobChangeListener(iJobChangeListener);
        }
        job.schedule();
    }

    private void createViewToolbar() {
        this.toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        ShowHideInactiveInstrumentationsAction showHideInactiveInstrumentationsAction = new ShowHideInactiveInstrumentationsAction();
        this.toolBarManager.add((IAction)showHideInactiveInstrumentationsAction);
        this.collapseAction = new CollapseAction();
        this.toolBarManager.add((IAction)this.collapseAction);
    }

    private void createHeadClient() {
        Composite composite = new Composite(this.mainForm.getHead(), 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setImage(InspectIT.getDefault().getImage("/icons/eclipse/agent.gif"));
        this.agentsCombo = new Combo(composite, 2060);
        this.agentsCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.agentsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = DataExplorerView.this.agentsCombo.getSelectionIndex();
                if (n < DataExplorerView.this.availableAgents.size()) {
                    PlatformIdent platformIdent = (PlatformIdent)DataExplorerView.this.availableAgents.get(n);
                    if (!ObjectUtils.equals((Object)DataExplorerView.this.displayedAgent, (Object)platformIdent)) {
                        if (DataExplorerView.this.displayedAgent != null && DataExplorerView.this.displayedRepositoryDefinition != null) {
                            DataExplorerView.this.cacheExpandedObjects(DataExplorerView.this.displayedAgent, DataExplorerView.this.displayedRepositoryDefinition);
                        }
                        DataExplorerView.this.selectAgentForDisplay(platformIdent);
                        DataExplorerView.this.performUpdate();
                    }
                }
            }
        });
        this.mainForm.setHeadClient((Control)composite);
    }

    private void updateAgentsCombo() {
        this.agentsCombo.removeAll();
        if (this.availableAgents != null && !this.availableAgents.isEmpty()) {
            this.agentsCombo.setEnabled(true);
            int n = 0;
            int n2 = -1;
            for (PlatformIdent platformIdent : this.availableAgents) {
                this.agentsCombo.add(TextFormatter.getAgentDescription(platformIdent));
                if (ObjectUtils.equals((Object)platformIdent, (Object)this.displayedAgent)) {
                    n2 = n;
                }
                ++n;
            }
            if (-1 != n2) {
                this.agentsCombo.select(n2);
            }
        } else {
            this.agentsCombo.setEnabled(false);
        }
        this.mainForm.getHead().layout();
    }

    private void updateFormTitle() {
        if (this.displayedRepositoryDefinition != null) {
            if (this.displayedRepositoryDefinition instanceof CmrRepositoryDefinition) {
                CmrRepositoryDefinition cmrRepositoryDefinition = (CmrRepositoryDefinition)this.displayedRepositoryDefinition;
                this.mainForm.setImage(ImageFormatter.getCmrRepositoryImage(cmrRepositoryDefinition, true));
                this.mainForm.setText(cmrRepositoryDefinition.getName());
                this.mainForm.setToolTipText(TextFormatter.getCmrRepositoryDescription(cmrRepositoryDefinition));
            } else if (this.displayedRepositoryDefinition instanceof StorageRepositoryDefinition) {
                StorageRepositoryDefinition storageRepositoryDefinition = (StorageRepositoryDefinition)this.displayedRepositoryDefinition;
                this.mainForm.setImage(ImageFormatter.getStorageRepositoryImage(storageRepositoryDefinition));
                this.mainForm.setText(storageRepositoryDefinition.getName());
                this.mainForm.setToolTipText(this.getStorageDescirption(storageRepositoryDefinition));
            }
            this.mainForm.setMessage(null);
        } else {
            this.mainForm.setImage(null);
            this.mainForm.setText("No repository loaded");
            this.mainForm.setMessage("Repositories can be loaded from Repository or Storage Manager", 2);
            this.mainForm.setToolTipText(null);
        }
    }

    private void updateFormBody() {
        this.clearFormBody();
        if (this.displayedRepositoryDefinition != null && this.displayedAgent != null) {
            TreeModelManager treeModelManager = null;
            treeModelManager = new TreeModelManager(this.displayedRepositoryDefinition, this.displayedAgent, this.hideInactiveInstrumentations);
            if (treeModelManager != null && this.displayedAgent != null) {
                this.treeViewer.setInput(treeModelManager);
                this.treeViewer.getTree().setVisible(true);
                this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
            } else {
                this.displayMessage("Repository is currently unavailable.", Display.getDefault().getSystemImage(1));
            }
        } else if (this.displayedRepositoryDefinition != null && this.displayedAgent == null) {
            if (this.availableAgents == null) {
                this.displayMessage("No agent could be loaded on selected repository.", Display.getDefault().getSystemImage(8));
            } else {
                this.displayMessage("This repository is empty.", Display.getDefault().getSystemImage(2));
            }
        }
        this.mainForm.getBody().layout();
    }

    private void updateViewToolbar() {
        this.collapseAction.updateEnabledState();
        this.toolBarManager.find(REFRESH_CONTRIBUTION_ITEM).setVisible(this.displayedRepositoryDefinition instanceof CmrRepositoryDefinition);
        this.toolBarManager.find(CLEAR_BUFFER_CONTRIBUTION_ITEM).setVisible(this.displayedRepositoryDefinition instanceof CmrRepositoryDefinition && !CmrRepositoryDefinition.OnlineStatus.OFFLINE.equals((Object)((CmrRepositoryDefinition)this.displayedRepositoryDefinition).getOnlineStatus()));
        this.toolBarManager.update(true);
    }

    private void clearFormBody() {
        if (this.messageComposite != null && !this.messageComposite.isDisposed()) {
            this.messageComposite.dispose();
        }
        this.treeViewer.setInput(null);
        this.treeViewer.getTree().setVisible(false);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(16384, 128, false, false));
    }

    public void performUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                List list;
                DataExplorerView.this.mainForm.setBusy(true);
                DataExplorerView.this.updateFormTitle();
                DataExplorerView.this.updateFormBody();
                DataExplorerView.this.updateAgentsCombo();
                DataExplorerView.this.updateViewToolbar();
                if (DataExplorerView.this.displayedAgent != null && (list = (List)DataExplorerView.this.expandedElementsPerAgent.get(DataExplorerView.this.getHashCodeForAgentRepository(DataExplorerView.this.displayedAgent, DataExplorerView.this.displayedRepositoryDefinition))) != null) {
                    for (Object e : list) {
                        DataExplorerView.this.treeViewer.expandObject(e, 1);
                    }
                }
                DataExplorerView.this.mainForm.setBusy(false);
            }
        });
    }

    public void setFocus() {
        if (this.treeViewer.getTree().isVisible()) {
            this.treeViewer.getTree().setFocus();
        } else {
            this.mainForm.setFocus();
        }
    }

    @Override
    public void refresh() {
        if (this.displayedRepositoryDefinition instanceof CmrRepositoryDefinition) {
            if (this.displayedAgent != null) {
                this.cacheExpandedObjects(this.displayedAgent, this.displayedRepositoryDefinition);
            }
            final CmrRepositoryManager.UpdateRepositoryJob updateRepositoryJob = InspectIT.getDefault().getCmrRepositoryManager().forceCmrRepositoryOnlineStatusUpdate((CmrRepositoryDefinition)this.displayedRepositoryDefinition);
            updateRepositoryJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    DataExplorerView.this.updateAvailableAgents(DataExplorerView.this.displayedRepositoryDefinition, (IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent iJobChangeEvent) {
                            if (DataExplorerView.this.availableAgents != null && !DataExplorerView.this.availableAgents.isEmpty() && DataExplorerView.this.displayedAgent != null) {
                                boolean bl = false;
                                for (PlatformIdent platformIdent : DataExplorerView.this.availableAgents) {
                                    if (platformIdent.getId().longValue() != DataExplorerView.this.displayedAgent.getId().longValue()) continue;
                                    DataExplorerView.this.selectAgentForDisplay(platformIdent);
                                    bl = true;
                                    break;
                                }
                                if (!bl) {
                                    DataExplorerView.this.selectAgentForDisplay((PlatformIdent)DataExplorerView.this.availableAgents.get(0));
                                }
                            } else if (DataExplorerView.this.availableAgents != null && !DataExplorerView.this.availableAgents.isEmpty() && DataExplorerView.this.displayedAgent == null) {
                                DataExplorerView.this.selectAgentForDisplay((PlatformIdent)DataExplorerView.this.availableAgents.get(0));
                            } else {
                                DataExplorerView.this.selectAgentForDisplay(null);
                            }
                            DataExplorerView.this.performUpdate();
                        }
                    });
                    updateRepositoryJob.removeJobChangeListener((IJobChangeListener)this);
                }
            });
        }
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    @Override
    public void repositoryOnlineStatusUpdated(CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
        if (onlineStatus2 != CmrRepositoryDefinition.OnlineStatus.CHECKING) {
            boolean bl = ObjectUtils.equals((Object)this.displayedRepositoryDefinition, (Object)cmrRepositoryDefinition);
            if (this.displayedRepositoryDefinition instanceof StorageRepositoryDefinition) {
                bl |= ObjectUtils.equals((Object)((StorageRepositoryDefinition)this.displayedRepositoryDefinition).getCmrRepositoryDefinition(), (Object)cmrRepositoryDefinition);
            }
            if (bl) {
                CmrRepositoryDefinition.OnlineStatus onlineStatus3 = this.cachedOnlineStatus.get(cmrRepositoryDefinition);
                if (onlineStatus3 == CmrRepositoryDefinition.OnlineStatus.OFFLINE && onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                    this.updateAvailableAgents(this.displayedRepositoryDefinition, (IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent iJobChangeEvent) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DataExplorerView.this.mainForm.setBusy(true);
                                    DataExplorerView.this.updateFormTitle();
                                    DataExplorerView.this.updateFormBody();
                                    DataExplorerView.this.updateAgentsCombo();
                                    DataExplorerView.this.updateViewToolbar();
                                    DataExplorerView.this.mainForm.setBusy(false);
                                }
                            });
                        }
                    });
                } else if (onlineStatus3 == CmrRepositoryDefinition.OnlineStatus.ONLINE && onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DataExplorerView.this.mainForm.setBusy(true);
                            DataExplorerView.this.updateFormTitle();
                            DataExplorerView.this.updateAgentsCombo();
                            DataExplorerView.this.updateViewToolbar();
                            DataExplorerView.this.mainForm.setBusy(false);
                        }
                    });
                }
            }
            this.cachedOnlineStatus.put(cmrRepositoryDefinition, onlineStatus2);
        }
    }

    @Override
    public void repositoryDataUpdated(CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)this.displayedRepositoryDefinition)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorerView.this.mainForm.setBusy(true);
                    DataExplorerView.this.updateFormTitle();
                    DataExplorerView.this.mainForm.setBusy(false);
                }
            });
        }
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void repositoryRemoved(CmrRepositoryDefinition cmrRepositoryDefinition) {
        StorageRepositoryDefinition storageRepositoryDefinition;
        if (ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)this.displayedRepositoryDefinition)) {
            this.displayedRepositoryDefinition = null;
            this.displayedAgent = null;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorerView.this.performUpdate();
                }
            });
        } else if (this.displayedRepositoryDefinition instanceof StorageRepositoryDefinition && ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)(storageRepositoryDefinition = (StorageRepositoryDefinition)this.displayedRepositoryDefinition).getCmrRepositoryDefinition()) && !storageRepositoryDefinition.getLocalStorageData().isFullyDownloaded()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorerView.this.agentsCombo.removeAll();
                    DataExplorerView.this.agentsCombo.setEnabled(false);
                    DataExplorerView.this.displayMessage("CMR Repository for selected storage was removed.", Display.getDefault().getSystemImage(8));
                }
            });
        }
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
        if (ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)this.displayedRepositoryDefinition)) {
            this.availableAgents.remove(platformIdent);
            if (ObjectUtils.equals((Object)platformIdent, (Object)this.displayedAgent)) {
                this.selectAgentForDisplay(null);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorerView.this.performUpdate();
                }
            });
        }
    }

    @Override
    public void storageDataUpdated(IStorageData iStorageData) {
        if (this.displayedRepositoryDefinition instanceof StorageRepositoryDefinition) {
            StorageRepositoryDefinition storageRepositoryDefinition = (StorageRepositoryDefinition)this.displayedRepositoryDefinition;
            if (ObjectUtils.equals((Object)iStorageData.getId(), (Object)storageRepositoryDefinition.getLocalStorageData().getId())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorerView.this.updateFormTitle();
                    }
                });
            }
        }
    }

    @Override
    public void storageRemotelyDeleted(IStorageData iStorageData) {
        StorageRepositoryDefinition storageRepositoryDefinition;
        if (this.displayedRepositoryDefinition instanceof StorageRepositoryDefinition && !(storageRepositoryDefinition = (StorageRepositoryDefinition)this.displayedRepositoryDefinition).getLocalStorageData().isFullyDownloaded() && ObjectUtils.equals((Object)iStorageData.getId(), (Object)storageRepositoryDefinition.getLocalStorageData().getId())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorerView.this.agentsCombo.removeAll();
                    DataExplorerView.this.agentsCombo.setEnabled(false);
                    DataExplorerView.this.displayMessage("Selected storage was remotely deleted and is not available anymore.", Display.getDefault().getSystemImage(8));
                }
            });
        }
    }

    @Override
    public void storageLocallyDeleted(IStorageData iStorageData) {
        if (this.displayedRepositoryDefinition instanceof StorageRepositoryDefinition) {
            StorageRepositoryDefinition storageRepositoryDefinition = (StorageRepositoryDefinition)this.displayedRepositoryDefinition;
            if (ObjectUtils.equals((Object)iStorageData.getId(), (Object)storageRepositoryDefinition.getLocalStorageData().getId())) {
                if (InspectIT.getDefault().getInspectITStorageManager().getMountedAvailableStorages().contains(iStorageData)) {
                    this.performUpdate();
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DataExplorerView.this.agentsCombo.removeAll();
                            DataExplorerView.this.agentsCombo.setEnabled(false);
                            DataExplorerView.this.displayMessage("Selected storage was locally deleted and is not available anymore.", Display.getDefault().getSystemImage(8));
                        }
                    });
                }
            }
        }
    }

    public void dispose() {
        InspectIT.getDefault().getCmrRepositoryManager().removeCmrRepositoryChangeListener(this);
        InspectIT.getDefault().getInspectITStorageManager().removeStorageChangeListener(this);
        super.dispose();
    }

    private void displayMessage(String string, Image image) {
        this.clearFormBody();
        if (this.messageComposite == null || this.messageComposite.isDisposed()) {
            this.messageComposite = this.toolkit.createComposite(this.mainForm.getBody());
        } else {
            Control[] controlArray = this.messageComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++n2;
            }
        }
        this.messageComposite.setLayout((Layout)new GridLayout(2, false));
        this.messageComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.toolkit.createLabel(this.messageComposite, null).setImage(image);
        this.toolkit.createLabel(this.messageComposite, string, 64).setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.mainForm.getBody().layout();
    }

    private String getStorageDescirption(StorageRepositoryDefinition storageRepositoryDefinition) {
        LocalStorageData localStorageData = storageRepositoryDefinition.getLocalStorageData();
        if (localStorageData.isFullyDownloaded()) {
            return "Storage Repository - Accessible offline";
        }
        return "Storage Repository - Accessible via CMR repository";
    }

    private class CollapseAction
    extends Action {
        public CollapseAction() {
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/collapseall.gif"));
            this.setToolTipText("Collapse All");
            this.updateEnabledState();
        }

        public final void updateEnabledState() {
            if (DataExplorerView.this.treeViewer != null && DataExplorerView.this.treeViewer.getInput() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            DataExplorerView.this.treeViewer.setExpandedElements(new Object[0]);
            DataExplorerView.this.treeViewer.refresh();
        }
    }

    private class ShowHideInactiveInstrumentationsAction
    extends Action {
        public ShowHideInactiveInstrumentationsAction() {
            super(null, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/fugue/document-tree.png"));
            this.setChecked(!DataExplorerView.this.hideInactiveInstrumentations);
            this.updateToolTipText();
        }

        public void run() {
            DataExplorerView.this.hideInactiveInstrumentations = !this.isChecked();
            this.updateToolTipText();
            if (DataExplorerView.this.displayedAgent != null && DataExplorerView.this.displayedRepositoryDefinition != null) {
                DataExplorerView.this.cacheExpandedObjects(DataExplorerView.this.displayedAgent, DataExplorerView.this.displayedRepositoryDefinition);
            }
            DataExplorerView.this.performUpdate();
        }

        private void updateToolTipText() {
            if (!this.isChecked()) {
                this.setToolTipText("Show inactive instrumentations");
            } else {
                this.setToolTipText("Hide inactive instrumentations");
            }
        }
    }
}

