/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.validation.validator;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;

public class FqnWildcardValidator
implements IInputValidator {
    private static final String MESSAGE_VALUE_EMPTY = "Specified value must not be empty.";
    private static final String MESSAGE_ERROR_NO_PRIMITIVES = "Specified value is not valid because it will match no class";
    private static final String MESSAGE_ERROR_PRIMITIVES = "Specified value is not valid because it will match no class nor primitive type.";
    private static final Pattern PATTERN = Pattern.compile("([a-zA-Z_$\\*][a-zA-Z\\d_$\\*]*\\.)*[a-zA-Z_$\\*][a-zA-Z\\d_$\\*]*");
    private final boolean allowEmpty;
    private final boolean allowPrimitives;

    public FqnWildcardValidator(boolean bl, boolean bl2) {
        this.allowEmpty = bl;
        this.allowPrimitives = bl2;
    }

    public String isValid(String string) {
        if (StringUtils.isEmpty((String)string)) {
            if (!this.allowEmpty) {
                return MESSAGE_VALUE_EMPTY;
            }
            if (this.allowEmpty) {
                return null;
            }
        }
        if (PATTERN.matcher(string).matches()) {
            return null;
        }
        if (this.allowPrimitives) {
            return MESSAGE_ERROR_PRIMITIVES;
        }
        return MESSAGE_ERROR_NO_PRIMITIVES;
    }
}

