/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.util;

import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.AggregatedTimerData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.util.ElementOccurrenceCount;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.eclipse.jface.viewers.ViewerFilter;

public final class OccurrenceFinderFactory {
    private static final String TEMPLATE_STRING = "TEMPLATE_STRING";
    private static final Map<Object, Object> TEMPLATE_MAP = new HashMap<Object, Object>(0);
    private static final List<String> TEMPLATE_LIST = new ArrayList<String>(0);
    private static final Set<Object> TEMPLATE_SET = new HashSet<Object>(0);
    private static TimerOccurrenceFinder timerOccurrenceFinder = new TimerOccurrenceFinder();
    private static SqlOccurrenceFinder sqlOccurrenceFinder = new SqlOccurrenceFinder();
    private static ExceptionOccurrenceFinder exceptionOccurrenceFinder = new ExceptionOccurrenceFinder();
    private static InvocationOccurenceFinder invocationOccurenceFinder = new InvocationOccurenceFinder();

    private OccurrenceFinderFactory() {
    }

    public static ElementOccurrenceCount getOccurrenceCount(InvocationSequenceData invocationSequenceData, Object object, ViewerFilter[] viewerFilterArray) {
        OccurrenceFinder occurrenceFinder = OccurrenceFinderFactory.getOccurrenceFinder(object);
        return occurrenceFinder.getOccurrenceCount(invocationSequenceData, object, viewerFilterArray, null);
    }

    public static InvocationSequenceData getOccurrence(InvocationSequenceData invocationSequenceData, Object object, int n, ViewerFilter[] viewerFilterArray) {
        OccurrenceFinder occurrenceFinder = OccurrenceFinderFactory.getOccurrenceFinder(object);
        return occurrenceFinder.getOccurrence(invocationSequenceData, object, new MutableInt(n), viewerFilterArray);
    }

    public static <E> E getEmptyTemplate(E e) {
        OccurrenceFinder occurrenceFinder = OccurrenceFinderFactory.getOccurrenceFinder(e);
        return occurrenceFinder.getEmptyTemplate();
    }

    private static OccurrenceFinder getOccurrenceFinder(Object object) {
        if (SqlStatementData.class.isAssignableFrom(object.getClass())) {
            return sqlOccurrenceFinder;
        }
        if (object.getClass().equals(TimerData.class) || object.getClass().equals(AggregatedTimerData.class)) {
            return timerOccurrenceFinder;
        }
        if (ExceptionSensorData.class.isAssignableFrom(object.getClass())) {
            return exceptionOccurrenceFinder;
        }
        if (InvocationSequenceData.class.isAssignableFrom(object.getClass())) {
            return invocationOccurenceFinder;
        }
        RuntimeException runtimeException = new RuntimeException("Occurrence finder factory was not able to supply the correct occurrence finder for the object of class " + object.getClass().getName() + ".");
        InspectIT.getDefault().createErrorDialog("Exception thrown during locating of stepping object.", runtimeException, -1);
        throw runtimeException;
    }

    private static class ExceptionOccurrenceFinder
    extends OccurrenceFinder<ExceptionSensorData> {
        private ExceptionOccurrenceFinder() {
        }

        @Override
        public boolean occurrenceFound(InvocationSequenceData invocationSequenceData, ExceptionSensorData exceptionSensorData) {
            Iterator iterator;
            if (invocationSequenceData.getExceptionSensorDataObjects() != null && (iterator = invocationSequenceData.getExceptionSensorDataObjects().iterator()).hasNext()) {
                ExceptionSensorData exceptionSensorData2 = (ExceptionSensorData)iterator.next();
                return this.doesTemplateEqualsElement(exceptionSensorData, exceptionSensorData2);
            }
            return false;
        }

        @Override
        public Class<ExceptionSensorData> getConcreteClass() {
            return ExceptionSensorData.class;
        }

        @Override
        public boolean doesTemplateEqualsElement(ExceptionSensorData exceptionSensorData, ExceptionSensorData exceptionSensorData2) {
            if (0L != exceptionSensorData.getId() && exceptionSensorData.getId() != exceptionSensorData2.getId()) {
                return false;
            }
            if (OccurrenceFinderFactory.TEMPLATE_STRING != exceptionSensorData.getCause() && !ObjectUtils.equals((Object)exceptionSensorData.getCause(), (Object)exceptionSensorData2.getCause())) {
                return false;
            }
            if (OccurrenceFinderFactory.TEMPLATE_STRING != exceptionSensorData.getErrorMessage() && !ObjectUtils.equals((Object)exceptionSensorData.getErrorMessage(), (Object)exceptionSensorData2.getErrorMessage())) {
                return false;
            }
            if (OccurrenceFinderFactory.TEMPLATE_STRING != exceptionSensorData.getStackTrace() && !StringUtils.contains((String)exceptionSensorData2.getStackTrace(), (String)exceptionSensorData.getStackTrace())) {
                return false;
            }
            if (OccurrenceFinderFactory.TEMPLATE_STRING != exceptionSensorData.getThrowableType() && !ObjectUtils.equals((Object)exceptionSensorData.getThrowableType(), (Object)exceptionSensorData2.getThrowableType())) {
                return false;
            }
            if (0L != exceptionSensorData.getThrowableIdentityHashCode() && exceptionSensorData.getThrowableIdentityHashCode() != exceptionSensorData2.getThrowableIdentityHashCode()) {
                return false;
            }
            return exceptionSensorData.getExceptionEvent() == null || ObjectUtils.equals((Object)exceptionSensorData.getExceptionEvent(), (Object)exceptionSensorData2.getExceptionEvent());
        }

        @Override
        public ExceptionSensorData getEmptyTemplate() {
            ExceptionSensorData exceptionSensorData = new ExceptionSensorData();
            exceptionSensorData.setCause(OccurrenceFinderFactory.TEMPLATE_STRING);
            exceptionSensorData.setErrorMessage(OccurrenceFinderFactory.TEMPLATE_STRING);
            exceptionSensorData.setStackTrace(OccurrenceFinderFactory.TEMPLATE_STRING);
            exceptionSensorData.setThrowableType(OccurrenceFinderFactory.TEMPLATE_STRING);
            exceptionSensorData.setThrowableIdentityHashCode(0L);
            exceptionSensorData.setExceptionEvent(null);
            return exceptionSensorData;
        }
    }

    private static class InvocationOccurenceFinder
    extends OccurrenceFinder<InvocationSequenceData> {
        private InvocationOccurenceFinder() {
        }

        @Override
        public InvocationSequenceData getEmptyTemplate() {
            InvocationSequenceData invocationSequenceData = new InvocationSequenceData();
            invocationSequenceData.setMethodIdent(0L);
            return invocationSequenceData;
        }

        @Override
        public boolean occurrenceFound(InvocationSequenceData invocationSequenceData, InvocationSequenceData invocationSequenceData2) {
            return this.doesTemplateEqualsElement(invocationSequenceData2, invocationSequenceData);
        }

        @Override
        public boolean doesTemplateEqualsElement(InvocationSequenceData invocationSequenceData, InvocationSequenceData invocationSequenceData2) {
            if (0L != invocationSequenceData.getId() && invocationSequenceData.getId() != invocationSequenceData2.getId()) {
                return false;
            }
            return 0L == invocationSequenceData.getMethodIdent() || invocationSequenceData.getMethodIdent() == invocationSequenceData2.getMethodIdent();
        }

        @Override
        public Class<? extends InvocationSequenceData> getConcreteClass() {
            return InvocationSequenceData.class;
        }
    }

    private static abstract class OccurrenceFinder<E> {
        private OccurrenceFinder() {
        }

        public ElementOccurrenceCount getOccurrenceCount(InvocationSequenceData invocationSequenceData, E e, ViewerFilter[] viewerFilterArray, ElementOccurrenceCount elementOccurrenceCount) {
            if (!this.getConcreteClass().isAssignableFrom(e.getClass())) {
                return null;
            }
            ElementOccurrenceCount elementOccurrenceCount2 = elementOccurrenceCount == null ? new ElementOccurrenceCount() : elementOccurrenceCount;
            boolean bl = this.occurrenceFound(invocationSequenceData, e);
            if (bl && this.filtersPassed(invocationSequenceData, viewerFilterArray)) {
                elementOccurrenceCount2.increaseVisibleOccurrences();
            } else if (bl) {
                elementOccurrenceCount2.increaseFilteredOccurrences();
            }
            if (invocationSequenceData.getNestedSequences() != null) {
                for (InvocationSequenceData invocationSequenceData2 : invocationSequenceData.getNestedSequences()) {
                    this.getOccurrenceCount(invocationSequenceData2, e, viewerFilterArray, elementOccurrenceCount2);
                }
            }
            return elementOccurrenceCount2;
        }

        public abstract E getEmptyTemplate();

        public InvocationSequenceData getOccurrence(InvocationSequenceData invocationSequenceData, E e, MutableInt mutableInt, ViewerFilter[] viewerFilterArray) {
            if (!this.getConcreteClass().isAssignableFrom(e.getClass())) {
                return null;
            }
            if (this.occurrenceFound(invocationSequenceData, e) && this.filtersPassed(invocationSequenceData, viewerFilterArray)) {
                mutableInt.decrement();
                if (mutableInt.intValue() == 0) {
                    return invocationSequenceData;
                }
            }
            if (invocationSequenceData.getNestedSequences() != null) {
                for (InvocationSequenceData invocationSequenceData2 : invocationSequenceData.getNestedSequences()) {
                    InvocationSequenceData invocationSequenceData3 = this.getOccurrence(invocationSequenceData2, e, mutableInt, viewerFilterArray);
                    if (invocationSequenceData3 == null) continue;
                    return invocationSequenceData3;
                }
            }
            return null;
        }

        public abstract boolean occurrenceFound(InvocationSequenceData var1, E var2);

        public abstract boolean doesTemplateEqualsElement(E var1, E var2);

        public abstract Class<? extends E> getConcreteClass();

        private boolean filtersPassed(InvocationSequenceData invocationSequenceData, ViewerFilter[] viewerFilterArray) {
            boolean bl = true;
            if (viewerFilterArray != null) {
                ViewerFilter[] viewerFilterArray2 = viewerFilterArray;
                int n = viewerFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter viewerFilter = viewerFilterArray2[n2];
                    if (!viewerFilter.select(null, (Object)invocationSequenceData.getParentSequence(), (Object)invocationSequenceData)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
            return bl;
        }
    }

    private static class SqlOccurrenceFinder
    extends OccurrenceFinder<SqlStatementData> {
        private SqlOccurrenceFinder() {
        }

        @Override
        public boolean occurrenceFound(InvocationSequenceData invocationSequenceData, SqlStatementData sqlStatementData) {
            if (invocationSequenceData.getSqlStatementData() != null) {
                return this.doesTemplateEqualsElement(sqlStatementData, invocationSequenceData.getSqlStatementData());
            }
            return false;
        }

        @Override
        public Class<SqlStatementData> getConcreteClass() {
            return SqlStatementData.class;
        }

        @Override
        public boolean doesTemplateEqualsElement(SqlStatementData sqlStatementData, SqlStatementData sqlStatementData2) {
            if (0L != sqlStatementData.getId() && sqlStatementData.getId() != sqlStatementData2.getId()) {
                return false;
            }
            if (OccurrenceFinderFactory.TEMPLATE_STRING != sqlStatementData.getSql() && !ObjectUtils.equals((Object)sqlStatementData.getSql(), (Object)sqlStatementData2.getSql())) {
                return false;
            }
            if (TEMPLATE_LIST != sqlStatementData.getParameterValues() && !ObjectUtils.equals((Object)sqlStatementData.getParameterValues(), (Object)sqlStatementData2.getParameterValues())) {
                return false;
            }
            return 0L == sqlStatementData.getMethodIdent() || sqlStatementData.getMethodIdent() == sqlStatementData2.getMethodIdent();
        }

        @Override
        public SqlStatementData getEmptyTemplate() {
            SqlStatementData sqlStatementData = new SqlStatementData();
            sqlStatementData.setSql(OccurrenceFinderFactory.TEMPLATE_STRING);
            sqlStatementData.setParameterValues(TEMPLATE_LIST);
            sqlStatementData.setMethodIdent(0L);
            return sqlStatementData;
        }
    }

    private static class TimerOccurrenceFinder
    extends OccurrenceFinder<MethodSensorData> {
        private TimerOccurrenceFinder() {
        }

        @Override
        public boolean occurrenceFound(InvocationSequenceData invocationSequenceData, MethodSensorData methodSensorData) {
            if (invocationSequenceData.getTimerData() != null) {
                return this.doesTemplateEqualsElement(methodSensorData, (MethodSensorData)invocationSequenceData.getTimerData());
            }
            return this.doesTemplateEqualsElement(methodSensorData, (MethodSensorData)invocationSequenceData);
        }

        @Override
        public Class<TimerData> getConcreteClass() {
            return TimerData.class;
        }

        @Override
        public boolean doesTemplateEqualsElement(MethodSensorData methodSensorData, MethodSensorData methodSensorData2) {
            if (0L != methodSensorData.getId() && methodSensorData.getId() != methodSensorData2.getId()) {
                return false;
            }
            return 0L == methodSensorData.getMethodIdent() || methodSensorData.getMethodIdent() == methodSensorData2.getMethodIdent();
        }

        @Override
        public MethodSensorData getEmptyTemplate() {
            TimerData timerData = new TimerData();
            timerData.setMethodIdent(0L);
            return timerData;
        }
    }
}

