/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.storage.label.edit;

import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.label.composite.AbstractStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.BooleanStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.DateStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.NumberStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.StringStorageLabelComposite;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.BooleanStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class LabelValueEditingSupport
extends EditingSupport {
    private StorageData storageData;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private ComboBoxCellEditor generalCellEditor;
    private ComboBoxCellEditor booleanCellEditor;
    private Table table;
    private List<AbstractStorageLabel<?>> suggestionLabelList = new ArrayList();
    private AbstractStorageLabel<?> editingLabel;
    private List<LabelEditListener> labelEditListeners = new ArrayList<LabelEditListener>();

    public LabelValueEditingSupport(TableViewer tableViewer, StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition) {
        super((ColumnViewer)tableViewer);
        this.storageData = storageData;
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.table = tableViewer.getTable();
        this.generalCellEditor = new ComboBoxCellEditor((Composite)this.table, new String[0], 8);
        this.booleanCellEditor = new ComboBoxCellEditor((Composite)this.table, new String[]{"Yes", "No"}, 8);
        int n = 15;
        this.generalCellEditor.setActivationStyle(n);
        this.booleanCellEditor.setActivationStyle(n);
    }

    protected CellEditor getCellEditor(Object object) {
        AbstractStorageLabel abstractStorageLabel = (AbstractStorageLabel)object;
        if (abstractStorageLabel instanceof BooleanStorageLabel) {
            return this.booleanCellEditor;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("[create new value]");
        if (!Objects.equals(abstractStorageLabel, this.editingLabel) && abstractStorageLabel.getStorageLabelType().isValueReusable() && this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            this.suggestionLabelList.clear();
            this.suggestionLabelList.addAll(this.cmrRepositoryDefinition.getStorageService().getLabelSuggestions(abstractStorageLabel.getStorageLabelType()));
            if (!this.suggestionLabelList.isEmpty() && this.storageData != null) {
                this.suggestionLabelList.removeAll(this.storageData.getLabelList());
            }
        }
        if (!this.suggestionLabelList.isEmpty()) {
            Collections.sort(this.suggestionLabelList);
            for (AbstractStorageLabel<?> abstractStorageLabel2 : this.suggestionLabelList) {
                arrayList.add(TextFormatter.getLabelValue(abstractStorageLabel2, false));
            }
        }
        this.generalCellEditor.setItems(arrayList.toArray(new String[arrayList.size()]));
        return this.generalCellEditor;
    }

    protected boolean canEdit(Object object) {
        AbstractStorageLabel abstractStorageLabel = (AbstractStorageLabel)object;
        return abstractStorageLabel.getStorageLabelType().isEditable();
    }

    protected Object getValue(Object object) {
        AbstractStorageLabel abstractStorageLabel;
        this.editingLabel = abstractStorageLabel = (AbstractStorageLabel)object;
        if (abstractStorageLabel.getValue() != null) {
            if (abstractStorageLabel instanceof BooleanStorageLabel) {
                if (((BooleanStorageLabel)abstractStorageLabel).getValue().booleanValue()) {
                    return 0;
                }
                return 1;
            }
            String string = TextFormatter.getLabelValue(abstractStorageLabel, false);
            int n = 1;
            for (AbstractStorageLabel<?> abstractStorageLabel2 : this.suggestionLabelList) {
                if (Objects.equals(string, TextFormatter.getLabelValue(abstractStorageLabel2, false))) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    protected void setValue(Object object, Object object2) {
        int n = (Integer)object2;
        if (n >= 0) {
            AbstractStorageLabel abstractStorageLabel = (AbstractStorageLabel)object;
            if (abstractStorageLabel.getStorageLabelType().getValueClass().equals(Boolean.class)) {
                Boolean bl = n == 0;
                this.changeValue((AbstractStorageLabel<Object>)abstractStorageLabel, bl);
            } else if (n == 0) {
                CreateValueDialog createValueDialog = new CreateValueDialog(this.table.getShell(), abstractStorageLabel.getStorageLabelType());
                createValueDialog.open();
                if (createValueDialog.getReturnCode() == 0) {
                    AbstractStorageLabel<?> abstractStorageLabel2 = createValueDialog.getCreatedLabel();
                    this.changeValue((AbstractStorageLabel<Object>)abstractStorageLabel, abstractStorageLabel2.getValue());
                    if (!this.suggestionLabelList.contains(abstractStorageLabel2)) {
                        this.suggestionLabelList.add(abstractStorageLabel2);
                    }
                }
            } else if (n > 0) {
                AbstractStorageLabel<?> abstractStorageLabel3 = this.suggestionLabelList.get(n - 1);
                Object object3 = abstractStorageLabel3.getValue();
                this.changeValue((AbstractStorageLabel<Object>)abstractStorageLabel, object3);
            }
            this.getViewer().refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeValue(AbstractStorageLabel<Object> abstractStorageLabel, Object object) {
        if (!Objects.equals(abstractStorageLabel.getValue(), object)) {
            List<LabelEditListener> list = this.labelEditListeners;
            synchronized (list) {
                for (LabelEditListener labelEditListener : this.labelEditListeners) {
                    labelEditListener.preLabelValueChange(abstractStorageLabel);
                }
            }
            abstractStorageLabel.setValue(object);
            list = this.labelEditListeners;
            synchronized (list) {
                for (LabelEditListener labelEditListener : this.labelEditListeners) {
                    labelEditListener.postLabelValueChange(abstractStorageLabel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabelEditListener(LabelEditListener labelEditListener) {
        List<LabelEditListener> list = this.labelEditListeners;
        synchronized (list) {
            if (!this.labelEditListeners.contains(labelEditListener)) {
                this.labelEditListeners.add(labelEditListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLabelEditListener(LabelEditListener labelEditListener) {
        List<LabelEditListener> list = this.labelEditListeners;
        synchronized (list) {
            this.labelEditListeners.remove(labelEditListener);
        }
    }

    private static class CreateValueDialog
    extends Dialog {
        private AbstractStorageLabelType<?> labelType;
        private AbstractStorageLabel<?> label;
        private AbstractStorageLabelComposite storageLabelComposite;
        private Button okButton;

        protected CreateValueDialog(Shell shell, AbstractStorageLabelType<?> abstractStorageLabelType) {
            super(shell);
            this.labelType = abstractStorageLabelType;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Create New Label Value");
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, true);
            this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(this.storageLabelComposite.isInputValid());
        }

        protected Control createDialogArea(Composite composite) {
            if (this.labelType.getValueClass().equals(Boolean.class)) {
                this.storageLabelComposite = new BooleanStorageLabelComposite(composite, 0, this.labelType);
            } else if (this.labelType.getValueClass().equals(Date.class)) {
                this.storageLabelComposite = new DateStorageLabelComposite(composite, 0, this.labelType);
            } else if (this.labelType.getValueClass().equals(Number.class)) {
                this.storageLabelComposite = new NumberStorageLabelComposite(composite, 0, this.labelType);
            } else if (this.labelType.getValueClass().equals(String.class)) {
                this.storageLabelComposite = new StringStorageLabelComposite(composite, 0, this.labelType);
            }
            GridData gridData = new GridData(4, 4, true, false);
            gridData.minimumWidth = 300;
            this.storageLabelComposite.setLayoutData(gridData);
            this.storageLabelComposite.addListener(new Listener(){

                public void handleEvent(Event event) {
                    CreateValueDialog.this.okButton.setEnabled(CreateValueDialog.this.storageLabelComposite.isInputValid());
                }
            });
            return this.storageLabelComposite;
        }

        protected void buttonPressed(int n) {
            if (n == 0) {
                this.label = this.storageLabelComposite.getStorageLabel();
            }
            super.buttonPressed(n);
        }

        public AbstractStorageLabel<?> getCreatedLabel() {
            return this.label;
        }
    }

    public static interface LabelEditListener {
        public void preLabelValueChange(AbstractStorageLabel<?> var1);

        public void postLabelValueChange(AbstractStorageLabel<?> var1);
    }
}

