/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.storage;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.AggregationPerformer;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.util.DataRetriever;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageManager;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractStorageService<E extends DefaultData> {
    private static final int MAX_QUERY_SIZE = 0xA00000;
    private StorageRepositoryDefinition storageRepositoryDefinition;
    private LocalStorageData localStorageData;
    private DataRetriever dataRetriever;
    private StorageManager storageManager;

    protected abstract IStorageTreeComponent<E> getIndexingTree();

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery) {
        return this.executeQuery(storageIndexQuery, null, null, -1);
    }

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery, IAggregator<E> iAggregator) {
        return this.executeQuery(storageIndexQuery, iAggregator, null, -1);
    }

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery, Comparator<? super E> comparator) {
        return this.executeQuery(storageIndexQuery, null, comparator, -1);
    }

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery, int n) {
        return this.executeQuery(storageIndexQuery, null, null, n);
    }

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery, IAggregator<E> iAggregator, Comparator<? super E> comparator) {
        return this.executeQuery(storageIndexQuery, iAggregator, comparator, -1);
    }

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery, IAggregator<E> iAggregator, int n) {
        return this.executeQuery(storageIndexQuery, iAggregator, null, n);
    }

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery, Comparator<? super E> comparator, int n) {
        return this.executeQuery(storageIndexQuery, null, comparator, n);
    }

    protected List<E> executeQuery(StorageIndexQuery storageIndexQuery, IAggregator<E> iAggregator, Comparator<? super E> comparator, int n) {
        List<E> list = null;
        if (this.storageManager.canBeCached((IIndexQuery)storageIndexQuery, iAggregator)) {
            int n2 = this.storageManager.getCachedDataHash((IIndexQuery)storageIndexQuery, iAggregator);
            if (!this.localStorageData.isFullyDownloaded()) {
                StorageData storageData = new StorageData((IStorageData)this.localStorageData);
                try {
                    list = this.dataRetriever.getCachedDataViaHttp(this.getCmrRepositoryDefinition(), storageData, n2);
                }
                catch (BusinessException | SerializationException | IOException throwable) {}
                if (list == null && CollectionUtils.isNotEmpty(list = this.loadData(storageIndexQuery, iAggregator))) {
                    this.cacheQueryResultOnCmr(this.getCmrRepositoryDefinition(), storageData, list, n2);
                }
            } else {
                try {
                    list = this.dataRetriever.getCachedDataLocally(this.localStorageData, n2);
                }
                catch (SerializationException | IOException throwable) {}
                if (list == null && CollectionUtils.isNotEmpty(list = this.loadData(storageIndexQuery, iAggregator))) {
                    this.cacheQueryResultLocally(this.localStorageData, list, n2);
                }
            }
        } else {
            list = this.loadData(storageIndexQuery, iAggregator);
        }
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
        if (n > -1 && list.size() > n) {
            list = list.subList(0, n);
        }
        return list;
    }

    private void cacheQueryResultOnCmr(CmrRepositoryDefinition cmrRepositoryDefinition, StorageData storageData, List<E> list, int n) {
        try {
            cmrRepositoryDefinition.getStorageService().cacheStorageData(storageData, list, n);
        }
        catch (BusinessException businessException) {}
    }

    private void cacheQueryResultLocally(LocalStorageData localStorageData, List<E> list, int n) {
        try {
            this.storageManager.cacheStorageData((IStorageData)localStorageData, list, n);
        }
        catch (SerializationException | IOException throwable) {}
    }

    private List<E> loadData(StorageIndexQuery storageIndexQuery, IAggregator<E> iAggregator) {
        List list = this.getIndexingTree().query((IIndexQuery)storageIndexQuery);
        Collections.sort(list, new Comparator<IStorageDescriptor>(){

            @Override
            public int compare(IStorageDescriptor iStorageDescriptor, IStorageDescriptor iStorageDescriptor2) {
                int n = Integer.compare(iStorageDescriptor.getChannelId(), iStorageDescriptor2.getChannelId());
                if (n != 0) {
                    return n;
                }
                return Long.compare(iStorageDescriptor.getPosition(), iStorageDescriptor2.getPosition());
            }
        });
        AggregationPerformer aggregationPerformer = null;
        if (iAggregator != null) {
            aggregationPerformer = new AggregationPerformer(iAggregator);
        }
        List list2 = new ArrayList();
        int n = 0;
        int n2 = 0;
        ArrayList<IStorageDescriptor> arrayList = new ArrayList<IStorageDescriptor>();
        for (IStorageDescriptor iStorageDescriptor : list) {
            List list3;
            n = (int)((long)n + iStorageDescriptor.getSize());
            arrayList.add(iStorageDescriptor);
            if (n <= 0xA00000 && ++n2 != list.size()) continue;
            if (this.localStorageData.isFullyDownloaded()) {
                try {
                    list3 = this.dataRetriever.getDataLocally(this.localStorageData, list);
                }
                catch (SerializationException serializationException) {
                    String string = "Data in the downloaded storage " + this.localStorageData + " can not be loaded with this version of the inspectIT. Version of the CMR where storage was created is " + this.localStorageData.getCmrVersion() + ".";
                    InspectIT.getDefault().createErrorDialog(string, serializationException, -1);
                    return Collections.emptyList();
                }
                catch (IOException iOException) {
                    InspectIT.getDefault().createErrorDialog("Exception occurred trying to load the data.", iOException, -1);
                    return Collections.emptyList();
                }
            }
            try {
                list3 = this.dataRetriever.getDataViaHttp(this.getCmrRepositoryDefinition(), (IStorageData)this.localStorageData, arrayList);
            }
            catch (SerializationException serializationException) {
                String string = "Data in the remote storage " + this.localStorageData + " can not be loaded with this version of the inspectIT. Version of the CMR where storage was created is " + this.localStorageData.getCmrVersion() + ".";
                InspectIT.getDefault().createErrorDialog(string, serializationException, -1);
                return Collections.emptyList();
            }
            catch (IOException iOException) {
                InspectIT.getDefault().createErrorDialog("Exception occurred trying to load the data.", iOException, -1);
                return Collections.emptyList();
            }
            List list4 = this.getRestrictionsPassedList(list3, storageIndexQuery);
            if (aggregationPerformer != null) {
                aggregationPerformer.processCollection(list4);
            } else {
                list2.addAll(list4);
            }
            n = 0;
            arrayList.clear();
        }
        if (iAggregator != null) {
            list2 = aggregationPerformer.getResultList();
        }
        return list2;
    }

    private List<E> getRestrictionsPassedList(List<E> list, StorageIndexQuery storageIndexQuery) {
        ArrayList<DefaultData> arrayList = new ArrayList<DefaultData>();
        for (DefaultData defaultData : list) {
            if (defaultData == null || !defaultData.isQueryComplied((IIndexQuery)storageIndexQuery)) continue;
            arrayList.add(defaultData);
        }
        return arrayList;
    }

    public StorageRepositoryDefinition getStorageRepositoryDefinition() {
        return this.storageRepositoryDefinition;
    }

    public void setStorageRepositoryDefinition(StorageRepositoryDefinition storageRepositoryDefinition) {
        this.storageRepositoryDefinition = storageRepositoryDefinition;
    }

    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        return this.getStorageRepositoryDefinition().getCmrRepositoryDefinition();
    }

    public LocalStorageData getLocalStorageData() {
        return this.localStorageData;
    }

    public void setLocalStorageData(LocalStorageData localStorageData) {
        this.localStorageData = localStorageData;
    }

    public void setDataRetriever(DataRetriever dataRetriever) {
        this.dataRetriever = dataRetriever;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }
}

