/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.service.IExceptionDataAccessService;
import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.cmr.service.IHttpTimerDataAccessService;
import info.novatec.inspectit.cmr.service.IInvocationDataAccessService;
import info.novatec.inspectit.cmr.service.IJmxDataAccessService;
import info.novatec.inspectit.cmr.service.ISqlDataAccessService;
import info.novatec.inspectit.cmr.service.ITimerDataAccessService;
import info.novatec.inspectit.cmr.service.cache.CachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.service.storage.StorageServiceProvider;
import info.novatec.inspectit.storage.LocalStorageData;
import java.util.List;

public class StorageRepositoryDefinition
implements RepositoryDefinition {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private LocalStorageData localStorageData;
    private IInvocationDataAccessService invocationDataAccessService;
    private IGlobalDataAccessService globalDataAccessService;
    private IJmxDataAccessService jmxDataAccessService;
    private CachedDataService cachedDataService;
    private IExceptionDataAccessService exceptionDataAccessService;
    private ISqlDataAccessService sqlDataAccessService;
    private ITimerDataAccessService timerDataAccessService;
    private IHttpTimerDataAccessService httpTimerDataAccessService;
    private StorageServiceProvider storageServiceProvider;
    private IStorageTreeComponent<? extends DefaultData> indexingTree;
    private List<PlatformIdent> agents;

    @Override
    public String getIp() {
        return this.cmrRepositoryDefinition.getIp();
    }

    @Override
    public int getPort() {
        return this.cmrRepositoryDefinition.getPort();
    }

    @Override
    public String getName() {
        return this.localStorageData.getName();
    }

    @Override
    public IInvocationDataAccessService getInvocationDataAccessService() {
        return this.invocationDataAccessService;
    }

    @Override
    public ISqlDataAccessService getSqlDataAccessService() {
        return this.sqlDataAccessService;
    }

    @Override
    public IExceptionDataAccessService getExceptionDataAccessService() {
        return this.exceptionDataAccessService;
    }

    @Override
    public IGlobalDataAccessService getGlobalDataAccessService() {
        return this.globalDataAccessService;
    }

    @Override
    public IJmxDataAccessService getJmxDataAccessService() {
        return this.jmxDataAccessService;
    }

    public CachedDataService getCachedDataService() {
        return this.cachedDataService;
    }

    @Override
    public ITimerDataAccessService getTimerDataAccessService() {
        return this.timerDataAccessService;
    }

    @Override
    public IHttpTimerDataAccessService getHttpTimerDataAccessService() {
        return this.httpTimerDataAccessService;
    }

    public void initServices() {
        this.globalDataAccessService = this.storageServiceProvider.createStorageGlobalDataAccessService(this, this.localStorageData, this.indexingTree, this.agents);
        this.exceptionDataAccessService = this.storageServiceProvider.createStorageExceptionDataAccessService(this, this.localStorageData, this.indexingTree);
        this.invocationDataAccessService = this.storageServiceProvider.createStorageInvocationDataAccessService(this, this.localStorageData, this.indexingTree);
        this.sqlDataAccessService = this.storageServiceProvider.createStorageSqlDataAccessService(this, this.localStorageData, this.indexingTree);
        this.timerDataAccessService = this.storageServiceProvider.createStorageTimerDataAccessService(this, this.localStorageData, this.indexingTree);
        this.httpTimerDataAccessService = this.storageServiceProvider.createStorageHttpTimerDataAccessService(this, this.localStorageData, this.indexingTree);
        this.jmxDataAccessService = this.storageServiceProvider.createStorageJmxDataAccessService(this, this.localStorageData, this.indexingTree);
        this.cachedDataService = new CachedDataService(this.globalDataAccessService);
    }

    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        return this.cmrRepositoryDefinition;
    }

    public void setCmrRepositoryDefinition(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
    }

    public LocalStorageData getLocalStorageData() {
        return this.localStorageData;
    }

    public void setLocalStorageData(LocalStorageData localStorageData) {
        this.localStorageData = localStorageData;
    }

    public void setStorageServiceProvider(StorageServiceProvider storageServiceProvider) {
        this.storageServiceProvider = storageServiceProvider;
    }

    public void setIndexingTree(IStorageTreeComponent<? extends DefaultData> iStorageTreeComponent) {
        this.indexingTree = iStorageTreeComponent;
    }

    public void setAgents(List<PlatformIdent> list) {
        this.agents = list;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.localStorageData});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StorageRepositoryDefinition storageRepositoryDefinition = (StorageRepositoryDefinition)object;
        return Objects.equal((Object)this.localStorageData, (Object)storageRepositoryDefinition.localStorageData);
    }
}

