/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.property;

import info.novatec.inspectit.cmr.property.configuration.GroupedProperty;
import info.novatec.inspectit.cmr.property.configuration.PropertySection;
import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.update.configuration.ConfigurationUpdate;
import info.novatec.inspectit.rcp.property.GroupedPropertyPreferencePage;
import info.novatec.inspectit.rcp.property.PropertyPreferencePage;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PreferenceNodeFilter;

public class CmrConfigurationDialog
extends FilteredPreferenceDialog {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private ConfigurationUpdate configurationUpdate;
    private boolean serverRestartRequired;
    private ViewerFilter preferenceNodeFilter = new PreferenceNodeFilter(new String[0]);

    public CmrConfigurationDialog(Shell shell, CmrRepositoryDefinition cmrRepositoryDefinition) {
        super(shell, CmrConfigurationDialog.getPreferenceManager(cmrRepositoryDefinition));
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Configure CMR '" + this.cmrRepositoryDefinition.getName() + "' (" + this.cmrRepositoryDefinition.getIp() + ":" + this.cmrRepositoryDefinition.getPort() + ")");
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Button button = new Button(composite2, 32);
        button.setText("Show advanced properties");
        button.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CmrConfigurationDialog.this.showAdvanced(button.getSelection());
            }
        });
        super.createButtonBar(composite2);
        this.filteredTree.getViewer().setExpandPreCheckFilters(true);
        this.showAdvanced(false);
        return composite2;
    }

    protected void okPressed() {
        HashSet hashSet = new HashSet();
        for (IPreferenceNode iPreferenceNode : this.getPreferenceManager().getElements(0)) {
            IPreferencePage iPreferencePage = iPreferenceNode.getPage();
            if (!(iPreferencePage instanceof PropertyPreferencePage)) continue;
            PropertyPreferencePage propertyPreferencePage = (PropertyPreferencePage)iPreferencePage;
            hashSet.addAll(propertyPreferencePage.getPropertyUpdates());
            if (!propertyPreferencePage.isServerRestartRequired()) continue;
            this.serverRestartRequired = true;
        }
        if (CollectionUtils.isNotEmpty(hashSet)) {
            this.configurationUpdate = new ConfigurationUpdate();
            this.configurationUpdate.setPropertyUpdates(hashSet);
        }
        super.okPressed();
    }

    private void showAdvanced(boolean bl) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : this.getPreferenceManager().getElements(0)) {
            IPreferencePage iPreferencePage = object2.getPage();
            if (!(iPreferencePage instanceof PropertyPreferencePage)) continue;
            PropertyPreferencePage propertyPreferencePage = (PropertyPreferencePage)iPreferencePage;
            propertyPreferencePage.showAdvanced(bl);
            if (!bl && !this.showIfNoAdvanced((IPreferenceNode)object2)) continue;
            arrayList.add(object2.getId());
        }
        if (this.preferenceNodeFilter != null) {
            this.filteredTree.getViewer().removeFilter(this.preferenceNodeFilter);
        }
        this.preferenceNodeFilter = new PreferenceNodeFilter(arrayList.toArray(new String[arrayList.size()]));
        this.filteredTree.getViewer().addFilter(this.preferenceNodeFilter);
        Collections.sort(arrayList);
        object2 = (PropertyPreferencePage)this.getCurrentPage();
        if (object2 != null && !bl && ((PropertyPreferencePage)object2).isAllAdvancedProperties()) {
            this.setCurrentPageId((String)arrayList.get(0));
        }
    }

    private boolean showIfNoAdvanced(IPreferenceNode iPreferenceNode) {
        if (iPreferenceNode.getPage() instanceof PropertyPreferencePage && !((PropertyPreferencePage)iPreferenceNode.getPage()).isAllAdvancedProperties()) {
            return true;
        }
        if (ArrayUtils.isNotEmpty((Object[])iPreferenceNode.getSubNodes())) {
            IPreferenceNode[] iPreferenceNodeArray = iPreferenceNode.getSubNodes();
            int n = iPreferenceNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPreferenceNode iPreferenceNode2 = iPreferenceNodeArray[n2];
                if (this.showIfNoAdvanced(iPreferenceNode2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public ConfigurationUpdate getConfigurationUpdate() {
        return this.configurationUpdate;
    }

    public boolean isServerRestartRequired() {
        return this.serverRestartRequired;
    }

    public static PreferenceManager getPreferenceManager(CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (cmrRepositoryDefinition == null) {
            throw new IllegalArgumentException("Can not create Preference Manager because repository is null.");
        }
        if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            throw new IllegalArgumentException("Can not create Preference Manager because repository is off-line.");
        }
        Collection collection = cmrRepositoryDefinition.getCmrManagementService().getConfigurationPropertySections();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            throw new IllegalArgumentException("Can not create CMR Preference Manager because repository can not provide active properties.");
        }
        PreferenceManager preferenceManager = new PreferenceManager();
        for (PropertySection propertySection : collection) {
            Object object22;
            ArrayList<PreferenceNode> arrayList = new ArrayList<PreferenceNode>();
            ArrayList arrayList2 = new ArrayList();
            for (Object object22 : propertySection.getProperties()) {
                if (object22 instanceof GroupedProperty) {
                    GroupedProperty groupedProperty = (GroupedProperty)object22;
                    GroupedPropertyPreferencePage groupedPropertyPreferencePage = new GroupedPropertyPreferencePage(groupedProperty);
                    PreferenceNode preferenceNode = new PreferenceNode(groupedProperty.getName(), (IPreferencePage)groupedPropertyPreferencePage);
                    arrayList.add(preferenceNode);
                    continue;
                }
                if (!(object22 instanceof SingleProperty)) continue;
                arrayList2.add((SingleProperty)object22);
            }
            object22 = new PropertyPreferencePage(propertySection.getName(), arrayList2);
            PreferenceNode preferenceNode = new PreferenceNode(propertySection.getName(), (IPreferencePage)object22);
            preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
            for (IPreferenceNode iPreferenceNode : arrayList) {
                preferenceManager.addTo(propertySection.getName(), iPreferenceNode);
            }
        }
        return preferenceManager;
    }
}

