/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences.valueproviders;

import info.novatec.inspectit.rcp.preferences.PreferenceException;
import info.novatec.inspectit.rcp.preferences.valueproviders.PreferenceValueProviderFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class EnumSetPreferenceValueProvider<E extends Enum<E>>
extends PreferenceValueProviderFactory.PreferenceValueProvider<Set<E>> {
    private Class<E> enumClass;

    public EnumSetPreferenceValueProvider(Class<E> clazz) {
        this.enumClass = clazz;
    }

    @Override
    public boolean isObjectValid(Object object) {
        if (object instanceof Set) {
            Set set = (Set)object;
            for (Object e : set) {
                if (this.enumClass.isAssignableFrom(e.getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getValueForObject(Set<E> set) throws PreferenceException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Enum enum_ : set) {
            stringBuilder.append(String.valueOf(enum_.toString()) + "|");
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<E> getObjectFromValue(String string) throws PreferenceException {
        HashSet<E> hashSet = new HashSet<E>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreElements()) {
            hashSet.add(Enum.valueOf(this.enumClass, stringTokenizer.nextToken()));
        }
        return hashSet;
    }
}

