/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences.valueproviders;

import info.novatec.inspectit.rcp.preferences.PreferenceException;
import info.novatec.inspectit.rcp.preferences.valueproviders.PreferenceValueProviderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;

public class CollectionPreferenceValueProvider
extends PreferenceValueProviderFactory.PreferenceValueProvider<Collection<?>> {
    private static final String EMPTY_COLLECTION = "EMPTY_COLLECTION";

    @Override
    public boolean isObjectValid(Object object) {
        return object instanceof Collection;
    }

    @Override
    public String getValueForObject(Collection<?> collection) throws PreferenceException {
        if (CollectionUtils.isEmpty(collection)) {
            return EMPTY_COLLECTION;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : collection) {
            stringBuilder.append(String.valueOf(this.getValueForCollectionMember(obj)) + "|");
        }
        return stringBuilder.toString();
    }

    @Override
    public Collection<?> getObjectFromValue(String string) throws PreferenceException {
        if (EMPTY_COLLECTION.equals(string)) {
            return this.getCollectionForResults();
        }
        Collection<Object> collection = this.getCollectionForResults();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreElements()) {
            collection.add(this.getObjectForCollectionMember(stringTokenizer.nextToken()));
        }
        return collection;
    }

    protected Collection<Object> getCollectionForResults() {
        return new ArrayList<Object>();
    }

    protected String getValueForCollectionMember(Object object) {
        return object.toString();
    }

    protected Object getObjectForCollectionMember(String string) {
        return string;
    }
}

