/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredClassComposite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredPackageComposite
extends DeferredComposite {
    private List<MethodIdent> classes = new CopyOnWriteArrayList<MethodIdent>();
    private RepositoryDefinition repositoryDefinition;
    private boolean hideInactiveInstrumentations;

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            Composite composite = (Composite)object;
            iProgressMonitor.beginTask("Loading of Class Elements...", -1);
            HashMap<String, DeferredClassComposite> hashMap = new HashMap<String, DeferredClassComposite>(this.classes.size());
            for (MethodIdent methodIdent : this.classes) {
                if (this.select(methodIdent)) {
                    DeferredClassComposite deferredClassComposite;
                    String string = methodIdent.getClassName();
                    if (!hashMap.containsKey(string)) {
                        deferredClassComposite = this.getNewChild();
                        deferredClassComposite.setRepositoryDefinition(this.repositoryDefinition);
                        deferredClassComposite.setName(string);
                        iElementCollector.add((Object)deferredClassComposite, iProgressMonitor);
                        composite.addChild(deferredClassComposite);
                        hashMap.put(string, deferredClassComposite);
                    }
                    deferredClassComposite = (DeferredClassComposite)hashMap.get(string);
                    deferredClassComposite.addMethodToDisplay(methodIdent);
                    deferredClassComposite.setHideInactiveInstrumentations(this.hideInactiveInstrumentations);
                }
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    @Override
    public boolean isEnabled() {
        if (CollectionUtils.isNotEmpty(this.classes)) {
            for (MethodIdent methodIdent : this.classes) {
                if (!methodIdent.hasActiveSensorTypes()) continue;
                return true;
            }
        }
        return false;
    }

    protected DeferredClassComposite getNewChild() {
        return new DeferredClassComposite();
    }

    protected boolean select(MethodIdent methodIdent) {
        return !this.hideInactiveInstrumentations || methodIdent.hasActiveSensorTypes();
    }

    public void addClassToDisplay(MethodIdent methodIdent) {
        this.classes.add(methodIdent);
    }

    @Override
    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    @Override
    public Image getImage() {
        return InspectIT.getDefault().getImage("/icons/eclipse/package_obj.gif");
    }

    public boolean isHideInactiveInstrumentations() {
        return this.hideInactiveInstrumentations;
    }

    public void setHideInactiveInstrumentations(boolean bl) {
        this.hideInactiveInstrumentations = bl;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.classes, this.repositoryDefinition});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DeferredPackageComposite deferredPackageComposite = (DeferredPackageComposite)object;
        return Objects.equal(this.classes, deferredPackageComposite.classes) && Objects.equal((Object)this.repositoryDefinition, (Object)deferredPackageComposite.repositoryDefinition);
    }
}

