/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.model.MethodIdentToSensorType;
import info.novatec.inspectit.cmr.model.MethodSensorTypeIdent;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.model.Leaf;
import info.novatec.inspectit.rcp.model.ModifiersImageFactory;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredMethodComposite
extends DeferredComposite {
    private MethodIdent method;
    private RepositoryDefinition repositoryDefinition;
    private boolean hideInactiveInstrumentations;

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            Composite composite = (Composite)object;
            Set set = this.method.getMethodIdentToSensorTypes();
            iProgressMonitor.beginTask("Loading of Sensor Type Elements...", set.size());
            for (MethodIdentToSensorType methodIdentToSensorType : set) {
                if (!this.hideInactiveInstrumentations || methodIdentToSensorType.isActive()) {
                    MethodSensorTypeIdent methodSensorTypeIdent = methodIdentToSensorType.getMethodSensorTypeIdent();
                    Leaf leaf = new Leaf();
                    String string = methodSensorTypeIdent.getFullyQualifiedClassName();
                    SensorTypeEnum sensorTypeEnum = SensorTypeEnum.get(string);
                    leaf.setName(sensorTypeEnum.getDisplayName());
                    leaf.setImage(sensorTypeEnum.getImage());
                    leaf.setEnabled(methodIdentToSensorType.isActive());
                    if (sensorTypeEnum.isOpenable()) {
                        InputDefinition inputDefinition = new InputDefinition();
                        inputDefinition.setRepositoryDefinition(this.repositoryDefinition);
                        inputDefinition.setId(sensorTypeEnum);
                        EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
                        editorPropertiesData.setSensorImage(sensorTypeEnum.getImage());
                        editorPropertiesData.setSensorName(sensorTypeEnum.getDisplayName());
                        MethodIdent methodIdent = this.repositoryDefinition.getCachedDataService().getMethodIdentForId(this.method.getId().longValue());
                        editorPropertiesData.setViewName(TextFormatter.getMethodString(methodIdent));
                        editorPropertiesData.setViewImage(ModifiersImageFactory.getImage(methodIdent.getModifiers()));
                        editorPropertiesData.setPartNameFlag(EditorPropertiesData.PartType.SENSOR);
                        inputDefinition.setEditorPropertiesData(editorPropertiesData);
                        InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
                        idDefinition.setPlatformId(this.method.getPlatformIdent().getId());
                        idDefinition.setSensorTypeId(methodSensorTypeIdent.getId());
                        idDefinition.setMethodId(this.method.getId());
                        inputDefinition.setIdDefinition(idDefinition);
                        leaf.setInputDefinition(inputDefinition);
                    }
                    iElementCollector.add((Object)leaf, iProgressMonitor);
                    composite.addChild(leaf);
                }
                iProgressMonitor.worked(1);
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.method.hasActiveSensorTypes();
    }

    public void setMethod(MethodIdent methodIdent) {
        this.method = methodIdent;
    }

    @Override
    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    @Override
    public Image getImage() {
        return ModifiersImageFactory.getImage(this.method.getModifiers());
    }

    public void setHideInactiveInstrumentations(boolean bl) {
        this.hideInactiveInstrumentations = bl;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.method, this.repositoryDefinition});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DeferredMethodComposite deferredMethodComposite = (DeferredMethodComposite)object;
        return Objects.equal((Object)this.method, (Object)deferredMethodComposite.method) && Objects.equal((Object)this.repositoryDefinition, (Object)deferredMethodComposite.repositoryDefinition);
    }
}

