/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.menu;

import info.novatec.inspectit.rcp.InspectIT;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.services.IEvaluationService;

public class SearchDocumentationContributionItem
extends WorkbenchWindowControlContribution {
    private static final String DEFAULT_TEXT = "Wiki search";
    private Text searchText;

    public SearchDocumentationContributionItem() {
    }

    public SearchDocumentationContributionItem(String string) {
        super(string);
    }

    protected Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.searchText = new Text(composite2, 2692);
        this.setDefaultText();
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 150;
        this.searchText.setLayoutData((Object)gridData);
        this.searchText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (Objects.equals(SearchDocumentationContributionItem.this.searchText.getText(), SearchDocumentationContributionItem.DEFAULT_TEXT)) {
                    SearchDocumentationContributionItem.this.setEmptyText();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (Objects.equals(SearchDocumentationContributionItem.this.searchText.getText(), "")) {
                    SearchDocumentationContributionItem.this.setDefaultText();
                }
            }
        });
        this.searchText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2) {
                    SearchDocumentationContributionItem.this.setDefaultText();
                    SearchDocumentationContributionItem.this.searchText.getParent().forceFocus();
                } else if (traverseEvent.detail == 4) {
                    SearchDocumentationContributionItem.this.executeSearch();
                }
            }
        });
        return composite2;
    }

    private void setDefaultText() {
        this.searchText.setText(DEFAULT_TEXT);
        this.searchText.setForeground(Display.getDefault().getSystemColor(15));
    }

    private void setEmptyText() {
        this.searchText.setText("");
        this.searchText.setForeground(Display.getDefault().getSystemColor(2));
    }

    private void executeSearch() {
        String string = this.searchText.getText();
        if (StringUtils.isNotBlank((String)string)) {
            ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            IEvaluationService iEvaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
            try {
                Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.searchDocumentation");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("info.novatec.inspectit.rcp.commands.searchDocumentation.searchString", string);
                command.executeWithChecks(new ExecutionEvent(command, hashMap, (Object)this.searchText, (Object)iEvaluationService.getCurrentState()));
            }
            catch (Exception exception) {
                InspectIT.getDefault().createErrorDialog("There was an exception executing the wiki search.", exception, -1);
            }
        }
    }
}

