/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.CmrRepositoryManager;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public class ShutdownCmrHandler
extends AbstractHandler
implements IHandler {
    public static final String SHOULD_RESTART_PARAMETER = "info.novatec.inspectit.rcp.commands.shutdown.shouldRestart";

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        String string = executionEvent.getParameter(SHOULD_RESTART_PARAMETER);
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (StringUtils.isNotEmpty((String)string) && iSelection instanceof StructuredSelection) {
            final boolean bl = Boolean.parseBoolean(string);
            Object object = ((StructuredSelection)iSelection).getFirstElement();
            if (object instanceof ICmrRepositoryProvider) {
                final CmrRepositoryDefinition cmrRepositoryDefinition = ((ICmrRepositoryProvider)object).getCmrRepositoryDefinition();
                String string2 = "'" + cmrRepositoryDefinition.getName() + "' (" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort() + ")";
                boolean bl2 = bl ? MessageDialog.openConfirm((Shell)HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (String)"Restart CMR", (String)("Are you sure you want to restart the CMR " + string2 + "?")) : MessageDialog.openConfirm((Shell)HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (String)"Shutdown CMR", (String)("Are you sure you want to shutdown the CMR " + string2 + "?"));
                if (bl2) {
                    IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
                    try {
                        iProgressService.busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                if (bl) {
                                    iProgressMonitor.beginTask("Restarting the CMR", -1);
                                    cmrRepositoryDefinition.getCmrManagementService().restart();
                                } else {
                                    iProgressMonitor.beginTask("Shutting down the CMR", -1);
                                    cmrRepositoryDefinition.getCmrManagementService().shutdown();
                                }
                                cmrRepositoryDefinition.changeOnlineStatus(CmrRepositoryDefinition.OnlineStatus.CHECKING);
                                cmrRepositoryDefinition.changeOnlineStatus(CmrRepositoryDefinition.OnlineStatus.OFFLINE);
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    Thread.interrupted();
                                }
                                if (bl) {
                                    iProgressMonitor.beginTask("Waiting for the CMR to be online again", -1);
                                    while (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                                        try {
                                            Thread.sleep(2000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            Thread.interrupted();
                                        }
                                        CmrRepositoryManager.UpdateRepositoryJob updateRepositoryJob = InspectIT.getDefault().getCmrRepositoryManager().forceCmrRepositoryOnlineStatusUpdate(cmrRepositoryDefinition);
                                        updateRepositoryJob.join();
                                        if (!iProgressMonitor.isCanceled()) continue;
                                        return;
                                    }
                                }
                                iProgressMonitor.done();
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        throw new ExecutionException("Exception occurred during execution of shutdown/restart handler", (Throwable)exception);
                    }
                }
            }
        }
        return null;
    }
}

