/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveStorageLabelHandler
extends AbstractHandler
implements IHandler {
    public static final String COMMAND = "info.novatec.inspectit.rcp.commands.removeStorageLabel";
    public static final String INPUT = "info.novatec.inspectit.rcp.commands.removeStorageLabel.input";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
        List list = (List)iEvaluationContext.getVariable(INPUT);
        IStorageDataProvider iStorageDataProvider = null;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection && ((StructuredSelection)iSelection).getFirstElement() instanceof IStorageDataProvider) {
            iStorageDataProvider = (IStorageDataProvider)((StructuredSelection)iSelection).getFirstElement();
        }
        if (iStorageDataProvider == null || list == null) return null;
        CmrRepositoryDefinition cmrRepositoryDefinition = iStorageDataProvider.getCmrRepositoryDefinition();
        if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) throw new ExecutionException("Labels could not be removed from storage, because the underlying repository is offline.");
        try {
            StorageData storageData = cmrRepositoryDefinition.getStorageService().removeLabelsFromStorage(iStorageDataProvider.getStorageData(), list);
            try {
                InspectIT.getDefault().getInspectITStorageManager().storageRemotelyUpdated(storageData);
            }
            catch (SerializationException | IOException throwable) {
                throw new ExecutionException("Error occured trying to save local storage data to disk.", throwable);
            }
            IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.novatec.inspectit.rcp.view.storageManager");
            if (!(iViewPart instanceof StorageManagerView)) return null;
            ((StorageManagerView)iViewPart).refresh(cmrRepositoryDefinition);
            return null;
        }
        catch (BusinessException businessException) {
            throw new ExecutionException("Error occured trying to remove labels from storage.", (Throwable)businessException);
        }
    }
}

