/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import info.novatec.inspectit.rcp.editor.tree.SteppingTreeSubView;
import info.novatec.inspectit.rcp.handlers.AbstractTemplateHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class LocateHandler
extends AbstractTemplateHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        AbstractRootEditor abstractRootEditor;
        ISubView iSubView;
        SteppingTreeSubView steppingTreeSubView;
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        if (iEditorPart instanceof AbstractRootEditor && (steppingTreeSubView = (iSubView = (abstractRootEditor = (AbstractRootEditor)iEditorPart).getSubView()).getSubView(SteppingTreeSubView.class)) != null) {
            StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
            List<DefaultData> list = this.getTemplates(structuredSelection);
            for (DefaultData defaultData : list) {
                steppingTreeSubView.addObjectToSteppingControl(defaultData);
            }
            iSubView.select(steppingTreeSubView);
        }
        return null;
    }

    public abstract List<DefaultData> getTemplates(StructuredSelection var1);

    public static final class ExceptionLocateHandler
    extends LocateHandler {
        @Override
        public List<DefaultData> getTemplates(StructuredSelection structuredSelection) {
            ArrayList<DefaultData> arrayList = new ArrayList<DefaultData>();
            for (Object e : structuredSelection.toList()) {
                if (!(e instanceof ExceptionSensorData)) continue;
                arrayList.add((DefaultData)super.getTemplate((ExceptionSensorData)e, true, true, true, true, true));
            }
            return arrayList;
        }
    }

    public static final class InvocationLocateHandler
    extends LocateHandler {
        @Override
        public List<DefaultData> getTemplates(StructuredSelection structuredSelection) {
            ArrayList<DefaultData> arrayList = new ArrayList<DefaultData>();
            for (Object e : structuredSelection.toList()) {
                if (!(e instanceof InvocationSequenceData)) continue;
                InvocationSequenceData invocationSequenceData = (InvocationSequenceData)e;
                if (invocationSequenceData.getSqlStatementData() != null) {
                    arrayList.add((DefaultData)super.getTemplate(invocationSequenceData.getSqlStatementData(), false, true, false));
                    if (invocationSequenceData.getTimerData() != null && TimerData.class.equals(invocationSequenceData.getTimerData().getClass())) {
                        arrayList.add((DefaultData)super.getTemplate(invocationSequenceData.getTimerData(), false, true));
                        continue;
                    }
                    arrayList.add((DefaultData)super.getTemplate(this.getTimerDataForSql(invocationSequenceData.getSqlStatementData()), false, true));
                    continue;
                }
                if (invocationSequenceData.getExceptionSensorDataObjects() != null && !invocationSequenceData.getExceptionSensorDataObjects().isEmpty()) {
                    ExceptionSensorData exceptionSensorData = (ExceptionSensorData)invocationSequenceData.getExceptionSensorDataObjects().get(0);
                    arrayList.add((DefaultData)super.getTemplate(exceptionSensorData, false, true, false, false, false));
                    continue;
                }
                if (invocationSequenceData.getTimerData() != null && TimerData.class.equals(invocationSequenceData.getTimerData().getClass())) {
                    arrayList.add((DefaultData)super.getTemplate(invocationSequenceData.getTimerData(), false, true));
                    continue;
                }
                arrayList.add((DefaultData)super.getTemplate(invocationSequenceData, false, true));
            }
            return arrayList;
        }

        private TimerData getTimerDataForSql(SqlStatementData sqlStatementData) {
            TimerData timerData = new TimerData();
            timerData.setMethodIdent(sqlStatementData.getMethodIdent());
            return timerData;
        }
    }

    public static final class SqlLocateHandler
    extends LocateHandler {
        @Override
        public List<DefaultData> getTemplates(StructuredSelection structuredSelection) {
            ArrayList<DefaultData> arrayList = new ArrayList<DefaultData>();
            for (Object e : structuredSelection.toList()) {
                if (!(e instanceof SqlStatementData)) continue;
                arrayList.add((DefaultData)super.getTemplate((SqlStatementData)e, true, true, true));
            }
            return arrayList;
        }
    }

    public static final class TimerLocateHandler
    extends LocateHandler {
        @Override
        public List<DefaultData> getTemplates(StructuredSelection structuredSelection) {
            ArrayList<DefaultData> arrayList = new ArrayList<DefaultData>();
            for (Object e : structuredSelection.toList()) {
                if (!(e instanceof TimerData)) continue;
                arrayList.add((DefaultData)super.getTemplate((TimerData)e, true, true));
            }
            return arrayList;
        }
    }
}

