/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.model.AgentLeaf;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteAgentHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        boolean bl = MessageDialog.openConfirm((Shell)HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (String)"Confirm Delete", (String)"Are you sure you want to permanently delete the selected Agent(s)? Note that all monitoring data related to the Agent(s) will be deleted from the repository database.");
        if (bl) {
            for (Object e : iStructuredSelection) {
                if (!(e instanceof AgentLeaf)) continue;
                AgentLeaf agentLeaf = (AgentLeaf)e;
                PlatformIdent platformIdent = agentLeaf.getPlatformIdent();
                CmrRepositoryDefinition cmrRepositoryDefinition = agentLeaf.getCmrRepositoryDefinition();
                try {
                    cmrRepositoryDefinition.getGlobalDataAccessService().deleteAgent(platformIdent.getId().longValue());
                    InspectIT.getDefault().getCmrRepositoryManager().repositoryAgentDeleted(cmrRepositoryDefinition, platformIdent);
                }
                catch (BusinessException businessException) {
                    throw new ExecutionException("Exception occurred trying to delete the Agent from the CMR.", (Throwable)businessException);
                }
            }
        }
        return null;
    }
}

