/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.wizard.CopyDataToStorageWizard;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyDataToStorageHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Object object;
        AbstractRootEditor abstractRootEditor = (AbstractRootEditor)HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        RepositoryDefinition repositoryDefinition = abstractRootEditor.getInputDefinition().getRepositoryDefinition();
        StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        HashSet<DefaultData> hashSet = new HashSet<DefaultData>(structuredSelection.size());
        for (Object object2 : structuredSelection) {
            if (object2 instanceof InvocationSequenceData) {
                object = (InvocationSequenceData)object2;
                while (object.getParentSequence() != null) {
                    object = object.getParentSequence();
                }
                hashSet.add((DefaultData)object);
                continue;
            }
            if (!(object2 instanceof DefaultData)) continue;
            hashSet.add((DefaultData)object2);
        }
        if (!hashSet.isEmpty() && repositoryDefinition instanceof CmrRepositoryDefinition) {
            Object object2;
            CmrRepositoryDefinition cmrRepositoryDefinition = (CmrRepositoryDefinition)repositoryDefinition;
            try {
                object2 = cmrRepositoryDefinition.getCmrManagementService().getCmrStatusData();
                if (object2.isWarnSpaceLeftActive()) {
                    object = NumberFormatter.humanReadableByteCount(object2.getStorageDataSpaceLeft());
                    if (!MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (String)"Confirm", (String)("For selected CMR there is an active warning about insufficient storage space left. Only " + (String)object + " are left on the target server, are you sure you want to continue?"))) {
                        return null;
                    }
                }
            }
            catch (Exception exception) {}
            object2 = new CopyDataToStorageWizard(cmrRepositoryDefinition, hashSet);
            object = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), object2);
            object.open();
        }
        return null;
    }
}

