/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.cmr.property.update.configuration.ConfigurationUpdate;
import info.novatec.inspectit.rcp.property.CmrConfigurationDialog;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CmrConfigurationHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (structuredSelection.getFirstElement() instanceof ICmrRepositoryProvider) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
            CmrRepositoryDefinition cmrRepositoryDefinition = ((ICmrRepositoryProvider)structuredSelection.getFirstElement()).getCmrRepositoryDefinition();
            CmrConfigurationDialog cmrConfigurationDialog = new CmrConfigurationDialog(shell, cmrRepositoryDefinition);
            cmrConfigurationDialog.open();
            if (cmrConfigurationDialog.getReturnCode() == 0) {
                ConfigurationUpdate configurationUpdate = cmrConfigurationDialog.getConfigurationUpdate();
                boolean bl = cmrConfigurationDialog.isServerRestartRequired();
                if (configurationUpdate != null) {
                    boolean bl2 = false;
                    if (bl) {
                        String string = "Selected updates need server restart to be effective. Do you want to restart the CMR?";
                        bl2 = MessageDialog.openQuestion((Shell)shell, (String)"CMR Restart Required", (String)string);
                    }
                    new ConfigurationUpdateJob(cmrRepositoryDefinition, configurationUpdate, bl2).schedule();
                }
            }
        }
        return null;
    }

    private static final class ConfigurationUpdateJob
    extends Job {
        private CmrRepositoryDefinition cmrRepositoryDefinition;
        private ConfigurationUpdate configurationUpdate;
        private boolean executeRestart;

        public ConfigurationUpdateJob(CmrRepositoryDefinition cmrRepositoryDefinition, ConfigurationUpdate configurationUpdate, boolean bl) {
            super("Update CMR Configuration Job");
            this.cmrRepositoryDefinition = cmrRepositoryDefinition;
            this.configurationUpdate = configurationUpdate;
            this.executeRestart = bl;
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask("Updating the CMR configuration", -1);
            if (this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                try {
                    this.cmrRepositoryDefinition.getCmrManagementService().updateConfiguration(this.configurationUpdate, this.executeRestart);
                }
                catch (Exception exception) {
                    return new Status(4, "info.novatec.inspectit.rcp", "Exception occurred trying to update the CMR configuration.", (Throwable)exception);
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
            return new Status(4, "info.novatec.inspectit.rcp", "Can not update the configuration because selected CMR is offline.");
        }
    }
}

