/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.formatter;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public final class ColorFormatter {
    private ColorFormatter() {
    }

    public static Color getLinearGradientColor(RGB rGB, RGB rGB2, double d, ResourceManager resourceManager) {
        Assert.isTrue((d >= 0.0 && d <= 1.0 ? 1 : 0) != 0, (String)"Ratio for linear gradient must me between 0 and 1 (including).");
        int n = (int)((double)rGB2.red * d + (double)rGB.red * (1.0 - d));
        int n2 = (int)((double)rGB2.green * d + (double)rGB.green * (1.0 - d));
        int n3 = (int)((double)rGB2.blue * d + (double)rGB.blue * (1.0 - d));
        RGB rGB3 = new RGB(n, n2, n3);
        return resourceManager.createColor(rGB3);
    }

    public static Color getPerformanceColor(RGB rGB, RGB rGB2, RGB rGB3, double d, double d2, double d3, ResourceManager resourceManager) {
        Assert.isTrue((d2 != d3 ? 1 : 0) != 0);
        double d4 = (d2 + d3) / 2.0;
        if (d2 > d3) {
            if (d > d2) {
                return resourceManager.createColor(rGB);
            }
            if (d < d3) {
                return resourceManager.createColor(rGB3);
            }
            if (d > d4) {
                double d5 = Math.abs((d - d4) / (d2 - d4));
                return ColorFormatter.getLinearGradientColor(rGB2, rGB, d5, resourceManager);
            }
            double d6 = Math.abs((d - d3) / (d4 - d3));
            return ColorFormatter.getLinearGradientColor(rGB3, rGB2, d6, resourceManager);
        }
        if (d2 < d3) {
            if (d < d2) {
                return resourceManager.createColor(rGB);
            }
            if (d > d3) {
                return resourceManager.createColor(rGB3);
            }
            if (d < d4) {
                double d7 = 1.0 - Math.abs((d - d2) / (d4 - d2));
                return ColorFormatter.getLinearGradientColor(rGB2, rGB, d7, resourceManager);
            }
            double d8 = 1.0 - Math.abs((d - d4) / (d3 - d4));
            return ColorFormatter.getLinearGradientColor(rGB3, rGB2, d8, resourceManager);
        }
        throw new RuntimeException("Performance color can not be created due to the bad input values.");
    }
}

