/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.viewers;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class ImageFixStyledCellIndexLabelProvider
extends StyledCellIndexLabelProvider {
    private static final int IMAGE_MARGIN = 1;
    private static Method getSharedTextLayoutMethod;

    static {
        try {
            getSharedTextLayoutMethod = StyledCellLabelProvider.class.getDeclaredMethod("getSharedTextLayout", Display.class);
            getSharedTextLayoutMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            InspectIT.getDefault().log(1, "Can no load the getSharedTextLayout() method on the Display class.", exception);
        }
    }

    @Override
    public void update(ViewerCell viewerCell) {
        super.update(viewerCell);
        viewerCell.setImage(null);
    }

    protected void paint(Event event, Object object) {
        Rectangle rectangle = this.getViewerCellBounds(event);
        if (rectangle == null) {
            return;
        }
        Image image = this.getColumnImage(object, event.index);
        Rectangle rectangle2 = null;
        if (image != null) {
            rectangle2 = image.getBounds();
            TextLayout textLayout = this.getSharedTextLayout(event.display);
            textLayout.setIndent(rectangle2.width + 1 + 1);
        }
        super.paint(event, object);
        if (rectangle2 != null) {
            int n = rectangle.x + 1;
            int n2 = rectangle.y + Math.max(0, (rectangle.height - rectangle2.height) / 2);
            event.gc.drawImage(image, n, n2);
        }
    }

    private Rectangle getViewerCellBounds(Event event) {
        if (event.item instanceof TableItem) {
            return ((TableItem)event.item).getBounds(event.index);
        }
        if (event.item instanceof TreeItem) {
            return ((TreeItem)event.item).getBounds(event.index);
        }
        throw new RuntimeException("ImageFixStyledCellIndexLabelProvider can only run with tree or table");
    }

    private TextLayout getSharedTextLayout(Display display) {
        if (getSharedTextLayoutMethod == null) {
            return null;
        }
        try {
            return (TextLayout)getSharedTextLayoutMethod.invoke((Object)this, display);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }
}

