/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.tree.input.InvocDetailInputController;
import info.novatec.inspectit.rcp.editor.tree.input.SteppingTreeInputController;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.util.ElementOccurrenceCount;
import info.novatec.inspectit.rcp.util.OccurrenceFinderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ViewerFilter;

public class SteppingInvocDetailInputController
extends InvocDetailInputController
implements SteppingTreeInputController {
    public static final String ID = "inspectit.subview.tree.steppinginvocdetail";
    private List<Object> steppingObjectsList;
    private ICachedDataService cachedDataService;
    private boolean initVisible;

    public SteppingInvocDetailInputController(boolean bl) {
        this.initVisible = bl;
    }

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        List<DefaultData> list;
        super.setInputDefinition(inputDefinition);
        this.steppingObjectsList = new ArrayList<Object>();
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.NAVIGATION_STEPPING_EXTRAS_MARKER) && (list = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.NAVIGATION_STEPPING_EXTRAS_MARKER).getSteppingTemplateList()) != null) {
            for (DefaultData defaultData : list) {
                this.addObjectToSteppingObjectList(defaultData);
            }
        }
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        Set<PreferenceId> set = super.getPreferenceIds();
        set.add(PreferenceId.STEPPABLE_CONTROL);
        return set;
    }

    @Override
    public List<Object> getSteppingObjectList() {
        return this.steppingObjectsList;
    }

    @Override
    public void addObjectToSteppingObjectList(Object object) {
        if (!this.steppingObjectsList.contains(object)) {
            this.steppingObjectsList.add(object);
        }
    }

    @Override
    public boolean initSteppingControlVisible() {
        return this.initVisible;
    }

    @Override
    public ElementOccurrenceCount countOccurrences(Object object, ViewerFilter[] viewerFilterArray) {
        List list = (List)this.getTreeInput();
        if (list != null && !list.isEmpty()) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)list.get(0);
            return OccurrenceFinderFactory.getOccurrenceCount(invocationSequenceData, object, viewerFilterArray);
        }
        return ElementOccurrenceCount.emptyElement();
    }

    @Override
    public boolean isElementOccurrenceReachable(Object object, int n, ViewerFilter[] viewerFilterArray) {
        Object object2 = this.getElement(object, n, viewerFilterArray);
        return object2 != null;
    }

    @Override
    public Object getElement(Object object, int n, ViewerFilter[] viewerFilterArray) {
        List list = (List)this.getTreeInput();
        if (list != null && !list.isEmpty()) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)list.get(0);
            return OccurrenceFinderFactory.getOccurrence(invocationSequenceData, object, n, viewerFilterArray);
        }
        return null;
    }

    @Override
    public String getElementTextualRepresentation(Object object) {
        if (object instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            if (0L == sqlStatementData.getId()) {
                return "SQL: " + sqlStatementData.getSql() + " [All]";
            }
            return "SQL: " + sqlStatementData.getSql() + " [Single]";
        }
        if (object instanceof TimerData) {
            TimerData timerData = (TimerData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
            if (0L == timerData.getId()) {
                return String.valueOf(TextFormatter.getMethodString(methodIdent)) + " [All]";
            }
            return String.valueOf(TextFormatter.getMethodString(methodIdent)) + " [Single]";
        }
        if (object instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            if (0L == exceptionSensorData.getId()) {
                return "Exception: " + exceptionSensorData.getThrowableType() + " [All]";
            }
            return "Exception: " + exceptionSensorData.getThrowableType() + " [Single]";
        }
        if (object instanceof InvocationSequenceData) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            if (0L == invocationSequenceData.getId()) {
                return String.valueOf(TextFormatter.getMethodString(methodIdent)) + " [All]";
            }
            return String.valueOf(TextFormatter.getMethodString(methodIdent)) + " [Single]";
        }
        return "";
    }
}

