/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.tree.DeferredTreeViewer;
import info.novatec.inspectit.rcp.editor.tree.TreeSubView;
import info.novatec.inspectit.rcp.editor.tree.input.SteppingTreeInputController;
import info.novatec.inspectit.rcp.util.ElementOccurrenceCount;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SteppingTreeSubView
extends TreeSubView {
    private Composite subComposite;
    private SteppingControl steppingControl;
    private SteppingTreeInputController steppingTreeInputController;

    public SteppingTreeSubView(SteppingTreeInputController steppingTreeInputController) {
        super(steppingTreeInputController);
        this.steppingTreeInputController = steppingTreeInputController;
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.subComposite = formToolkit.createComposite(composite);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.subComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        this.subComposite.setLayoutData((Object)gridData);
        super.createPartControl(this.subComposite, formToolkit);
        gridData = new GridData(4, 4, true, true);
        this.getTreeViewer().getTree().setLayoutData((Object)gridData);
        if (this.steppingControl == null) {
            this.steppingControl = new SteppingControl(this.subComposite, formToolkit, this.steppingTreeInputController.getSteppingObjectList());
        }
        if (this.steppingTreeInputController.initSteppingControlVisible() && this.steppingTreeInputController.getSteppingObjectList() != null && !this.steppingTreeInputController.getSteppingObjectList().isEmpty()) {
            this.steppingControl.showControl();
        }
        this.getTreeViewer().getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SteppingTreeSubView.this.subComposite.notifyListeners(15, null);
            }
        });
    }

    @Override
    public Control getControl() {
        return this.subComposite;
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        super.setDataInput(list);
        this.steppingControl.inputChanged();
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        super.preferenceEventFired(preferenceEvent);
        switch (preferenceEvent.getPreferenceId()) {
            case STEPPABLE_CONTROL: {
                Map<IPreferenceGroup, Object> map = preferenceEvent.getPreferenceMap();
                Object object = map.get(PreferenceId.SteppableControl.BUTTON_STEPPABLE_CONTROL_ID);
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                if (bl.booleanValue()) {
                    this.steppingControl.showControl();
                    break;
                }
                this.steppingControl.hideControl();
                break;
            }
            case FILTERDATATYPE: 
            case INVOCFILTEREXCLUSIVETIME: 
            case INVOCFILTERTOTALTIME: 
            case CLEAR_BUFFER: {
                this.steppingControl.inputChanged();
                break;
            }
        }
    }

    public void addObjectToSteppingControl(Object object) {
        this.steppingTreeInputController.addObjectToSteppingObjectList(object);
        if (this.steppingControl.isControlShown()) {
            this.steppingControl.inputChanged();
            this.steppingControl.selectObject(object);
        } else {
            this.steppingControl.showControl();
        }
    }

    private void setSwitchSteppingControlButtonChecked(boolean bl) {
        this.getRootEditor().getPreferencePanel().setSteppingControlChecked(bl);
    }

    private void expandToObject(Object object, int n) {
        Object object2 = this.steppingTreeInputController.getElement(object, n, this.getTreeViewer().getFilters());
        if (object2 != null) {
            ((DeferredTreeViewer)this.getTreeViewer()).expandToObjectAndSelect(object2, 0);
        }
    }

    private ElementOccurrenceCount countOccurrences(Object object) {
        return this.steppingTreeInputController.countOccurrences(object, this.getTreeViewer().getFilters());
    }

    private boolean isInputSet() {
        List list = (List)this.getTreeViewer().getInput();
        return list != null && !list.isEmpty();
    }

    private class SteppingControl {
        private Composite parent;
        private FormToolkit toolkit;
        private List<Object> steppableObjects;
        private List<Object> objectsInCombo;
        private Composite mainComposite;
        private Combo objectSelection;
        private Button next;
        private Button previous;
        private Button clearAllButton;
        private Label info;
        private boolean controlShown = false;
        private Object selectedObject;
        private int occurrence;
        private int visibleOccurrences;
        private int filteredOccurrences;

        public SteppingControl(Composite composite, FormToolkit formToolkit, List<Object> list) {
            this.parent = composite;
            this.toolkit = formToolkit;
            this.steppableObjects = list;
        }

        private void createPartControl(Composite composite, FormToolkit formToolkit) {
            this.mainComposite = formToolkit.createComposite(composite);
            GridLayout gridLayout = new GridLayout(7, false);
            this.mainComposite.setLayout((Layout)gridLayout);
            this.mainComposite.setLayoutData((Object)new GridData(4, 1, true, false));
            formToolkit.createLabel(this.mainComposite, "Object to locate:");
            this.objectSelection = new Combo(this.mainComposite, 76);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.minimumWidth = 200;
            this.objectSelection.setLayoutData((Object)gridData);
            this.previous = formToolkit.createButton(this.mainComposite, "Previous", 262152);
            this.previous.setEnabled(false);
            this.previous.setImage(InspectIT.getDefault().getImage("/icons/eclipse/prev_nav.gif"));
            this.next = formToolkit.createButton(this.mainComposite, "Next", 262152);
            this.next.setEnabled(false);
            this.next.setImage(InspectIT.getDefault().getImage("/icons/eclipse/next_nav.gif"));
            this.info = formToolkit.createLabel(this.mainComposite, "No invocation loaded");
            Composite composite2 = formToolkit.createComposite(this.mainComposite);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.minimumWidth = 0;
            gridData.heightHint = 0;
            gridData.widthHint = 0;
            composite2.setLayoutData((Object)gridData);
            this.clearAllButton = formToolkit.createButton(this.mainComposite, "", 262152);
            this.clearAllButton.setEnabled(false);
            this.clearAllButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/trash.gif"));
            this.clearAllButton.setToolTipText("Empty steppable objects list");
            this.objectSelection.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    int n = SteppingControl.this.objectSelection.getSelectionIndex();
                    if (n != -1) {
                        Object e = SteppingControl.this.objectsInCombo.get(n);
                        SteppingControl.this.selectedObject = e;
                        if (SteppingTreeSubView.this.isInputSet()) {
                            SteppingControl.this.occurrence = 0;
                            ElementOccurrenceCount elementOccurrenceCount = SteppingTreeSubView.this.countOccurrences(SteppingControl.this.selectedObject);
                            SteppingControl.this.visibleOccurrences = elementOccurrenceCount.getVisibleOccurrences();
                            SteppingControl.this.filteredOccurrences = elementOccurrenceCount.getFilteredOccurrences();
                            if (SteppingControl.this.visibleOccurrences > 0) {
                                SteppingTreeSubView steppingTreeSubView = SteppingTreeSubView.this;
                                Object object = SteppingControl.this.selectedObject;
                                SteppingControl steppingControl = SteppingControl.this;
                                int n2 = steppingControl.occurrence + 1;
                                steppingControl.occurrence = n2;
                                steppingTreeSubView.expandToObject(object, n2);
                            }
                            if (SteppingControl.this.visibleOccurrences <= SteppingControl.this.occurrence) {
                                SteppingControl.this.next.setEnabled(false);
                            } else {
                                SteppingControl.this.next.setEnabled(true);
                            }
                            if (SteppingControl.this.occurrence <= 1) {
                                SteppingControl.this.previous.setEnabled(false);
                            } else {
                                SteppingControl.this.previous.setEnabled(true);
                            }
                        }
                    } else {
                        SteppingControl.this.next.setEnabled(false);
                        SteppingControl.this.previous.setEnabled(false);
                    }
                    SteppingControl.this.updateInfoBox();
                }
            });
            this.next.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SteppingTreeSubView steppingTreeSubView = SteppingTreeSubView.this;
                    Object object = SteppingControl.this.selectedObject;
                    SteppingControl steppingControl = SteppingControl.this;
                    int n = steppingControl.occurrence + 1;
                    steppingControl.occurrence = n;
                    steppingTreeSubView.expandToObject(object, n);
                    if (SteppingControl.this.visibleOccurrences <= SteppingControl.this.occurrence) {
                        SteppingControl.this.next.setEnabled(false);
                    }
                    if (SteppingControl.this.occurrence <= 1) {
                        SteppingControl.this.previous.setEnabled(false);
                    } else {
                        SteppingControl.this.previous.setEnabled(true);
                    }
                    SteppingControl.this.updateInfoBox();
                }
            });
            this.previous.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SteppingTreeSubView steppingTreeSubView = SteppingTreeSubView.this;
                    Object object = SteppingControl.this.selectedObject;
                    SteppingControl steppingControl = SteppingControl.this;
                    int n = steppingControl.occurrence - 1;
                    steppingControl.occurrence = n;
                    steppingTreeSubView.expandToObject(object, n);
                    SteppingControl.this.next.setEnabled(true);
                    if (SteppingControl.this.occurrence <= 1) {
                        SteppingControl.this.previous.setEnabled(false);
                    }
                    SteppingControl.this.updateInfoBox();
                }
            });
            this.clearAllButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SteppingControl.this.clearAll();
                }
            });
            this.controlShown = true;
        }

        private void clearAll() {
            this.steppableObjects.clear();
            this.objectSelection.removeAll();
            this.objectsInCombo.clear();
            this.selectedObject = null;
            this.occurrence = 0;
            this.inputChanged();
        }

        private String getTextualString(Object object) {
            String string = SteppingTreeSubView.this.steppingTreeInputController.getElementTextualRepresentation(object);
            if (string.length() > 120) {
                string = String.valueOf(string.substring(0, 118)) + "..";
            }
            ElementOccurrenceCount elementOccurrenceCount = SteppingTreeSubView.this.countOccurrences(object);
            return String.valueOf(string) + " (" + elementOccurrenceCount.getVisibleOccurrences() + " visible, " + elementOccurrenceCount.getFilteredOccurrences() + " filtered)";
        }

        public void selectObject(Object object) {
            int n;
            if (this.controlShown && (n = this.objectsInCombo.indexOf(object)) != -1) {
                this.objectSelection.select(n);
            }
        }

        public void hideControl() {
            if (this.controlShown) {
                this.mainComposite.dispose();
                SteppingTreeSubView.this.subComposite.layout();
                this.controlShown = false;
                SteppingTreeSubView.this.setSwitchSteppingControlButtonChecked(false);
            }
        }

        public void showControl() {
            if (!this.controlShown) {
                this.createPartControl(this.parent, this.toolkit);
                SteppingTreeSubView.this.subComposite.layout();
                this.controlShown = true;
                this.inputChanged();
                SteppingTreeSubView.this.setSwitchSteppingControlButtonChecked(true);
            }
        }

        public void inputChanged() {
            if (this.controlShown) {
                if (SteppingTreeSubView.this.isInputSet()) {
                    this.objectsInCombo = this.steppableObjects;
                    this.objectSelection.removeAll();
                    if (!this.objectsInCombo.isEmpty()) {
                        this.clearAllButton.setEnabled(true);
                        for (Object object : this.objectsInCombo) {
                            this.objectSelection.add(this.getTextualString(object));
                        }
                        this.objectSelection.pack(true);
                        if (this.selectedObject != null && this.objectsInCombo.contains(this.selectedObject)) {
                            this.objectSelection.select(this.objectsInCombo.indexOf(this.selectedObject));
                        } else {
                            this.objectSelection.select(0);
                        }
                    } else {
                        this.next.setEnabled(false);
                        this.previous.setEnabled(false);
                        this.clearAllButton.setEnabled(false);
                        this.updateInfoBox();
                    }
                } else {
                    this.objectSelection.removeAll();
                    this.next.setEnabled(false);
                    this.previous.setEnabled(false);
                    this.updateInfoBox();
                }
                this.mainComposite.layout();
            }
        }

        private void updateInfoBox() {
            if (this.controlShown) {
                String string = "";
                if (SteppingTreeSubView.this.isInputSet() && this.objectSelection.getSelectionIndex() != -1) {
                    if (this.occurrence == 0 && this.visibleOccurrences != 0) {
                        string = "Found " + this.visibleOccurrences + " occurrence";
                        if (this.visibleOccurrences > 1) {
                            string = String.valueOf(string) + "s";
                        }
                    } else {
                        string = this.occurrence != 0 ? String.valueOf(this.occurrence) + "/" + this.visibleOccurrences : "No occurrences found";
                    }
                    if (this.filteredOccurrences > 0) {
                        string = String.valueOf(string) + " (" + this.filteredOccurrences + " filtered out)";
                    }
                } else {
                    string = this.objectSelection.getItemCount() == 0 ? "No object to locate" : "No invocation loaded";
                }
                this.info.setText(string);
                this.mainComposite.layout();
            }
        }

        public boolean isControlShown() {
            return this.controlShown;
        }
    }
}

