/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ThreadInformationData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ThreadsInputController
extends AbstractTextInputController {
    public static final String ID = "inspectit.subview.text.threads";
    private static final String SECTION_THREADS = "Threads";
    private ThreadInformationData threadObj;
    private Label liveThreadCount;
    private Label daemonThreadCount;
    private Label totalStartedThreadCount;
    private Label peakThreadCount;
    private IGlobalDataAccessService dataAccessService;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.threadObj = new ThreadInformationData();
        this.threadObj.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.addSection(composite, formToolkit, SECTION_THREADS);
        if (this.sections.containsKey(SECTION_THREADS)) {
            this.addItemToSection(formToolkit, SECTION_THREADS, "Live threads: ");
            this.liveThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), "n/a", 16384);
            this.liveThreadCount.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_THREADS, "Daemon threads: ");
            this.daemonThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), "n/a", 16384);
            this.daemonThreadCount.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_THREADS, "Peak: ");
            this.peakThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), "n/a", 16384);
            this.peakThreadCount.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_THREADS, "Total threads started: ");
            this.totalStartedThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), "n/a", 16384);
            this.totalStartedThreadCount.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    @Override
    public void doRefresh() {
        final ThreadInformationData threadInformationData = (ThreadInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.threadObj);
        if (threadInformationData != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int n = threadInformationData.getCount();
                    ThreadsInputController.this.liveThreadCount.setText(NumberFormatter.formatInteger(threadInformationData.getTotalThreadCount() / n));
                    ThreadsInputController.this.daemonThreadCount.setText(NumberFormatter.formatInteger(threadInformationData.getTotalDaemonThreadCount() / n));
                    ThreadsInputController.this.totalStartedThreadCount.setText(NumberFormatter.formatLong(threadInformationData.getTotalTotalStartedThreadCount() / (long)n));
                    ThreadsInputController.this.peakThreadCount.setText(NumberFormatter.formatInteger(threadInformationData.getTotalPeakThreadCount() / n));
                }
            });
        }
    }

    @Override
    public void dispose() {
    }
}

