/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IExceptionDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.InvocationAwareDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.MethodSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.RemoteTableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UngroupedExceptionOverviewInputController
extends AbstractTableInputController {
    public static final String ID = "inspectit.subview.table.ungroupedexceptionoverview";
    private final ResultComparator<ExceptionSensorData> defaultComparator = new ResultComparator((IDataComparator)DefaultDataComparatorEnum.TIMESTAMP, false);
    private ExceptionSensorData template;
    private List<ExceptionSensorData> exceptionSensorData = new ArrayList<ExceptionSensorData>();
    private int limit = PreferencesUtils.getIntValue("ITEMS_COUNT_TO_SHOW");
    private Date fromDate;
    private Date toDate;
    private ICachedDataService cachedDataService;
    private IExceptionDataAccessService dataAccessService;
    private ResultComparator<ExceptionSensorData> resultComparator = this.defaultComparator;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new ExceptionSensorData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.template.setMethodIdent(inputDefinition.getIdDefinition().getMethodId());
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.EXCEPTION_TYPE_EXTRAS_MARKER)) {
            String string = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.EXCEPTION_TYPE_EXTRAS_MARKER).getThrowableType();
            this.template.setThrowableType(string);
        }
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getExceptionDataAccessService();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public Object getTableInput() {
        return this.exceptionSensorData;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new UngroupedExceptionOverviewContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new UngroupedExceptionOverviewLabelProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        RemoteTableViewerComparator<ExceptionSensorData> remoteTableViewerComparator = new RemoteTableViewerComparator<ExceptionSensorData>(){

            @Override
            protected void sortRemotely(ResultComparator<ExceptionSensorData> resultComparator) {
                if (resultComparator != null) {
                    UngroupedExceptionOverviewInputController.this.resultComparator = resultComparator;
                } else {
                    UngroupedExceptionOverviewInputController.this.resultComparator = UngroupedExceptionOverviewInputController.this.defaultComparator;
                }
                UngroupedExceptionOverviewInputController.this.loadDataFromService();
            }
        };
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator);
            remoteTableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return remoteTableViewerComparator;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.ITEMCOUNT);
        enumSet.add(PreferenceId.TIMELINE);
        return enumSet;
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        return list.isEmpty();
    }

    @Override
    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case TIMELINE: {
                Map<IPreferenceGroup, Object> map = preferenceEvent.getPreferenceMap();
                if (map.containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                    this.fromDate = (Date)map.get(PreferenceId.TimeLine.FROM_DATE_ID);
                }
                if (!map.containsKey(PreferenceId.TimeLine.TO_DATE_ID)) break;
                this.toDate = (Date)map.get(PreferenceId.TimeLine.TO_DATE_ID);
                break;
            }
        }
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Updating the Ungrouped Exception Overview", -1);
        iProgressMonitor.subTask("Retrieving the Ungrouped Exception Overview");
        this.loadDataFromService();
        iProgressMonitor.done();
    }

    private void loadDataFromService() {
        List list = null;
        list = this.fromDate != null && this.toDate != null ? this.dataAccessService.getUngroupedExceptionOverview(this.template, this.limit, this.fromDate, this.toDate, this.resultComparator) : this.dataAccessService.getUngroupedExceptionOverview(this.template, this.limit, this.resultComparator);
        this.exceptionSensorData.clear();
        if (list != null) {
            this.exceptionSensorData.addAll(list);
        }
    }

    @Override
    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        final StructuredSelection structuredSelection = (StructuredSelection)doubleClickEvent.getSelection();
        if (!structuredSelection.isEmpty()) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask("Retrieving Exception Tree", -1);
                        ExceptionSensorData exceptionSensorData = (ExceptionSensorData)structuredSelection.getFirstElement();
                        List list = UngroupedExceptionOverviewInputController.this.dataAccessService.getExceptionTree(exceptionSensorData);
                        final ArrayList<ExceptionSensorData> arrayList = new ArrayList<ExceptionSensorData>();
                        arrayList.add((ExceptionSensorData)list.get(0));
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                                IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                                iRootEditor.setDataInput(arrayList);
                            }
                        });
                        iProgressMonitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Error", (String)invocationTargetException.getCause().toString());
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Cancelled", (String)interruptedException.getCause().toString());
            }
        }
    }

    private StyledString getStyledTextForColumn(ExceptionSensorData exceptionSensorData, MethodIdent methodIdent, Column column) {
        switch (column) {
            case PACKAGE: {
                if (methodIdent.getPackageName() != null && !methodIdent.getPackageName().equals("")) {
                    return new StyledString(methodIdent.getPackageName());
                }
                return new StyledString("(default)");
            }
            case CLASS: {
                return new StyledString(methodIdent.getClassName());
            }
            case TIMESTAMP: {
                return new StyledString(NumberFormatter.formatTime(exceptionSensorData.getTimeStamp()));
            }
            case INVOCATION_AFFILLIATION: {
                int n = (int)(exceptionSensorData.getInvocationAffiliationPercentage() * 100.0);
                int n2 = 0;
                if (exceptionSensorData.getInvocationParentsIdSet() != null) {
                    n2 = exceptionSensorData.getInvocationParentsIdSet().size();
                }
                return TextFormatter.getInvocationAffilliationPercentageString(n, n2);
            }
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            StringBuilder stringBuilder = new StringBuilder();
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(exceptionSensorData, methodIdent, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(exceptionSensorData, methodIdent, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    private static enum Column {
        TIMESTAMP("Timestamp", 150, "/icons/eclipse/dates.gif", (IDataComparator<? super ExceptionSensorData>)DefaultDataComparatorEnum.TIMESTAMP),
        CLASS("Class", 250, "/icons/eclipse/class_obj.gif", (IDataComparator<? super ExceptionSensorData>)MethodSensorDataComparatorEnum.CLASS),
        PACKAGE("Package", 250, "/icons/eclipse/package_obj.gif", (IDataComparator<? super ExceptionSensorData>)MethodSensorDataComparatorEnum.PACKAGE),
        INVOCATION_AFFILLIATION("In Invocations", 120, "/icons/fugue/arrow-switch.png", (IDataComparator<? super ExceptionSensorData>)InvocationAwareDataComparatorEnum.INVOCATION_AFFILIATION);

        private String name;
        private int width;
        private Image image;
        private IDataComparator<? super ExceptionSensorData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super ExceptionSensorData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private static final class UngroupedExceptionOverviewContentProvider
    implements IStructuredContentProvider {
        private UngroupedExceptionOverviewContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            return list.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private final class UngroupedExceptionOverviewLabelProvider
    extends StyledCellIndexLabelProvider {
        private UngroupedExceptionOverviewLabelProvider() {
        }

        @Override
        protected StyledString getStyledText(Object object, int n) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            MethodIdent methodIdent = UngroupedExceptionOverviewInputController.this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            Column column = Column.fromOrd(n);
            return UngroupedExceptionOverviewInputController.this.getStyledTextForColumn(exceptionSensorData, methodIdent, column);
        }
    }
}

