/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IJmxDataAccessService;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.JmxDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;

public class JmxSensorDataInputController
extends AbstractTableInputController {
    private ICachedDataService cachedDataService;
    private List<JmxSensorValueData> jmxDataList = new ArrayList<JmxSensorValueData>(0);
    private IJmxDataAccessService jmxDataAccessService;
    private JmxSensorValueData template;
    private final StyledString emptyStyledString = new StyledString();
    private Date fromDate = null;
    private Date toDate = null;
    private boolean autoUpdate = false;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new JmxSensorValueData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.template.setJmxSensorDefinitionDataIdentId(inputDefinition.getIdDefinition().getJmxDefinitionId());
        this.jmxDataAccessService = inputDefinition.getRepositoryDefinition().getJmxDataAccessService();
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.TIMELINE);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case TIMELINE: {
                if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                    this.fromDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.FROM_DATE_ID);
                }
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.TO_DATE_ID)) break;
                this.toDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.TO_DATE_ID);
                break;
            }
            case LIVEMODE: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.LiveMode.BUTTON_LIVE_ID)) break;
                this.autoUpdate = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
                break;
            }
        }
    }

    @Override
    public Object getTableInput() {
        return this.jmxDataList;
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Updating JMX Overview", -1);
        iProgressMonitor.subTask("Retrieving the JMX Overview");
        List list = this.autoUpdate || this.fromDate == null || this.toDate == null ? this.jmxDataAccessService.getJmxDataOverview(this.template) : this.jmxDataAccessService.getJmxDataOverview(this.template, this.fromDate, this.toDate);
        this.jmxDataList.clear();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.jmxDataList.addAll(list);
        }
        iProgressMonitor.done();
    }

    @Override
    public ViewerComparator getComparator() {
        TableViewerComparator tableViewerComparator = new TableViewerComparator();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator, this.cachedDataService);
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new LabelProvider();
    }

    private StyledString getStyledTextForColumn(JmxDefinitionDataIdent jmxDefinitionDataIdent, JmxSensorValueData jmxSensorValueData, Column column) {
        switch (column) {
            case DOMAINNAME: {
                return new StyledString(jmxDefinitionDataIdent.getDerivedDomainName());
            }
            case TYPENAME: {
                return new StyledString(jmxDefinitionDataIdent.getDerivedTypeName());
            }
            case ATTRIBUTE: {
                return new StyledString(jmxDefinitionDataIdent.getmBeanAttributeName());
            }
            case TIMESTAMP: {
                return new StyledString(NumberFormatter.formatTime(jmxSensorValueData.getTimeStamp()));
            }
            case VALUE: {
                return new StyledString(jmxSensorValueData.getValue());
            }
            case CHARTING: 
            case ISREADABLE: 
            case ISWRITEABLE: {
                return this.emptyStyledString;
            }
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof JmxSensorValueData) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)object;
            StringBuilder stringBuilder = new StringBuilder();
            JmxDefinitionDataIdent jmxDefinitionDataIdent = this.cachedDataService.getJmxDefinitionDataIdentForId(jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(jmxDefinitionDataIdent, jmxSensorValueData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof JmxSensorValueData) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)object;
            JmxDefinitionDataIdent jmxDefinitionDataIdent = this.cachedDataService.getJmxDefinitionDataIdentForId(jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(jmxDefinitionDataIdent, jmxSensorValueData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.MASTER;
    }

    private static enum Column {
        CHARTING("Charting", 20, null, (IDataComparator<? super JmxSensorValueData>)JmxDataComparatorEnum.CHARTING),
        DOMAINNAME("Domain", 250, "/icons/eclipse/package_obj.gif", (IDataComparator<? super JmxSensorValueData>)JmxDataComparatorEnum.DERIVED_DOMAINNAME),
        TYPENAME("Type", 250, "/icons/fugue/book.png", (IDataComparator<? super JmxSensorValueData>)JmxDataComparatorEnum.DERIVED_TYPENAME),
        ATTRIBUTE("Attribute", 300, "/icons/fugue/blue-document-table.png", (IDataComparator<? super JmxSensorValueData>)JmxDataComparatorEnum.ATTRIBUTENAME),
        TIMESTAMP("Timestamp", 100, "/icons/eclipse/dates.gif", (IDataComparator<? super JmxSensorValueData>)DefaultDataComparatorEnum.TIMESTAMP),
        VALUE("Value", 150, null, (IDataComparator<? super JmxSensorValueData>)JmxDataComparatorEnum.VALUE),
        ISREADABLE("Readable", 100, null, (IDataComparator<? super JmxSensorValueData>)JmxDataComparatorEnum.READABLE),
        ISWRITEABLE("Writeable", 100, null, (IDataComparator<? super JmxSensorValueData>)JmxDataComparatorEnum.WRITABLE);

        private String name;
        private int width;
        private Image image;
        private IDataComparator<? super JmxSensorValueData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super JmxSensorValueData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class LabelProvider
    extends StyledCellIndexLabelProvider {
        private LabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)object;
            Column column = Column.fromOrd(n);
            JmxDefinitionDataIdent jmxDefinitionDataIdent = JmxSensorDataInputController.this.cachedDataService.getJmxDefinitionDataIdentForId(jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            return JmxSensorDataInputController.this.getStyledTextForColumn(jmxDefinitionDataIdent, jmxSensorValueData, column);
        }

        @Override
        protected Image getColumnImage(Object object, int n) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)object;
            Column column = Column.fromOrd(n);
            JmxDefinitionDataIdent jmxDefinitionDataIdent = JmxSensorDataInputController.this.cachedDataService.getJmxDefinitionDataIdentForId(jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            switch (column) {
                case ISREADABLE: {
                    if (jmxDefinitionDataIdent.getmBeanAttributeIsReadable().booleanValue()) {
                        return InspectIT.getDefault().getImage("/icons/eclipse/complete_status.gif");
                    }
                    return InspectIT.getDefault().getImage("/icons/eclipse/remove_co.gif");
                }
                case ISWRITEABLE: {
                    if (jmxDefinitionDataIdent.getmBeanAttributeIsWritable().booleanValue()) {
                        return InspectIT.getDefault().getImage("/icons/eclipse/complete_status.gif");
                    }
                    return InspectIT.getDefault().getImage("/icons/eclipse/remove_co.gif");
                }
                case CHARTING: {
                    if (!jmxSensorValueData.isBooleanOrNumeric()) break;
                    return InspectIT.getDefault().getImage("/icons/eclipse/graph_pie.gif");
                }
            }
            return super.getColumnImage(object, n);
        }
    }
}

