/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IInvocationDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.InvocationSequenceDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.MethodSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.InvocationSequenceDataHelper;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.RemoteTableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.tooltip.IColumnToolTipProvider;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class InvocOverviewInputController
extends AbstractTableInputController {
    public static final String ID = "inspectit.subview.table.invocoverview";
    private final ResultComparator<InvocationSequenceData> defaultComparator = new ResultComparator((IDataComparator)DefaultDataComparatorEnum.TIMESTAMP, false);
    private InvocationSequenceData template;
    private List<InvocationSequenceData> invocationSequenceData = new ArrayList<InvocationSequenceData>();
    private int limit = PreferencesUtils.getIntValue("ITEMS_COUNT_TO_SHOW");
    private IInvocationDataAccessService dataAccessService;
    private ICachedDataService cachedDataService;
    private Date fromDate = null;
    private Date toDate = null;
    private boolean autoUpdate = false;
    private final StyledString emptyStyledString = new StyledString();
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private ResultComparator<InvocationSequenceData> resultComparator = this.defaultComparator;

    protected List<InvocationSequenceData> getInvocationSequenceData() {
        return this.invocationSequenceData;
    }

    protected IInvocationDataAccessService getDataAccessService() {
        return this.dataAccessService;
    }

    protected ICachedDataService getCachedDataService() {
        return this.cachedDataService;
    }

    protected int getLimit() {
        return this.limit;
    }

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new InvocationSequenceData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.template.setMethodIdent(inputDefinition.getIdDefinition().getMethodId());
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getInvocationDataAccessService();
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public Object getTableInput() {
        return this.invocationSequenceData;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new InvocOverviewContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new InvocOverviewLabelProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        RemoteTableViewerComparator<InvocationSequenceData> remoteTableViewerComparator = new RemoteTableViewerComparator<InvocationSequenceData>(){

            @Override
            protected void sortRemotely(ResultComparator<InvocationSequenceData> resultComparator) {
                if (resultComparator != null) {
                    InvocOverviewInputController.this.resultComparator = resultComparator;
                } else {
                    InvocOverviewInputController.this.resultComparator = InvocOverviewInputController.this.defaultComparator;
                }
                InvocOverviewInputController.this.loadDataFromService();
            }
        };
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator);
            remoteTableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return remoteTableViewerComparator;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.ITEMCOUNT);
        enumSet.add(PreferenceId.TIMELINE);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case TIMELINE: {
                if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                    this.fromDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.FROM_DATE_ID);
                }
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.TO_DATE_ID)) break;
                this.toDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.TO_DATE_ID);
                break;
            }
            case LIVEMODE: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.LiveMode.BUTTON_LIVE_ID)) break;
                this.autoUpdate = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
                break;
            }
        }
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        return list.isEmpty();
    }

    @Override
    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Updating Invocation Overview", -1);
        iProgressMonitor.subTask("Retrieving the Invocation Overview");
        this.loadDataFromService();
        iProgressMonitor.done();
    }

    private void loadDataFromService() {
        List list = !this.autoUpdate ? (this.template.getMethodIdent() != 0L ? this.dataAccessService.getInvocationSequenceOverview(this.template.getPlatformIdent(), this.template.getMethodIdent(), this.limit, this.fromDate, this.toDate, this.resultComparator) : this.dataAccessService.getInvocationSequenceOverview(this.template.getPlatformIdent(), this.limit, this.fromDate, this.toDate, this.resultComparator)) : (this.template.getMethodIdent() != 0L ? this.dataAccessService.getInvocationSequenceOverview(this.template.getPlatformIdent(), this.template.getMethodIdent(), this.limit, this.resultComparator) : this.dataAccessService.getInvocationSequenceOverview(this.template.getPlatformIdent(), this.limit, this.resultComparator));
        this.invocationSequenceData.clear();
        if (!list.isEmpty()) {
            this.invocationSequenceData.addAll(list);
        }
    }

    @Override
    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        final StructuredSelection structuredSelection = (StructuredSelection)doubleClickEvent.getSelection();
        if (!structuredSelection.isEmpty()) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask("Retrieving Invocation detail data", -1);
                        InvocationSequenceData invocationSequenceData = (InvocationSequenceData)structuredSelection.getFirstElement();
                        InvocationSequenceData invocationSequenceData2 = InvocOverviewInputController.this.dataAccessService.getInvocationSequenceDetail(invocationSequenceData);
                        final ArrayList<InvocationSequenceData> arrayList = new ArrayList<InvocationSequenceData>();
                        arrayList.add(invocationSequenceData2);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                                IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                                iRootEditor.setDataInput(arrayList);
                            }
                        });
                        iProgressMonitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Error", (String)invocationTargetException.getCause().toString());
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Cancelled", (String)interruptedException.getCause().toString());
            }
        }
    }

    private StyledString getStyledTextForColumn(InvocationSequenceData invocationSequenceData, MethodIdent methodIdent, Column column) {
        switch (column) {
            case NESTED_DATA: {
                return this.emptyStyledString;
            }
            case TIME: {
                return new StyledString(NumberFormatter.formatTimeWithMillis(invocationSequenceData.getTimeStamp()));
            }
            case METHOD: {
                return TextFormatter.getStyledMethodString(methodIdent);
            }
            case DURATION: {
                if (InvocationSequenceDataHelper.hasTimerData((InvocationSequenceData)invocationSequenceData)) {
                    return new StyledString(NumberFormatter.formatDouble(invocationSequenceData.getTimerData().getDuration()));
                }
                return new StyledString(NumberFormatter.formatDouble(invocationSequenceData.getDuration()));
            }
            case COUNT: {
                return new StyledString(NumberFormatter.formatLong(invocationSequenceData.getChildCount()));
            }
            case URI: {
                if (InvocationSequenceDataHelper.hasHttpTimerData((InvocationSequenceData)invocationSequenceData)) {
                    String string = ((HttpTimerData)invocationSequenceData.getTimerData()).getHttpInfo().getUri();
                    if (string != null) {
                        return new StyledString(string);
                    }
                    return this.emptyStyledString;
                }
                return this.emptyStyledString;
            }
            case USE_CASE: {
                if (InvocationSequenceDataHelper.hasHttpTimerData((InvocationSequenceData)invocationSequenceData)) {
                    String string = ((HttpTimerData)invocationSequenceData.getTimerData()).getHttpInfo().getInspectItTaggingHeaderValue();
                    if (string != null) {
                        return new StyledString(string);
                    }
                    return this.emptyStyledString;
                }
                return this.emptyStyledString;
            }
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof InvocationSequenceData) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            StringBuilder stringBuilder = new StringBuilder();
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(invocationSequenceData, methodIdent, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof InvocationSequenceData) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(invocationSequenceData, methodIdent, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    public ResultComparator<InvocationSequenceData> getResultComparator() {
        return this.resultComparator;
    }

    @Override
    public void dispose() {
        this.resourceManager.dispose();
    }

    protected static enum Column {
        NESTED_DATA("Nested Data", 40, null, (IDataComparator<? super InvocationSequenceData>)InvocationSequenceDataComparatorEnum.NESTED_DATA),
        TIME("Start Time", 150, "/icons/eclipse/dates.gif", (IDataComparator<? super InvocationSequenceData>)DefaultDataComparatorEnum.TIMESTAMP),
        METHOD("Method", 550, "/icons/eclipse/method.gif", (IDataComparator<? super InvocationSequenceData>)MethodSensorDataComparatorEnum.METHOD),
        DURATION("Duration (ms)", 100, "/icons/eclipse/time.gif", (IDataComparator<? super InvocationSequenceData>)InvocationSequenceDataComparatorEnum.DURATION),
        COUNT("Child Count", 100, null, (IDataComparator<? super InvocationSequenceData>)InvocationSequenceDataComparatorEnum.CHILD_COUNT),
        URI("URI", 150, null, (IDataComparator<? super InvocationSequenceData>)InvocationSequenceDataComparatorEnum.URI),
        USE_CASE("Use case", 100, null, (IDataComparator<? super InvocationSequenceData>)InvocationSequenceDataComparatorEnum.USE_CASE);

        private String name;
        private int width;
        private Image image;
        protected IDataComparator<? super InvocationSequenceData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super InvocationSequenceData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private static final class InvocOverviewContentProvider
    implements IStructuredContentProvider {
        private InvocOverviewContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            return list.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private final class InvocOverviewLabelProvider
    extends StyledCellIndexLabelProvider
    implements IColumnToolTipProvider {
        private InvocOverviewLabelProvider() {
        }

        @Override
        protected StyledString getStyledText(Object object, int n) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            MethodIdent methodIdent = InvocOverviewInputController.this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            Column column = Column.fromOrd(n);
            return InvocOverviewInputController.this.getStyledTextForColumn(invocationSequenceData, methodIdent, column);
        }

        @Override
        protected Image getColumnImage(Object object, int n) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            Column column = Column.fromOrd(n);
            switch (column) {
                case NESTED_DATA: {
                    if (InvocationSequenceDataHelper.hasNestedSqlStatements((InvocationSequenceData)invocationSequenceData) && InvocationSequenceDataHelper.hasNestedExceptions((InvocationSequenceData)invocationSequenceData)) {
                        return ImageFormatter.getCombinedImage((ResourceManager)InvocOverviewInputController.this.resourceManager, 256, InspectIT.getDefault().getImageDescriptor("/icons/fugue/database-sql.png"), InspectIT.getDefault().getImageDescriptor("/icons/eclipse/exceptiontracer.gif"));
                    }
                    if (InvocationSequenceDataHelper.hasNestedSqlStatements((InvocationSequenceData)invocationSequenceData)) {
                        return InspectIT.getDefault().getImage("/icons/fugue/database-sql.png");
                    }
                    if (InvocationSequenceDataHelper.hasNestedExceptions((InvocationSequenceData)invocationSequenceData)) {
                        return InspectIT.getDefault().getImage("/icons/eclipse/exceptiontracer.gif");
                    }
                    return super.getColumnImage(object, n);
                }
            }
            return super.getColumnImage(object, n);
        }

        @Override
        public String getToolTipText(Object object, int n) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            Column column = Column.fromOrd(n);
            switch (column) {
                case NESTED_DATA: {
                    if (InvocationSequenceDataHelper.hasNestedSqlStatements((InvocationSequenceData)invocationSequenceData) || InvocationSequenceDataHelper.hasNestedExceptions((InvocationSequenceData)invocationSequenceData)) {
                        StringBuilder stringBuilder = new StringBuilder("This invocation contains:");
                        if (InvocationSequenceDataHelper.hasNestedSqlStatements((InvocationSequenceData)invocationSequenceData)) {
                            stringBuilder.append("\n - SQL statement(s)");
                        }
                        if (InvocationSequenceDataHelper.hasNestedExceptions((InvocationSequenceData)invocationSequenceData)) {
                            stringBuilder.append("\n - Exception(s)");
                        }
                        return stringBuilder.toString();
                    }
                    return super.getToolTipText(object, n);
                }
            }
            return null;
        }
    }
}

