/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.search.factory;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.AggregatedHttpTimerData;
import info.novatec.inspectit.communication.data.AggregatedSqlStatementData;
import info.novatec.inspectit.communication.data.AggregatedTimerData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchCriteria;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public final class SearchFactory {
    private static TimerSearchFinder timerSearchFinder = new TimerSearchFinder();
    private static SqlSearchFinder sqlSearchFinder = new SqlSearchFinder();
    private static HttpSearchFinder httpSearchFinder = new HttpSearchFinder();
    private static ExceptionSearchFinder exceptionSearchFinder = new ExceptionSearchFinder();
    private static InvocationSearchFinder invocationSearchFinder = new InvocationSearchFinder();
    private static JmxSearchFinder jmxSearchFinder = new JmxSearchFinder();

    private SearchFactory() {
    }

    public static boolean isSearchCompatible(Object object, SearchCriteria searchCriteria, RepositoryDefinition repositoryDefinition) {
        if (object == null) {
            return false;
        }
        if (TimerData.class.equals(object.getClass()) || AggregatedTimerData.class.equals(object.getClass())) {
            return timerSearchFinder.isSearchCompatible((TimerData)object, searchCriteria, repositoryDefinition);
        }
        if (SqlStatementData.class.equals(object.getClass()) || AggregatedSqlStatementData.class.equals(object.getClass())) {
            return sqlSearchFinder.isSearchCompatible((SqlStatementData)object, searchCriteria, repositoryDefinition);
        }
        if (HttpTimerData.class.equals(object.getClass()) || AggregatedHttpTimerData.class.equals(object.getClass())) {
            return httpSearchFinder.isSearchCompatible((HttpTimerData)object, searchCriteria, repositoryDefinition);
        }
        if (ExceptionSensorData.class.equals(object.getClass()) || AggregatedExceptionSensorData.class.equals(object.getClass())) {
            return exceptionSearchFinder.isSearchCompatible((ExceptionSensorData)object, searchCriteria, repositoryDefinition);
        }
        if (InvocationSequenceData.class.equals(object.getClass())) {
            return invocationSearchFinder.isSearchCompatible((InvocationSequenceData)object, searchCriteria, repositoryDefinition);
        }
        if (JmxSensorValueData.class.equals(object.getClass())) {
            return jmxSearchFinder.isSearchCompatible((JmxSensorValueData)object, searchCriteria, repositoryDefinition);
        }
        return false;
    }

    private static abstract class AbstractSearchFinder<E> {
        private AbstractSearchFinder() {
        }

        public abstract boolean isSearchCompatible(E var1, SearchCriteria var2, RepositoryDefinition var3);

        protected boolean stringMatches(String string, SearchCriteria searchCriteria) {
            if (string != null) {
                if (!searchCriteria.isCaseSensitive()) {
                    return string.toUpperCase().indexOf(searchCriteria.getSearchStringUpperCase()) != -1;
                }
                return string.indexOf(searchCriteria.getSearchString()) != -1;
            }
            return false;
        }

        protected boolean isSearchCompatible(MethodIdent methodIdent, SearchCriteria searchCriteria) {
            if (methodIdent == null) {
                return false;
            }
            if (this.stringMatches(methodIdent.getFQN(), searchCriteria)) {
                return true;
            }
            if (this.stringMatches(methodIdent.getMethodName(), searchCriteria)) {
                return true;
            }
            if (methodIdent.getParameters() != null && !methodIdent.getParameters().isEmpty()) {
                for (String string : methodIdent.getParameters()) {
                    if (!this.stringMatches(string, searchCriteria)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class ExceptionSearchFinder
    extends AbstractSearchFinder<ExceptionSensorData> {
        private ExceptionSearchFinder() {
        }

        @Override
        public boolean isSearchCompatible(ExceptionSensorData exceptionSensorData, SearchCriteria searchCriteria, RepositoryDefinition repositoryDefinition) {
            if (this.stringMatches(exceptionSensorData.getCause(), searchCriteria)) {
                return true;
            }
            if (this.stringMatches(exceptionSensorData.getErrorMessage(), searchCriteria)) {
                return true;
            }
            if (this.stringMatches(exceptionSensorData.getStackTrace(), searchCriteria)) {
                return true;
            }
            if (this.stringMatches(exceptionSensorData.getThrowableType(), searchCriteria)) {
                return true;
            }
            MethodIdent methodIdent = repositoryDefinition.getCachedDataService().getMethodIdentForId(exceptionSensorData.getMethodIdent());
            return super.isSearchCompatible(methodIdent, searchCriteria);
        }
    }

    private static class HttpSearchFinder
    extends AbstractSearchFinder<HttpTimerData> {
        private HttpSearchFinder() {
        }

        @Override
        public boolean isSearchCompatible(HttpTimerData httpTimerData, SearchCriteria searchCriteria, RepositoryDefinition repositoryDefinition) {
            if (this.stringMatches(httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue(), searchCriteria)) {
                return true;
            }
            if (this.stringMatches(httpTimerData.getHttpInfo().getRequestMethod(), searchCriteria)) {
                return true;
            }
            if (this.stringMatches(httpTimerData.getHttpInfo().getUri(), searchCriteria)) {
                return true;
            }
            if (MapUtils.isNotEmpty((Map)httpTimerData.getAttributes())) {
                for (Map.Entry object2 : httpTimerData.getAttributes().entrySet()) {
                    if (!this.stringMatches((String)object2.getKey(), searchCriteria) && !this.stringMatches((String)object2.getValue(), searchCriteria)) continue;
                    return true;
                }
            }
            if (MapUtils.isNotEmpty((Map)httpTimerData.getHeaders())) {
                for (Map.Entry entry : httpTimerData.getHeaders().entrySet()) {
                    if (!this.stringMatches((String)entry.getKey(), searchCriteria) && !this.stringMatches((String)entry.getValue(), searchCriteria)) continue;
                    return true;
                }
            }
            if (MapUtils.isNotEmpty((Map)httpTimerData.getParameters())) {
                for (Map.Entry entry : httpTimerData.getParameters().entrySet()) {
                    if (this.stringMatches((String)entry.getKey(), searchCriteria)) {
                        return true;
                    }
                    String[] stringArray = (String[])entry.getValue();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        if (this.stringMatches(string, searchCriteria)) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            if (MapUtils.isNotEmpty((Map)httpTimerData.getSessionAttributes())) {
                for (Map.Entry entry : httpTimerData.getSessionAttributes().entrySet()) {
                    if (!this.stringMatches((String)entry.getKey(), searchCriteria) && !this.stringMatches(((String)entry.getValue()).toString(), searchCriteria)) continue;
                    return true;
                }
            }
            MethodIdent methodIdent = repositoryDefinition.getCachedDataService().getMethodIdentForId(httpTimerData.getMethodIdent());
            return super.isSearchCompatible(methodIdent, searchCriteria);
        }
    }

    private static class InvocationSearchFinder
    extends AbstractSearchFinder<InvocationSequenceData> {
        private InvocationSearchFinder() {
        }

        @Override
        public boolean isSearchCompatible(InvocationSequenceData invocationSequenceData, SearchCriteria searchCriteria, RepositoryDefinition repositoryDefinition) {
            MethodIdent methodIdent2;
            if (invocationSequenceData.getTimerData() != null && SearchFactory.isSearchCompatible(invocationSequenceData.getTimerData(), searchCriteria, repositoryDefinition)) {
                return true;
            }
            if (invocationSequenceData.getSqlStatementData() != null && SearchFactory.isSearchCompatible(invocationSequenceData.getSqlStatementData(), searchCriteria, repositoryDefinition)) {
                return true;
            }
            if (invocationSequenceData.getExceptionSensorDataObjects() != null && !invocationSequenceData.getExceptionSensorDataObjects().isEmpty()) {
                for (MethodIdent methodIdent2 : invocationSequenceData.getExceptionSensorDataObjects()) {
                    if (!SearchFactory.isSearchCompatible(methodIdent2, searchCriteria, repositoryDefinition)) continue;
                    return true;
                }
            }
            methodIdent2 = repositoryDefinition.getCachedDataService().getMethodIdentForId(invocationSequenceData.getMethodIdent());
            return super.isSearchCompatible(methodIdent2, searchCriteria);
        }
    }

    private static class JmxSearchFinder
    extends AbstractSearchFinder<JmxSensorValueData> {
        private JmxSearchFinder() {
        }

        @Override
        public boolean isSearchCompatible(JmxSensorValueData jmxSensorValueData, SearchCriteria searchCriteria, RepositoryDefinition repositoryDefinition) {
            if (this.stringMatches(jmxSensorValueData.getValue(), searchCriteria)) {
                return true;
            }
            if (this.stringMatches(NumberFormatter.formatTime(jmxSensorValueData.getTimeStamp()), searchCriteria)) {
                return true;
            }
            JmxDefinitionDataIdent jmxDefinitionDataIdent = repositoryDefinition.getCachedDataService().getJmxDefinitionDataIdentForId(jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            if (jmxDefinitionDataIdent == null) {
                return false;
            }
            return this.stringMatches(jmxDefinitionDataIdent.getDerivedFullName(), searchCriteria);
        }
    }

    private static class SqlSearchFinder
    extends AbstractSearchFinder<SqlStatementData> {
        private SqlSearchFinder() {
        }

        @Override
        public boolean isSearchCompatible(SqlStatementData sqlStatementData, SearchCriteria searchCriteria, RepositoryDefinition repositoryDefinition) {
            String string2;
            if (this.stringMatches(sqlStatementData.getSql(), searchCriteria)) {
                return true;
            }
            if (CollectionUtils.isNotEmpty((Collection)sqlStatementData.getParameterValues())) {
                for (String string2 : sqlStatementData.getParameterValues()) {
                    if (!this.stringMatches(string2, searchCriteria)) continue;
                    return true;
                }
            } else {
                if (this.stringMatches(sqlStatementData.getDatabaseProductName(), searchCriteria)) {
                    return true;
                }
                if (this.stringMatches(sqlStatementData.getDatabaseProductVersion(), searchCriteria)) {
                    return true;
                }
                if (this.stringMatches(sqlStatementData.getDatabaseUrl(), searchCriteria)) {
                    return true;
                }
            }
            string2 = repositoryDefinition.getCachedDataService().getMethodIdentForId(sqlStatementData.getMethodIdent());
            return super.isSearchCompatible((MethodIdent)string2, searchCriteria);
        }
    }

    private static class TimerSearchFinder
    extends AbstractSearchFinder<TimerData> {
        private TimerSearchFinder() {
        }

        @Override
        public boolean isSearchCompatible(TimerData timerData, SearchCriteria searchCriteria, RepositoryDefinition repositoryDefinition) {
            MethodIdent methodIdent = repositoryDefinition.getCachedDataService().getMethodIdentForId(timerData.getMethodIdent());
            return super.isSearchCompatible(methodIdent, searchCriteria);
        }
    }
}

