/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot.datasolver.impl;

import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.AbstractPlotDataSolver;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.PlotDataSolver;
import java.util.HashMap;
import java.util.Map;

public final class PlotDataSolverFactory {
    private Map<PlotDataSolver, AbstractPlotDataSolver> dataSolverMap = new HashMap<PlotDataSolver, AbstractPlotDataSolver>();
    private static PlotDataSolverFactory singleton;

    private PlotDataSolverFactory() {
    }

    private AbstractPlotDataSolver getDataSolverInstance(PlotDataSolver plotDataSolver) {
        if (!this.dataSolverMap.containsKey((Object)plotDataSolver)) {
            try {
                AbstractPlotDataSolver abstractPlotDataSolver = plotDataSolver.getDataSolverImplementation().newInstance();
                this.dataSolverMap.put(plotDataSolver, abstractPlotDataSolver);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.dataSolverMap.get((Object)plotDataSolver);
    }

    private static PlotDataSolverFactory instance() {
        if (singleton == null) {
            PlotDataSolverFactory.createSingleton();
        }
        return singleton;
    }

    private static synchronized void createSingleton() {
        if (singleton == null) {
            singleton = new PlotDataSolverFactory();
        }
    }

    public static AbstractPlotDataSolver getDataSolver(PlotDataSolver plotDataSolver) {
        return PlotDataSolverFactory.instance().getDataSolverInstance(plotDataSolver);
    }

    public static AbstractPlotDataSolver getDefaultDataSolver() {
        return PlotDataSolverFactory.getDataSolver(PlotDataSolver.DEFAULT);
    }
}

