/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.TimerDataAggregator;
import info.novatec.inspectit.rcp.editor.graph.plot.AbstractTimerDataPlotController;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.TimerDataChartingInputDefinitionExtra;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.swt.widgets.Display;

public class TimerPlotController
extends AbstractTimerDataPlotController<TimerData> {
    private List<TimerData> templates;
    private IGlobalDataAccessService dataAccessService;
    private ICachedDataService cachedDataService;
    private IAggregator<TimerData> aggregator;
    List<TimerData> displayedData = Collections.emptyList();
    Date toDate = new Date(0L);
    Date fromDate = new Date(Long.MAX_VALUE);
    Date latestDataDate = new Date(0L);

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.TIMER_DATA_CHARTING_EXTRAS_MARKER)) {
            TimerDataChartingInputDefinitionExtra timerDataChartingInputDefinitionExtra = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.TIMER_DATA_CHARTING_EXTRAS_MARKER);
            this.templates = timerDataChartingInputDefinitionExtra.getTemplates();
        } else {
            TimerData timerData = new TimerData();
            timerData.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
            timerData.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
            timerData.setMethodIdent(inputDefinition.getIdDefinition().getMethodId());
            timerData.setId(-1L);
            this.templates = Collections.singletonList(timerData);
        }
        this.aggregator = new TimerDataAggregator();
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public boolean showLegend() {
        return this.templates.size() > 1;
    }

    @Override
    public void update(Date date, Date date2) {
        Object object2;
        boolean bl;
        ArrayList<TimerData> arrayList = new ArrayList<TimerData>(this.templates);
        boolean bl2 = CollectionUtils.isEmpty(this.displayedData) || this.fromDate.after(date2) || this.toDate.before(date);
        boolean bl3 = this.fromDate.after(date);
        boolean bl4 = bl = this.toDate.before(date2) || this.latestDataDate.before(date2);
        if (bl2) {
            object2 = this.dataAccessService.getTemplatesDataObjectsFromToDate(arrayList, date, date2);
            if (CollectionUtils.isNotEmpty((Collection)object2)) {
                this.fromDate = (Date)date.clone();
                this.toDate = (Date)date2.clone();
            }
            this.displayedData = object2;
        } else {
            List list;
            List object3;
            if (bl && CollectionUtils.isNotEmpty((Collection)(object3 = this.dataAccessService.getTemplatesDataObjectsFromToDate(arrayList, object2 = new Date(this.latestDataDate.getTime() + 1L), date2)))) {
                this.displayedData.addAll(object3);
                this.toDate = (Date)date2.clone();
            }
            if (bl3 && CollectionUtils.isNotEmpty((Collection)(list = this.dataAccessService.getTemplatesDataObjectsFromToDate(arrayList, date, object2 = new Date(this.fromDate.getTime() - 1L))))) {
                this.displayedData.addAll(0, list);
                this.fromDate = (Date)date.clone();
            }
        }
        if (CollectionUtils.isNotEmpty(this.displayedData)) {
            this.latestDataDate = new Date(this.displayedData.get(this.displayedData.size() - 1).getTimeStamp().getTime());
        }
        object2 = new HashMap();
        for (TimerData timerData : this.displayedData) {
            ArrayList<TimerData> arrayList2 = (ArrayList<TimerData>)object2.get(this.getSeriesKey(timerData));
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<TimerData>();
                object2.put(this.getSeriesKey(timerData), arrayList2);
            }
            arrayList2.add(timerData);
        }
        for (Map.Entry entry : object2.entrySet()) {
            entry.setValue(this.adjustSamplingRate((List)entry.getValue(), date, date2, this.aggregator));
        }
        Cloneable cloneable = object2;
        Display.getDefault().asyncExec(new Runnable((Map)((Object)cloneable)){
            private final /* synthetic */ Map val$finalMap;
            {
                this.val$finalMap = map;
            }

            @Override
            public void run() {
                TimerPlotController.this.setDurationPlotData(this.val$finalMap);
                TimerPlotController.this.setCountPlotData(this.val$finalMap);
                if (1 == this.val$finalMap.size()) {
                    List list = (List)this.val$finalMap.entrySet().iterator().next().getValue();
                    TimerPlotController.this.getRootEditor().setDataInput(list);
                } else {
                    TimerPlotController.this.getRootEditor().setDataInput(Collections.emptyList());
                }
            }
        });
    }

    @Override
    protected Comparable<?> getSeriesKey(TimerData timerData) {
        MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
        return TextFormatter.getMethodString(methodIdent);
    }

    @Override
    protected List<TimerData> getTemplates() {
        return this.templates;
    }
}

